/*
 * Copyright (c) 2000 Olivier Gilloire <ogilloire@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

typedef struct _LFB{
	unsigned long base;
	unsigned long mask;
} LFB,*PLFB;

/* the mask is commonly used rather than the size itself.
   a mask made so that : physbase & mask = address_within_range & mask
   for each address_within_range that is in the actual memory area (the LFB here)
   cf the intel software developer manual vol3 (#24319201), chapter 9.11 */
 
int getLFB(LFB lfb[], struct pci_dev *dev)
{
	unsigned long lfbnb = 0, memarea, mask;

/* scan the base adresses for prefetchable areas
   bit 0 set to 0 indicate memory (vs. IO) range
   bit 3 indicates it's prefetchable
   prefetchable means writes can be merged, so we can use write combining here. */

	if (lfbnb >= (sizeof lfb))
		return lfbnb;	/* don't exceed input struct size. */

	memarea = pci_read_long(dev, 0x10);
	if (((memarea & 0x1) == 0) && ((memarea & 0x8) != 0) ) {
	lfb[lfbnb].base = memarea & 0xfffffff0;
		pci_write_long(dev,0x10,0xffffffff);	/* write all 1's to get the mask. */
		mask = pci_read_long(dev,0x10);
		pci_write_long(dev,0x10,memarea);		/* put back the original address.*/
		lfb[lfbnb++].mask = mask & 0xfffffff0;
	}

	if (lfbnb >= sizeof lfb)
		return lfbnb;
	memarea = pci_read_long(dev, 0x14);
	if (((memarea & 0x1) == 0) && ((memarea & 0x8) != 0) ) {
		lfb[lfbnb].base = memarea & 0xfffffff0;
		pci_write_long(dev,0x14,0xffffffff);
		mask = pci_read_long(dev,0x14);
		pci_write_long(dev,0x14,memarea);		/* put back the original address. */
		lfb[lfbnb++].mask = mask & 0xfffffff0;
	}

	if (lfbnb >= sizeof lfb)
		return lfbnb;
	memarea = pci_read_long(dev, 0x18);
	if (((memarea & 0x1) == 0) && ((memarea & 0x8) != 0) ) {
		lfb[lfbnb].base = memarea & 0xfffffff0;
		pci_write_long(dev,0x18,0xffffffff);
		mask = pci_read_long(dev,0x18);
		pci_write_long(dev,0x18,memarea);		/* put back the original address. */
		lfb[lfbnb++].mask = mask & 0xfffffff0;
	}

	return(lfbnb);
}
