/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

#include "hardware/CPU/identify.c"
#include "hardware/select_PCI.c"
#include "hardware/select_CPU.c"

#define node_EMPTY	0
#define node_CPU	1
#define node_PCI	2

struct treenode
{
	int node_type;
	struct pci_dev *node_data;
};


void free_dataptr (gpointer data)
{
	free(data);
}


/* Create_PCI_SubTree */
void Create_PCI_SubTree(GtkCTree* tree, GtkCTreeNode* parent)
{
	GtkCTreeNode* item_new;
	char namebuf[256];
	gchar Array[256];
	gchar *Buffer[1];
	struct treenode *dataptr;

	Buffer[0] = Array;

	dev = pacc->devices;
	
	/* Populate the PCI tree. */
	while (dev) {

		sprintf(Buffer[0], "%s",
			pci_lookup_name(pacc, namebuf, sizeof(namebuf),
				PCI_LOOKUP_VENDOR|PCI_LOOKUP_DEVICE,
				dev->vendor_id, dev->device_id, 0, 0));

		item_new = gtk_ctree_insert_node (tree, parent, NULL, Buffer, 0,
						NULL, NULL, NULL, NULL, TRUE, FALSE);

		//FIXME: The following malloc is never freed.
		//FIXME: If the following malloc fails, the nodes that succeed are not freed.
		dataptr = malloc (sizeof (struct treenode));
		if (dataptr == NULL) {
			printf ("Can't malloc memory for node!\n");
		} else {
			dataptr->node_type = node_PCI;
			dataptr->node_data = dev;
			gtk_ctree_node_set_row_data_full (tree, item_new, dataptr, free_dataptr);
		}
		dev = dev->next;
	}
}


//FIXME: Make this SMP compliant.
// Needs to find the number of CPUs (Without using /proc/cpuinfo
// and also run 'cpuid()' on a specific CPU.

/* Create_CPU_SubTree */
void Create_CPU_SubTree(GtkCTree* tree, GtkCTreeNode* parent)
{
	GtkCTreeNode* item_new;
	char CPUNameString[16];
	gchar Array[128];
	gchar *Buffer[1];
	struct treenode *dataptr;
	int Number_of_CPUs=1, i;
	unsigned int eax, ebx, ecx, edx;

	Buffer[0] = Array;

	/* Populate the CPU tree. */
	for (i=0; i<Number_of_CPUs; i++) {

		cpuid(0, &eax, &ebx, &ecx, &edx);
		regprint (CPUNameString, ebx);
		regprint (CPUNameString+4, edx);
		regprint (CPUNameString+8, ecx);

		sprintf(Buffer[0], "CPU %d : %s", i, CPUNameString);

		item_new = gtk_ctree_insert_node (tree, parent, NULL, Buffer, 0,
						NULL, NULL, NULL, NULL, TRUE, FALSE);

		dataptr = malloc (sizeof (struct treenode));
		if (dataptr == NULL) {
			printf ("Can't malloc memory for node!\n");
		} else {
			dataptr->node_type = node_CPU;
			dataptr->node_data = 0;
			gtk_ctree_node_set_row_data (tree, item_new, dataptr);
		}
	}
}


void selected_row_callback (GtkCTree *ctree, GtkCTreeNode *node, gpointer foo)
{
	struct treenode *event;

	event = gtk_ctree_node_get_row_data (GTK_CTREE(ctree), node);
	if (event != NULL) {

		switch (event->node_type) {

			case node_CPU:		select_CPU_item();
						break;

			case node_PCI:		select_PCI_item(event->node_data);
						break;

			default:		break;
		}
	}
}


/*
 *
 * This is the routine which creates the top level of the tree.
 * It calls all the functions that create all the 'branches' on the tree.
 *
 */

void CreateTree(GtkWidget *scrolled_win)
{
	GtkWidget *tree;
	GtkCTreeNode *item_new;
	gchar titlearray[32];
	gchar *title[1];

	title[0] = titlearray;
    
	/* Create root tree widget */
	tree = gtk_ctree_new(1, 0);

	gtk_clist_set_row_height(GTK_CLIST (tree), 15);
	gtk_ctree_set_line_style (GTK_CTREE (tree), GTK_CTREE_LINES_DOTTED);
	gtk_ctree_set_expander_style (GTK_CTREE (tree), GTK_CTREE_EXPANDER_SQUARE);
	gtk_clist_set_column_width (GTK_CLIST (tree), 0, 150);
	gtk_ctree_set_indent (GTK_CTREE (tree), 15);
	gtk_clist_set_column_auto_resize (GTK_CLIST (tree), 0, TRUE);
	gtk_clist_set_selection_mode (GTK_CLIST (tree), GTK_SELECTION_BROWSE);
	gtk_signal_connect (GTK_OBJECT (tree), "tree_select_row",
			GTK_SIGNAL_FUNC (selected_row_callback), NULL);


//The following part only works on x86 systems for now, so we ifdef it to
//stop the compiler errors. Messy, but it works.
// One day we'll have an arch/ directory, just like the kernel.
// Until some kinda soul sends me a Sparc or an Alpha, this won't be done (not by me at least) [dj]
#ifdef __i386__
	/* CPU tree. */
	sprintf (*title, "CPU");
	item_new = gtk_ctree_insert_node (GTK_CTREE(tree), NULL, NULL, title, 0, NULL, NULL, NULL, NULL, FALSE, FALSE);
	gtk_ctree_node_set_selectable (GTK_CTREE (tree), item_new, FALSE);
	Create_CPU_SubTree(GTK_CTREE(tree), item_new);
#endif

	/* PCI tree. */
	sprintf (*title, "PCI");
	item_new = gtk_ctree_insert_node (GTK_CTREE(tree), NULL, NULL, title, 0, NULL, NULL, NULL, NULL, FALSE, FALSE);
	gtk_ctree_node_set_selectable (GTK_CTREE (tree), item_new, FALSE);
	Create_PCI_SubTree(GTK_CTREE(tree), item_new);

	gtk_container_add (GTK_CONTAINER (scrolled_win), tree);
	gtk_widget_show(tree);
}
