/* defs.h - MemTest-86  Version 2.2
 *
 * Copyright 1999,  Chris Brady
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee
 * is granted provided that the above copyright notice appears in all copies.
 * It is provided "as is" without express or implied warranty.
 */

#define SPINSZ		0x200000
#define DEFTESTS	7
#define MOD_SZ		20
#define BAILOUT		if (bail) goto skip_test;
#define BAILR		if (bail) return;

#define SKIP_START	0xa0000
#define SKIP_END	0x100000
#define APM		1		/* 1 = Turn off APM if available */
#define SCREEN_ADR	0xb8000

#define TITLE_WIDTH 17
#define TIMEX 34
#define LINE_CPU 3
#define COL_CPU 39
#define LINE_TST 1
#define LINE_RANGE 2
#define LINE_PAT 3
#define LINE_CACHE 4
#define LINE_REF 5
#define LINE_PASS 4
#define LINE_ERR 5
#define LINE_SCROLL 7

#define POP_W	30
#define POP_H	10
#define POP_X	(80-POP_W-2)/2
#define POP_Y	(20-POP_H)
#define NULL	0

#define getCx86(reg) ({ outb((reg), 0x22); inb(0x23); })
#define serial_echo_outb(v,a) outb((v),(a)+0x3f8)
#define serial_echo_inb(a)    inb((a)+0x3f8)
#define BOTH_EMPTY (UART_LSR_TEMT | UART_LSR_THRE)
/* Wait for transmitter & holding register to empty */
#define WAIT_FOR_XMITR \
 do { \
       lsr = serial_echo_inb(UART_LSR); \
 } while ((lsr & BOTH_EMPTY) != BOTH_EMPTY)

void itoa(char s[], int n); 
void reverse(char *p);
void serial_echo_init();
void serial_echo_print(char *s);
void ttyprint(int y, int x, char *s);
void ttyprintc(int y, int x, char c);
void cprint(int y,int x,char *s);
void hprint(int y,int x,unsigned long val);
void xprint(int y,int x,unsigned long val);
void aprint(int y,int x,unsigned long val);
void dprint(int y,int x,unsigned long val,int len, int right);
void movinv1(int iter, long p1,long p2);
void movinv32(int iter, long p1, long lb, long mb, int sval, int off);
void modtst(int off, int iter, long p1, long p2);
void error(long* adr,long good,long bad);
void ad_err1(long adr1,long adr2,long good,long bad);
void ad_err2(long adr,long bad);
void do_spin(int dots);
void init();
void inter();
void set_cache(int val);
void set_refresh(int val);
void check_input();
void footer();
void scroll();
void popup();
void popdown();
void popclear();
void get_config();
void cpu_type();
void addr_tst1();
void addr_tst2();
long getval(int x, int y);
int get_key();
int cpuspeed();
int check_ram();

extern long idt_descr;
extern long trap_regs[];

extern __inline__ void cache_off()
{
        __asm__("push %eax\n\t"
		"movl %cr0,%eax\n\t"
                "orl $0x40000000,%eax\n\t"  /* Set CD */
                "movl %eax,%cr0\n\t"
		".byte 0x0f,0x09\n\t"	/* Invalidate and flush cache */
		"pop  %eax\n\t");
}
extern __inline__ void cache_on()
{
        __asm__("push %eax\n\t"
		"movl %cr0,%eax\n\t"
                "andl $0x9fffffff,%eax\n\t" /* Clear CD and NW */ 
                "movl %eax,%cr0\n\t"
		"pop  %eax\n\t");
}

extern __inline__ void reboot()
{
        __asm__(
		"movl %cr0,%eax\n\t"
       		"andl  $0x00000011,%eax\n\t"
       		"orl   $0x60000000,%eax\n\t"
       		"movl  %eax,%cr0\n\t"
       		"movl  %eax,%cr3\n\t"
		"movl  %cr0,%ebx\n\t"
		"andl  $0x60000000,%ebx\n\t"
		"jz    f\n\t"
		".byte 0x0f,0x09\n\t"	/* Invalidate and flush cache */
		"f: andb  $0x10,%al\n\t"
		"movl  %eax,%cr0\n\t"
		"movw $0x0010,%ax\n\t"
		"movw %ax,%ds\n\t"
		"movw %ax,%es\n\t"
		"movw %ax,%fs\n\t"
		"movw %ax,%gs\n\t"
		"movw %ax,%ss\n\t"
		"ljmp  $0xffff,$0x0000\n\t");
}

struct mmap {
	int v;
	volatile long *start;
	volatile long *end;
};

struct tseq {
	short cache;
	short ref;
	short pat;
	short iter;
	char *msg;
};

struct cpu_ident {
	char type;
	char model;
	char step;
	char fill;
	long cpuid;
	long capability;
	char vend_id[12];
	char cache_info[16];
};

/* Define common variables for normal and relocated test locations */
struct vars {
	int firsttime;
	int test;
	int pass;
	long *eadr;
	long exor;
	int msg_line;
	int ecount;
	int msegs;
	int cache_flag;
	int ref_flag;
	int xtst_flag;
	int testsel;
	int scroll_start;
	int rdtsc;
	struct mmap map[4];
	struct mmap rmap[4];
	volatile unsigned long lim_lower;
	volatile unsigned long lim_upper;
	unsigned long clks_msec;
	unsigned long starth;
	unsigned long startl;
	unsigned long snaph;
	unsigned long snapl;
};
