#ifndef __GNC_HELPERS__
#define __GNC_HELPERS__

#include <guile/gh.h>
#include "gnc-common.h"
#include "Transaction.h"

SCM      gnc_timespec2timepair(Timespec t);
Timespec gnc_timepair2timespec(SCM x);
int      gnc_timepair_p(SCM x);

Timespec gnc_transaction_get_date_posted(Transaction *t);
Timespec gnc_transaction_get_date_entered(Transaction *t);

Timespec gnc_split_get_date_reconciled(Split *s);

void gnc_transaction_set_date_posted(Transaction *t, const Timespec d);
void gnc_transaction_set_date_entered(Transaction *t, const Timespec d);

void gnc_transaction_set_date(Transaction *t, Timespec ts);

char * gnc_gettext_helper(const char *string);

/* See Group.h for info about traversals. */

gncBoolean gnc_scmGroupStagedTransactionTraversal(AccountGroup *grp,
                                                  unsigned int stage,
                                                  SCM thunk);

gncBoolean gnc_scmAccountStagedTransactionTraversal(Account *a,
                                                    unsigned int stage,
                                                    SCM thunk);

#endif
