#! /bin/sh
#
# apcupsd
#     Start the APC UPS daemon to monitor power status.
#
# Modified for Debian GNU/Linux by Leon Breedt <ljb@debian.org>
# Last update: Wed Jul 14 15:14:50 SAST 1999

DAEMON=/usr/sbin/powersc

test -x $DAEMON || exit 0

set -e

case "$1" in
  start)
    if [ "`pidof apcupsd`" = "" ]
    then
        $DAEMON INIT
    else
        echo "A copy of the daemon is still running.  If you just stopped it,"
        echo "please wait about 5 seconds for it to shut down."
        exit 0
    fi
	;;
  stop)
        $DAEMON STOP
	;;
  restart|force-reload)
        $DAEMON RESTARTME
	;;
  *)
	echo "Usage: /etc/init.d/apcupsd {start|stop|restart}" >&2
	exit 1
	;;
esac

exit 0
