#!/bin/sh
#
#  checketc.sh - check whether $SGML_ETC_DIR is ok.
#
#  $Id: checketc.sh,v 1.3 1998/10/17 20:21:17 cg Exp $
#
#  SGMLtools - an SGML toolkit.
#  Copyright (C) 1998 Cees A. de Groot
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#

doc='
NAME

    checketc.sh - see whether $SGML_ETC_DIR is there.

SYNOPSIS

   checketc.sh

DESCRIPTION

    The subroutine checketc checks whether the contents of $SGML_ETC_DIR are
    in compliance with the SGML directory standard as described in 
    ../doc/sgml-dir/standard.sgml.

NOTE

    checketc expects to be called from autoconf.
'

. ./profile

#
#  See whether everything is there.
#
if [ -d $SGML_ETC_DIR -a -d $SGML_ETC_DIR/catalog.d -a \
     -f $SGML_ETC_DIR/sgml.conf ]; then
    exit 0
fi

#
#  We're missing stuff. See whether this user is allowed to set it up.
#
mkdir $SGML_ETC_DIR >/dev/null 2>&1 
if [ ! -w $SGML_ETC_DIR ]; then
    cat <<EOF

You don't seem to have $SGML_ETC_DIR setup as described in the document
doc/sgml-dir-standard.sgml. This directory is necessary for SGMLtools
to operate correctly.

As you don't have write privileges on /etc, you need to change
your user-id to something more privileged and re-run the script
tools/checketc.sh. If you cannot obtain higher privileges than you
currently have, please contact your administrator. It might help if
you show him the SGML directory standard document so he knows why this
directory is necessary.

Summary: after obtaining the necessary privileges, inspect and run the
script tools/checketc.sh with the command:

% sh tools/checketc.sh

EOF
    exit 1
fi

#
#  Great, we can continue.
#
cat <<EOF

Welcome to the $SGML_ETC_DIR configuration script. This will setup a default
configuration that should be valid for most systems. After this script
has run, please review the file $SGML_ETC_DIR/sgml.conf and check whether
you are satisfied with the defaults.

EOF

#
#  Check directories, and create
#
if [ ! -d "$SGML_ETC_DIR/catalog.d" ]; then
    echo "Create directory $SGML_ETC_DIR/catalog.d"
    mkdir $SGML_ETC_DIR/catalog.d
fi

#
#  Create configuration file
#
if [ ! -f "$SGML_ETC_DIR/sgml.conf" ]; then
    echo "Create file $SGML_ETC_DIR/sgml.conf";
    cat >$SGML_ETC_DIR/sgml.conf <<EOF;
#
#  SGML configuration file
#
#  This file contains variable assignments in bourne-shell syntax:
#
#  var=value
#
#  without internal spaces.
#
#  Please review the contents of this file. Plurally named variables may
#  have multiple directories on the right-hand side, separated by colons.
#  Example:
#  SGML_BASE_DIR=/usr/share/sgml
#  SGML_EXTRA_BASE_DIRS=/usr/local/share/sgml:/opt/sgml/share:/u/hack/sgml/share
#
SGML_BASE_DIR=$SGML_SHARE_DIR/sgml
SGML_EXTRA_BASE_DIRS=
SGML_BIN_DIR=$SGML_BIN_DIR
SGML_EXTRA_BIN_DIRS=
SGML_TMP_DIR=/tmp
EOF
    echo "SGML_POSTPROCESS_CMD='"$SGML_BIN_DIR"/buildcat >$SGML_ETC_DIR/catalog'" >>$SGML_ETC_DIR/sgml.conf
    echo "All done. Please review $SGML_ETC_DIR/sgml.conf"
    exit 0
fi

echo "All done."
exit 0

