#
# Check for union wait (taken from GNU make 3.75).
#
AC_DEFUN(AX_UNION_WAIT,
[AC_CHECK_FUNCS(waitpid)
AC_CACHE_CHECK(for union wait, ax_cv_union_wait,
[AC_TRY_LINK([
#include <sys/types.h>
#include <sys/wait.h>],[
union wait status;
int pid;
pid = wait (&status);
#ifdef WEXITSTATUS
/* Some POSIXoid systems have both the new-style macros and the old
   union wait type, and they do not work together.  If union wait
   conflicts with WEXITSTATUS et al, we don't want to use it at all.  */
if (WEXITSTATUS (status) != 0) pid = -1;
#ifdef WTERMSIG
/* If we have WEXITSTATUS and WTERMSIG, just use them on ints.  */
-- blow chunks here --
#endif
#endif
#ifdef HAVE_WAITPID
/* Make sure union wait works with waitpid.  */
pid = waitpid (-1, &status, 0);
#endif
], [ax_cv_union_wait=yes], [ax_cv_union_wait=no])])
if test "$ax_cv_union_wait" = yes; then
  AC_DEFINE(HAVE_UNION_WAIT)
fi
])

#
# Check for struct utimbuf (taken from GNU fileutils 3.16).
#
AC_DEFUN(AX_HAVE_STRUCT_UTIMBUF,
[AC_HEADER_TIME
AC_CHECK_HEADERS(utime.h)
AC_CACHE_CHECK(for struct utimbuf, ax_cv_have_struct_utimbuf,
[AC_TRY_COMPILE([#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif
#ifdef HAVE_UTIME_H
#include <utime.h>
#endif], [static struct utimbuf x; x.actime = x.modtime;
], [ax_cv_have_struct_utimbuf=yes], [ax_cv_have_struct_utimbuf=no])])
if test $ax_cv_have_struct_utimbuf = yes; then
   AC_DEFINE(HAVE_STRUCT_UTIMBUF)
fi
])
