/*
 * GUI window header
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_GUIWIN_H__
#define __GDIFF_GUIWIN_H__

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

	
#include "properties.h" /* for WinPref */
	
/*
 * Data structure definitions
 */
/* Window(equivalent to GtkWindow) data
 * From an intuitive perspective, this is related to one window. */
struct _GDiffWindow {
	GnomeApp *app;
	GnomeAppBar *appbar;/* status bar */
	GtkNotebook *notebook;
	GtkFileSelection *filesel;
	
	GList *gdirv_list;/* Doubly linked list of GDiffDirViews */
	GList *gfilev_list;/* Doubly linked list of GDiffFileViews */

	WinPref pref;/* Currently, it's always the same as g_pref's value. */
};

	
/* Global function declarations */
/* guiwin.h */
extern GDiffWindow* gdiff_window_new(const char *geometry_string);

/* files.c */ 
extern void files_open(GDiffWindow *gdwin);

/* statusbar.c */
extern void statusbar_create(GDiffWindow *gdwin);
extern void statusbar_update(GDiffWindow *gdwin, const char *msg);
	
	
#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_GUIWIN_H__ */
