#include "file_util.hh"
#include "file_exceps.hh"

// POSIX headers
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>

#include <fstream>

namespace autil {

  void open_file(ifstream & in, const string & file, int mode = ios::in) {
    in.open(file.c_str(), mode);
    if (in.rdstate() & ios::badbit )
      throw CantReadFile(file);
  }
    
  string add_possible_dir(const string & dir, const string & file) {
      if (file.size() && file[0] == '/' || (file[0] == '.' 
					    && file.size() > 1
					    && file[1] == '/'))
	return file;
      else
	return dir + "/" + file;
  }
  
  void open_file_readlock(fstream & in, const string & file) {
    in.open(file.c_str(), ios::in);
    if (in.rdstate() & ios::badbit )
      throw CantReadFile(file);
    int fd = in.rdbuf()->fd();
    struct flock fl;
    fl.l_type   = F_RDLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start  = 0;
    fl.l_len    = 0;
    if (fcntl(fd, F_SETLKW, &fl) == -1) {
      in.close();
      throw CantReadFile(file);
    }
  }

  void open_file_writelock(fstream & inout, const string & file) {
    inout.open(file.c_str(), ios::in | ios::out);
    if (inout.rdstate() & ios::badbit )
      throw CantWriteFile(file);
    int fd = inout.rdbuf()->fd();
    struct flock fl;
    fl.l_type   = F_WRLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start  = 0;
    fl.l_len    = 0;
    if (fcntl(fd, F_SETLKW, &fl) == -1)
      throw CantWriteFile(file);
  }
}

