/* This is part of tmview, a dvi previewer. (c) 1995 Thomas Moor         */
/*                                                                       */
/* This program may be used without any warranty. It may be modified and */
/* distributed without any restrictions.                                 */


/* 
The source in this file handles some aspects of the PSFile-special.  
At a first step, the arguments of the special are interpreted in 
order to draw a bounding box. At a second step, we try to
call ghostscript to render the eps-file. This is done much less
sophisticated than it is in xdvi. Still, part of the code is inspired
by xdvi.
*/

#include "defs.h"

/*#define DEBUGEPS    /* debug eps-file reading, rendering etc. */
/*#define DEBUGEPSS /* parsing of special arguments */

/* 
This file handles some aspects of the PSFile-special.  
At a first step, the arguments of the special are interpreted in 
order to draw a bounding box. At a second step, we try to
call ghostscript to render the eps-file. This is done much less
sophisticated than it is in xdvi. Still, part of the code comes
from xdvi.
*/

/* #define DEBUGEPS      /* general */
/* #define DEBUGEPSS     /* parsing special */

/**********************************************************/
/* gscriptlist: array of espfiles within one dvifile      */
/**********************************************************/


void initgscript(void){
#ifdef DEBUGEPS
  pfprot("(initgscript)");
#endif
  gslistfirst=NULL;
  gslistlast=NULL;
};

void killgscript(void){
  gslistelement* gse;
#ifdef DEBUGEPS
  pfprot("(killgscript");
#endif
  gse=gslistfirst;
  while(gse!=NULL){
    freemem(&(gse->gsfile));
    freemem(&(gse->argfile));
    freemem(&(gse->code));
    freelrumem(&(gse->bmp2.bits));
    freelrumem(&(gse->bmp.bits));
    gse=gse->nextgse;
  }  
  gslistfirst=NULL;
  gslistlast=NULL;
#ifdef DEBUGEPS
  pfprot(")");
#endif
}

gslistelement* allocgscript(char* gsfile, char* argfile, short w, short h, float res, char* code){
#ifdef DEBUGEPS
  pfprot("(allocgscript %s %d %d %.3f",gsfile, w, h, res);
#endif
  if(gslistlast!=NULL){
    allocmem(&(gslistlast->nextgse),sizeof(gslistelement));
    gslistlast=gslistlast->nextgse;
  } else {
    allocmem(&gslistfirst,sizeof(gslistelement));
    gslistlast=gslistfirst;
  }
  gslistlast->nextgse=NULL; 
  gslistlast->gsfile=NULL;
  gslistlast->argfile=NULL;
  stralloccpy(&(gslistlast->gsfile), gsfile);
  stralloccpy(&(gslistlast->argfile), argfile);
  gslistlast->bmp2.w=w;
  gslistlast->bmp2.h=h;
  gslistlast->bmp2.bits=NULL;
  gslistlast->bmp2.type=GREYSCALE;
  gslistlast->bmp.w=w;
  gslistlast->bmp.h=h;
  gslistlast->bmp.bits=NULL;
  gslistlast->bmp.type=BLACKNWHITE;
  gslistlast->res=res;
  gslistlast->code=code;
  gslistlast->suspect=B_SUSPECT;
#ifdef DEBUGEPS
  pfprot(")");
#endif
  return(gslistlast);
}



gslistelement* searchgscript(char* gsfile, short w, short h,float res, char* code){
  int i;
  gslistelement* gse;
#ifdef DEBUGEPS
  pfprot("(searchgsciptlist %s %d %d %.3f ",gsfile, w, h, res);
#endif
  gse=gslistfirst;
  while(gse!=NULL){
    if(gse->bmp2.w==w){
    if(gse->bmp2.h==h){
    if(gse->res==res){
    if(strcmp(gse->gsfile,gsfile)==0){
    if(strcmp(gse->code,code)==0){
#ifdef DEBUGEPS
      pfprot(" found)");
#endif
      return(gse);
    }}}}}
    gse=gse->nextgse;
  }
#ifdef DEBUGEPS
  pfprot(" not found)");
#endif
  return(NULL);
}     


/****************************************************************************/
/* parsing the arguments of the PSFile-special                              */
/* this is to be called from the dvi-reader when a special occures          */
/****************************************************************************/

double ox;
#define GR 0.0174533 /* 2Pi/360 */
#define ROTATE(a,x,y) ox=x;x=x*cos(a*GR)-y*sin(a*GR);y=ox*sin(a*GR)+y*cos(a*GR)


int checkndoEpsFile(char* specstr, long h, long v, double sconv, double svconv){
   
  char argfile[MAXPATHSTR+1];
  double  argllx, arglly, argurx, argury;
  double  argrwi, argrhi, argangle;

  int  gotllx=0, gotlly=0, goturx=0, gotury=0;
  int  gotrwi=0, gotrhi=0, gotangle=0, gotclip=0;
 
  char *cp_beg, *cp_end, *cp;
  char ch;

  char lfullfile[MAXPATHSTR+1];
  char lpath[MAXPATHSTR+1];
  char dvipath[MAXPATHSTR+1];
  long width, height, lwidth, lheight;
  float resolution, vscale;
  short xpxl, ypxl;
  long needmem;

  double normllx, normlly, normurx, normury;
  double bboxAx, bboxAy, bboxBx, bboxBy;
  double bboxCx, bboxCy, bboxDx, bboxDy;

  char gscode1[MAXPATHSTR+GSARGLEN];
  char gscode3b[GSARGLEN];
  char gscode3c[GSARGLEN];
  char gscode3e[GSARGLEN];
  char gscode3f[GSARGLEN];
  char* gscode;

  gslistelement* gse;
  drawlistdata* data;

#ifndef LETSTRYGS
  return(0);
#endif
  cp=specstr;
  if (STRNCASECMP(cp, "PSFile=", 7) != 0) return(0);
#ifdef DEBUGEPS
  pfprot("(checkndoEpsFile: checkndo <%s> ...)",specstr);
#endif

/* PART 1: Get the filename ****************************/

  cp += 7;
  ch=' ';  
  if (*cp == '\'' || *cp == '"'){
    ch=*cp;
    ++cp;
  }
  cp_beg=cp;
  while(*cp != '\0' && *cp != ch) ++cp;
  if (*cp=='\0') {
    pfverb("(epsfile: cant get filename in <%s>)",specstr);
    return(1);
  }
  cp_end=cp++;
  if(cp_end-cp_beg>MAXPATHSTR) 
     {pfverb("\nfatal error: memory .. epsfile ??\n");exit(1);}  
  strncpy(argfile,cp_beg,(int) (cp_end-cp_beg));
  argfile[(int) (cp_end-cp_beg)]=0;

  pathoffile(visfmk->dvifilename,dvipath);
  sprintf(lpath,"./:%s%c%c",dvipath,DIRSEPCHAR,DIRSEPCHAR);
#ifdef DEBUGEPS
  pfprot("(eps: msearch path <%s>)",lpath);
#endif
  
  if(msearch(lpath,argfile,lfullfile)==0){
     pfverb("(epsfile: <%s> not found)", argfile);
     return(1);
  }
#ifdef DEBUGEPS
  pfverb("(eps: file <%s>)",lfullfile);
#endif

/* PART 2: Get other args ******************************/

  while(*cp != '\0') {
    while(isspace(*cp)) ++cp;
    cp_beg=cp;  
    while (*cp != '=' && !isspace(*cp) && *cp != '\0') ++cp;
    cp_end=cp; 
    if(*cp == '=') ++cp;
  
    if(STRNCASECMP(cp_beg,"clip",cp_end-cp_beg) == 0) {
      gotclip=1;
#ifdef DEBUGEPSS
      pfprot("eps, mark 2: clip=\n");
#endif
    } else {
    if(STRNCASECMP(cp_beg,"llx",cp_end-cp_beg) == 0) {
      argllx=atof(cp);
      gotllx=1;
#ifdef DEBUGEPSS
      pfprot("eps, mark 2: llx=<%.3f>\n",argllx);
#endif
    } else {
    if(STRNCASECMP(cp_beg,"lly",cp_end-cp_beg) == 0) {
      arglly=atof(cp);
      gotlly=1;
#ifdef DEBUGEPSS
      pfprot("eps, mark 2: lly=<%.3f>\n",arglly);
#endif
    } else {
    if(STRNCASECMP(cp_beg,"urx",cp_end-cp_beg) == 0) {
      argurx=atof(cp);
      goturx=1;
#ifdef DEBUGEPSS
      pfprot("eps, mark 2: urx=<%.3f>\n",argurx);
#endif
    } else {
    if(STRNCASECMP(cp_beg,"ury",cp_end-cp_beg) == 0) {
      argury=atof(cp);
      gotury=1;
#ifdef DEBUGEPSS
      pfprot("eps, mark 2: ury=<%.3f>\n",argury);
#endif
    } else {
    if(STRNCASECMP(cp_beg,"rwi",cp_end-cp_beg) == 0) {
      argrwi=atof(cp);
      gotrwi=1;
#ifdef DEBUGEPSS
      pfprot("eps, mark 2: rwi=<%.3f>\n",argrwi);
#endif
    } else {
    if(STRNCASECMP(cp_beg,"rhi",cp_end-cp_beg) == 0) {
      argrhi=atof(cp);
      gotrhi=1;
#ifdef DEBUGEPSS
      pfprot("eps, mark 2: rhi=<%.3f>\n",argrhi);
#endif
    } else {
    if(STRNCASECMP(cp_beg,"angle",cp_end-cp_beg) == 0) {
      argangle=atof(cp);
      gotangle=1; 
#ifdef DEBUGEPSS
      pfprot("eps, mark 2: angle=<%.3f>\n",argangle);
#endif
    } else { 
      pfverb("(epsfile: unknown keyword at %d in <%s>)",(int) (cp_beg-specstr), specstr);
    }}}}}}}}

    while (!isspace(*cp) && *cp != '\0') ++cp; /* skip value ie float */
    while (isspace(*cp)) ++cp;                 /* skip spces */
  }    
/* PART 3: BoundingBox calculus ...  ***********************/

/* PART 3A:  Figure out actual dimensions and resolution **/
  if(    (gotrwi && gotllx && gotlly && goturx && gotury)
      || (gotrhi && gotllx && gotlly && goturx && gotury) ) {
  } else {
     pfverb("(epsfile: cannot figure out dimensions in <%s>)", specstr);
     return(1);
  }
  if((argury-arglly)<=0 || (argurx-argllx)<=0) {
     pfverb("(epsfile: nonpositive  dimensions in <%s>)", specstr);
     return(1);
  }
  if(gotrwi==0) argrwi=argrhi * (argurx-argllx) / (argury-arglly);
  if(gotrhi==0) argrhi=argrwi * (argury-arglly) / (argurx-argllx);
  if(argrwi==0 || argrhi==0) {
     pfverb("(epsfile: nonpositive  dimensions in <%s>)", specstr);
     return(1);
  }
  argrhi=argrhi/10;  /* convert to 1/72in */
  argrwi=argrwi/10;  /* convert to 1/72in */
  resolution= sconv * 0x10000L * 72.27 * argrwi/ (argurx-argllx); /* ??? 72.27 */
#ifdef DEBUGEPSS
  pfprot("eps, mark 3A: argll=(%.2f,%.2f) argur=(%.2f,%.2f) rwi=%.2f rhi=%.2f  res=%.2f\n",
      argllx,arglly,argurx,argury,argrwi,argrhi,resolution);
#endif


/* PART 3B: translate to (-llx,-lly), */
  normllx=0;             normlly=0;
  normurx=argurx-argllx; normury=argury-arglly;
#ifdef DEBUGEPSS
  pfprot("eps, mark 3B: normll=(%.2f,%.2f) normur=(%.2f,%.2f)\n",
      normllx,normlly,normurx,normury);
#endif


/* PART 3C: scale verticale if both rhi and rwi are given */
  if(gotrhi & gotrwi){ 
    vscale=argrhi / argrwi / (argury-arglly) * (argurx-argllx);
    normury*=vscale;
  } else {
    vscale=1; /* prevent rounding errors */
  }        
#ifdef DEBUGEPSS
  pfprot("eps, mark 3C: normll=(%.2f,%.2f) normur=(%.2f,%.2f) vsc=%.2f\n",
      normllx,normlly,normurx,normury,vscale);
#endif

/* PART 3D: add extra pt; */
  if(!gotclip){
    normllx-=(GSEXTRAPT + 72. * GSEXTRAPXL/resolution);
    normlly-=(GSEXTRAPT + 72. * GSEXTRAPXL/resolution);
    normurx+=(GSEXTRAPT + 72. * GSEXTRAPXL/resolution);
    normury+=(GSEXTRAPT + 72. * GSEXTRAPXL/resolution);
  #ifdef DEBUGEPSS
    pfprot("eps, mark 3D: normll=(%.2f,%.2f) normur=(%.2f,%.2f)\n",
        normllx,normlly,normurx,normury);
  #endif
  }
/* Part 3E: rotate */
  if(gotangle){
    bboxAx=normllx;  bboxAy=normlly;
    bboxBx=normurx;  bboxBy=normlly;
    bboxCx=normurx;  bboxCy=normury;
    bboxDx=normllx;  bboxDy=normury;
    ROTATE(argangle,bboxAx,bboxAy);
    ROTATE(argangle,bboxBx,bboxBy);
    ROTATE(argangle,bboxCx,bboxCy);
    ROTATE(argangle,bboxDx,bboxDy);
    normllx=MIN(bboxAx,MIN(bboxBx,MIN(bboxCx,bboxDx)));
    normurx=MAX(bboxAx,MAX(bboxBx,MAX(bboxCx,bboxDx)));
    normlly=MIN(bboxAy,MIN(bboxBy,MIN(bboxCy,bboxDy)));
    normury=MAX(bboxAy,MAX(bboxBy,MAX(bboxCy,bboxDy)));
#ifdef DEBUGEPSS
    pfprot("eps, mark 3E: normll=(%.2f,%.2f) normur=(%.2f,%.2f) angle=%.1f\n",
      normllx,normlly,normurx,normury,argangle);
#endif
  }

  
/* Part 3F: convert this to pixels */
  xpxl  = LFLOOR(sconv * (h + 0x10000L* normllx*argrwi/(argurx-argllx))); 
  ypxl  = LCEIL(svconv* (v - 0x10000L* normlly*argrwi/(argurx-argllx)));
  /* re-convert, in order to prevent  for rounding errors */
  normllx= (((double) xpxl)/sconv -h)/ ((double)(0x10000L))/argrwi*(argurx-argllx); 
  normlly=-(((double) ypxl)/svconv -v)/ ((double)(0x10000L))/argrwi*(argurx-argllx); 
  width=  LCEIL(sconv* 0x10000L*(normurx-normllx)*argrwi/(argurx-argllx));
  height= LCEIL(svconv*0x10000L*(normury-normlly)*argrwi/(argurx-argllx));
#ifdef DEBUGEPSS
    pfprot("eps, mark 3F: normll=(%.2f,%.2f) pxl=(%d,%d) width=%d height=%d\n",
      normllx,normlly,xpxl,ypxl,width,height);
#endif



/* Part 3G: actual l(oad)width and lheight differs due to grey scaling */  
  lwidth=width;
  lheight=height;
#if GSGREY != 1
  if(colors!=BLACKNWHITE && fshrink>2.) {
    lwidth=GSGREY*width;
    lheight=GSGREY*height;
  }    
#endif
  if(lheight <= 0 || lwidth <=0 || lwidth > 0x7fff || lheight > 0x7fff) {
    pfprot("(epsfile: ignoring <%s>, too large)", specstr);
    return(1);
  } 
#ifdef DEBUGEPSS
  pfprot("eps, mark 3G: lwidth=%d lheight=%d\n",lwidth,lheight);
#endif


/* PART 4: Add gscommand to drawlist  **************************/
  if(doeps==DOEPS){
    needmem=((long)lheight)*((long)ROUNDUP(lwidth,BITS_PER_BMUNIT)) 
       *BYTES_PER_BMUNIT;
    if(needmem > MAXLINMEM) { /* try blacknwhit only */
      lheight=height;
      lwidth=width;
    }
    needmem=((long)lheight)*((long)ROUNDUP(lwidth,BITS_PER_BMUNIT)) 
       *BYTES_PER_BMUNIT;
    if(needmem > MAXLINMEM){
      pfverb("(epsfile: ignoring <%s>, too large)", specstr);
    } else {
      sprintf(gscode1,GSCODEFILE,lfullfile);
      sprintf(gscode3b,GSCODETRANS,-argllx,-arglly);
      sprintf(gscode3c,GSCODESCALE,1.,vscale);
      if(gotangle) sprintf(gscode3e,GSCODEROTATE,argangle); else *gscode3e=0;
      sprintf(gscode3f,GSCODETRANS,-normllx,-normlly);
      allocmem(&gscode,40+strlen(gscode1)+strlen(gscode3b)
        +strlen(gscode3c)+strlen(gscode3e)+strlen(gscode3f));
      sprintf(gscode,"%s\n %s\n %s\n %s\n %s\n",
        gscode3f,gscode3e,gscode3c,gscode3b,gscode1);
#ifdef DEBUGEPSS
      pfprot("eps, mark 4: gscode=\n<%s>\n",gscode);
#endif
      gse=searchgscript(lfullfile,width,height,resolution,gscode);
      if(gse==NULL){ 
        gse=allocgscript(lfullfile,argfile,width,height,resolution,gscode);
        gse->bmp.w=lwidth;
        gse->bmp.h=lheight;
      } else {
        freemem(&gscode);
      }
      data=drawlistadd(*drawgscript);
      (*data).gscript.h=xpxl;  
      (*data).gscript.v=ypxl-height;
      (*data).gscript.gse=gse;
    }
  }
/* PART 4: Add frame to drawlist  **************************/
#ifndef DEBUGEPS
  if(doeps==DONTEPS || needmem > MAXLINMEM){
#endif
    data=drawlistadd(*drawrulebg);
    (*data).rect.c=TFMCOL;
    (*data).rect.x=xpxl; (*data).rect.y=ypxl-height;
    (*data).rect.w=width; (*data).rect.h=1;  
    data=drawlistadd(*drawrulebg);
    (*data).rect.c=TFMCOL;
    (*data).rect.x=xpxl; (*data).rect.y=ypxl-1;
    (*data).rect.w=width; (*data).rect.h=1;  
    data=drawlistadd(*drawrulebg);
    (*data).rect.c=TFMCOL;
    (*data).rect.x=xpxl; (*data).rect.y=ypxl-height;
    (*data).rect.w=1; (*data).rect.h=height;  
    data=drawlistadd(*drawrulebg);
    (*data).rect.c=TFMCOL;
    (*data).rect.x=xpxl+width-1; (*data).rect.y=ypxl-height;
    (*data).rect.w=1; (*data).rect.h=height;   
#ifndef DEBUGEPS
  }
#endif

#ifdef DEBUGEPS
  pfprot("(checkndoEpsFile: done)");
#endif       
  return(1);
}

/******************************************************************************/
/* Lets load the bmps, i.e. run ghostscript                                   */
/******************************************************************************/


#define GSPIPE_OUT_READ   gspipeout[0] /* read bits from gs's output */
#define GSPIPE_OUT_WRITE  gspipeout[1] 
#define GSPIPE_IN_READ    gspipein[0]
#define GSPIPE_IN_WRITE   gspipein[1]  /* write commands to gs's input */

/* if POSIX O_NONBLOCK is not available, use O_NDELAY */
#if !defined(O_NONBLOCK) && defined(O_NDELAY)
#define	O_NONBLOCK O_NDELAY
#endif


pid_t gspid;
int gspipeout[2];
int gspipein[2];
int gsrunning;
FILE* gs_out_read;
FILE* gs_in_write;


int startgs(char* epsname, short width, short height, float res, char* gscode) {
  int returncode;
  int i;
  char gsargsize[GSARGLEN];
  char gsargres[GSARGLEN];

  gsrunning=0;
  if(pipe(gspipeout) || pipe(gspipein)){
    pfverb("(startgs: pipes failed)");
    return(1);
  }
  sprintf(gsargsize,GSARGSIZE,width,height);
  sprintf(gsargres,GSARGRES,res,res);
#ifdef DEBUGEPS
  pfprot("(startgs: args <%s %s>)",gsargsize,gsargres);
#endif
  
  gspid=fork();
  if(gspid == 0){
    dup2(GSPIPE_IN_READ,   STDIN_FILENO);
    dup2(GSPIPE_OUT_WRITE, STDOUT_FILENO);
    /*dup2(GSPIPE_OUT_WRITE, STDERR_FILENO);*/
    close(GSPIPE_IN_READ);  /* dont need this desc. in child */ 
    close(GSPIPE_OUT_WRITE);
    close(GSPIPE_IN_WRITE); 
    close(GSPIPE_OUT_READ);  
    /* system(echo "HI") */
    execlp(GSBIN,
      GSARG0,GSARG1,GSARG2,GSARG3,GSARG4,GSARG5,gsargsize,gsargres,GSARGLAST,NULL);
    exit(1); /*shall not happen !*/
  }
  if(gspid < (pid_t) 0){
    pfverb("(startgs: fork failed)");
    return(1);
  }
#ifdef DEBUGEPS
  pfprot("(startgs: gspid %d)",gspid);
#endif
  /*sleep(5);*/
  gs_in_write=(FILE*)fdopen(GSPIPE_IN_WRITE, "w");
  /* guarantee gspid (and hence the pipes) to be alive */
  if(gs_in_write!=NULL){  
    fputs(GSCODEINTRO,gs_in_write);
    fputs(gscode,gs_in_write);
    fputs(GSCODEQUIT,gs_in_write);
    fclose(gs_in_write);  
  }
  /* dont need this desc. in parent */
  close(GSPIPE_OUT_WRITE);
  close(GSPIPE_IN_READ);
  gsrunning=1;
  return(0);
}


#define TIMEOUT 2


int waitio(void){
  fd_set set;
  struct timeval timeout;
  int sel;
  
  FD_ZERO(&set);
  FD_SET(GSPIPE_OUT_READ, &set);
#ifdef VGAHASWAITIO   /* select cares about keybord */
  timeout.tv_sec = TIMEOUT;
  timeout.tv_usec = 0;
#else               /* select ignores keybord */
  timeout.tv_sec = 0;
  timeout.tv_usec = 100000L; /* 0.1 sec */
#endif;
#ifdef DEBUGEPS   
  printf("<"); fflush(stdout); 
#endif  
  sel=vgawaitio(&set, NULL, &timeout);
#ifdef DEBUGEPS   
  printf("%d>",sel); 
#endif  
  return sel;
}

volatile sig_atomic_t timeout;

void sigalarmhandler(int sig){
  timeout=1;
  signal(sig, sigalarmhandler);
}
     

int readgs(bitmap *bmp2){   
  uchar buff[GSBLOCKLEN];
  uchar *sp, *buffend;
  long bufflen;
  uchar c;
  long  count;
  long expected;
  uchar ukey;
  short i,jbit,jbm;
  long lshift;
  BMUNIT *dp;

  int returncode;


  
/* set GSPIPE_OUT_READ to non-blocking I/O ... | O_NONBLOCK */
/* set GSPIPE_OUT_READ to generate SIGIO   ... | O_ASYNC */
  fcntl(GSPIPE_OUT_READ, F_SETFL,
    fcntl(GSPIPE_OUT_READ, F_GETFL, 0) | O_NONBLOCK);

  signal(SIGALRM, sigalarmhandler);

  gs_out_read=(FILE*)fdopen(GSPIPE_OUT_READ, "r");
  if(gs_out_read==NULL || gsrunning==0) return(B_SUSPECT);
#ifdef DEBUGEPS
  pfprot("(eps: start reading pipe ...");
#endif
  dp=bmp2->bits;
  jbit=0; 
  jbm=0; 
  lshift=BITS_PER_BMUNIT-8; 
  count=0;
  expected=ROUNDUP(bmp2->w,8)*bmp2->h;
  expected=MIN(expected,bmp2->h*bmp2->bmu_wide*BYTES_PER_BMUNIT);
  ukey=KEYNOP;
  timeout=0;

  while(
     ukey==KEYNOP                    /* no user-interrupt so far */
  && count < expected                /* not all bytes yet read   */
  && (gsrunning==1 || returncode==0) /* runs or finished ok */ 
  && timeout==0){                    /* still in time */
    ukey=vgagetchar(2);
    if(gspid==waitpid(gspid, &returncode, WNOHANG)) {
      gsrunning=0;
      returncode=WEXITSTATUS(returncode);
      alarm(TIMEOUT); /* prevent from hanging */  
    }   
    bufflen=fread(buff,1L,GSBLOCKLEN,gs_out_read);
#ifdef VGAHASWAITIO   
    if(bufflen==0 && count==0) waitio(); 
#endif
    if(bufflen!=0 && count==0) pfverb(".");
    buffend=buff+bufflen;
    sp=buff;
    while(sp<buffend && count<expected) {
      /*putchar (*sp);*/	
      count++;
      dp[jbm] |= (*sp++ << lshift);
      jbit+=8;
      if(lshift) lshift-=8;
      else {
        lshift=BITS_PER_BMUNIT-8; 
        jbm++;
      }
      if(jbit>=bmp2->w) {
	jbit=0;
	jbm=0;
	lshift=BITS_PER_BMUNIT-8;
        dp+=bmp2->bmu_wide;
      }
    } /* while buff */
  }
#ifdef DEBUGEPS
  pfprot("... pipe done)");
#endif
  pfverb(".");
  alarm(0);
  fclose(gs_out_read);
  close(GSPIPE_OUT_READ);
  close(GSPIPE_IN_WRITE);
  
  if(gsrunning) {
    kill(gspid, SIGKILL);
    waitpid(gspid, &returncode, 0);
    returncode=WEXITSTATUS(returncode);
    gsrunning=0;
  }
  if(ukey==KEYESC)
    vgagetchar(1); /* flush */
  if(returncode!=0)
    ukey=KEYESC; 

#ifdef DEBUGEPS
   pfprot("(eps: expected %d bytes, read %d bytes,returncode %d)",
       expected,count,returncode);
#endif
   if(expected!=count && ukey==KEYNOP)
     pfverb(" error: expected %dbytes, read %dbytes, exitcode %d",
       expected,count,returncode);

  if(expected==count)
    return(B_OK);
  if(ukey==KEYESC)
    return(B_ESCAPE);
  if(ukey!=KEYNOP)
    return(B_SKIPONCE);
  return(B_SUSPECT);
}



void  gsloadbmp(gslistelement* gse) {
  int i,j, gsres;
  char mess[MAXPATHSTR];
  
  
#ifdef DEBUGEPS
  pfprot("(gsloadbmp: %s %d %d %.2f ...)",
     gse->gsfile,gse->bmp2.w,gse->bmp2.h, gse->res);
#endif

  if(gse->suspect==B_ESCAPE) return;

  /* user message, similar to ingorethis, */
  sprintf(mess,"... RENDERING <%s> (%dx%d)",gse->argfile,gse->bmp.w,gse->bmp.h);
  if(vgastatuslines!=1) drawstatusline();
  drawsr(mess,0,0,vgastatuslen);
  statusforce=0;
  drawstatuspage();
  vgaupdatestatus();
  statusforce=1; 

  pfverb("(%s",gse->argfile); 

  gse->bmp.type=BLACKNWHITE;
  freelrumem(&(gse->bmp.bits));
  freelrumem(&(gse->bmp2.bits));
  alloc_bitmapbw(&gse->bmp); /* alloclrumem + set bmu_wide */
#ifdef DEBUGEPS
  for(i=0;i<gse->bmp.h;i++) {    
    for(j=0;j<gse->bmp.bmu_wide;j++) {
      gse->bmp.bits[j+ gse->bmp.bmu_wide*i] |=  1 << (i & (BITS_PER_BMUNIT-1));
    }
  }
#endif
  startgs(gse->gsfile,
       gse->bmp.w,gse->bmp.h, 
       gse->res*gse->bmp.w/gse->bmp2.w, gse->code); 
  gse->suspect=readgs(&gse->bmp);
  if(gse->suspect!=B_OK)
    freelrumem(&(gse->bmp.bits));
  if(gse->suspect==B_ESCAPE){
    sprintf(mess,"ERROR/INTERRUPT WHILE RENDERING <%s> (%dx%d)",
      gse->argfile,gse->bmp.w,gse->bmp.h);
    drawsr(mess,0,0,vgastatuslen);  
    vgaupdatestatus();
    /*sleep(2);*/
    statusforce=2; /* Hack: 2<>keep once, then force */ 
  }
  if(gse->bmp.w!=gse->bmp2.w && gse->suspect==B_OK){
#ifdef DEBUGEPS
    pfprot("(gsload: shrinking ...)");
#endif
    cheapshrinkgs(&gse->bmp,&gse->bmp2);
    freelrumem(&(gse->bmp.bits));
    pfverb(".");
  }
#ifdef DEBUGEPS
  pfprot("gsloadbmp: done)");
#endif
  pfverb(")");      
}








