/*
 * wadalab font (downlodable PostScript font)
 */
#include	"defs.h"
#include	"global.h"
#include	"bifont.h"
#ifdef KPATHSEA
#include	<kpathsea/pathsearch.h>
#include	<kpathsea/tex-file.h>
#endif

void
init_wl_fontinfo(fe)
struct font_entry *fe;
{
    int	jmm_markchar();
    void read_wl_fontinfo();

    biinifinfo(fe) = alloc_jbiinif(biaccinfo(fe)->bf);
    fe->fnt_markchar = jmm_markchar;
    fe->fnt_readfontinfo = read_wl_fontinfo;
}

static void
wlpave(path, proto, k)
char *path, *proto;
int k;
{
    register char *p, *s, *t;
    char *pend;
    int len;
    char buf[32];

    for (p = path, s = proto, pend = path+PATHLEN-1; *s != '\0'; s++)
	if (*s == '%') {
	    switch (*++s) {
	    case 'K':
		(void)sprintf(t = buf, "%2x", k);
		break;
	    default:
		*(t = buf) = *s;  *(t+1) = '\0';
		break;
	    }
	    if (p + (len = strlen(t)) <= pend) {
		(void)strncpy(p, t, len);
		p += len;
	    } else
		Fatal("font path too long %s", proto);
	} else if (p < pend) {
	    *p++ = *s;
	} else
	    Fatal("font path too long %s", proto);
    *p = '\0';
}

struct wlfntinfo *
read_wl_finfo(fe, bii, jfmfi, settfmw)
struct font_entry *fe;
struct biinitfontinfo *bii;
struct jfmfntinfo *jfmfi;
BOOLEAN settfmw;
{
    struct wlfntinfo *wlfi;
    int i, k1, kk, c, k1end;
    BOOLEAN k1init;
    char k1wlfn[PATHLEN], *filename;
    FILE *k1fp;
#ifdef KPATHSEA
    char pathname[PATHLEN];
    char *path, *base;
    const_string savepath;
    kpse_format_info_type *spec = &kpse_format_info[kpse_type1_format];
#endif

    wlfi = (struct wlfntinfo *)
	alloc_check(malloc((unsigned)sizeof(struct wlfntinfo)+
			   bii->maxc*sizeof(struct wlchar_entry)),
		    "wlfont info");
    wlfi->wl_bf = bii->bf;
    for (i = 0; i <= bii->maxc; i++)
	wlfi->ch[i].dev_font = DEV_NULLFONT;

    for (k1 = 0, kk = 0, k1end = 0; k1 < bii->maxc/94+1; k1++) {
	k1init = FALSE;
	k1end += 94;
	if (k1end > bii->maxc+1)
	    k1end = bii->maxc+1;
	for (kk = k1*94; kk < k1end; kk++) {
	    if (!(bii->mark[kk]))
		continue;
	    if (!k1init) {
		wlpave(k1wlfn, dev_wlpath(bii->bf), k1+0x21);
#ifdef KPATHSEA
		pavek(pathname, &path, &base, k1wlfn, NULL);
		if (path != NULL) {
		    savepath = spec->path;
		    spec->path = NULL;
		    spec->override_path = path;
		}
		if (spec->path == NULL)
		    kpse_init_format(kpse_type1_format);
		if (base == NULL)
		    filename = kpse_find_file(fe->n, kpse_type1_format, false);
		else if (path == NULL)
		    filename = kpse_find_file(base, kpse_type1_format, false);
		else
		    filename = kpse_path_search(spec->path, base, false);
		if (path != NULL)
		    spec->path = savepath;
		if (filename == NULL)
		    filename = k1wlfn;
#ifdef DEBUG
		if (Debuguser && filename != NULL)
		    (void)fprintf(stderr, "trying type1font file %s\n", filename);
#endif
#else
		filename = k1wlfn;
#endif
#ifdef DEBUG
		if (Debuguser)
		    (void)fprintf(stderr, "wadalabfont open %s (for %s)\n",
				  filename, fe->n);
#endif
		if ((k1fp = fopen(filename, "r")) == NULL) {
		    Warning("chars 0x%2xXX in %s not found (open failed)",
			    k1+0x21, fe->n);
		    break;
		}
		k1init = TRUE;
	    }
	    c = idx94_to_jis(kk);
	    if (settfmw)
		(wlfi->ch+kk)->tfmw = jfmfi->ch[getctype(c,jfmfi)].tfmw;
	    dev_wl_initfontdict(fe, wlfi, kk, c, k1fp);
	}
	if (k1init)
	    (void)fclose(k1fp);
    }
    dev_wl_endfontdict();

    return wlfi;
}

void
read_wl_fontinfo(fe)
struct font_entry *fe;
{
    struct biinitfontinfo *bii;
    struct jfmfntinfo *jfmfi;
    void read_jfm_finfo();

    bii = biinifinfo(fe);
    jfmfi = NEW(struct jfmfntinfo, "jfmfont info");
    jfmfi->jfm_bf = bii->bf;
    jfmfinfo(fe) = jfmfi;
    read_jfm_finfo(fe);

    dev_wl_initfe(fe);
    dev_wl_begfontdict(fe);
    wlfinfo(fe) = read_wl_finfo(fe, bii, jfmfi, TRUE);

    free((char *)bii);
    free((char *)jfmfi->ctype);
    free((char *)jfmfi->ch);
    free((char *)jfmfi);
}

DEV_FONT
wl_fontdict(fe, c)
struct font_entry *fe;
int c;
{
    return wlfinfo(fe)->ch[jis_to_idx94(c)].dev_font;
}


/* jstfm
 */
void
init_jswl_fontinfo(fe)
register struct font_entry *fe;
{
    struct jsubshare *jss;
    int	jsmm_markchar();
    void read_jswl_fontinfo();

    jss = jstfmfinfo(fe)->js_share;
    if (jss->jss_stat < JSS_INIT) {
	jss->jss_info = (struct jssinfo *)alloc_jbiinif(jss->jss_bf);
	jss->jss_stat = JSS_INIT;
    }
    jstfmfinfo(fe)->js_info = jss->jss_info;
    fe->fnt_markchar = jsmm_markchar;
    fe->fnt_readfontinfo = read_jswl_fontinfo;
}

void
read_jswl_fontinfo(fe)
struct font_entry *fe;
{
    struct biinitfontinfo *bii;
    struct jsubshare *jss;
    void read_jstfm_finfo();

    read_jstfm_finfo(fe);

    dev_jswl_initfe(fe);
    jss = jstfmfinfo(fe)->js_share;
    if (jss->jss_stat < JSS_READ) {
	bii = (struct biinitfontinfo *)jss->jss_info;
	dev_jswl_begfontdict(fe);
	jss->jss_info = (struct jssinfo *)
	    read_wl_finfo(fe, bii, NULL, FALSE);
	jss->jss_stat = JSS_READ;
	free((char *)bii);
    }
    jstfmfinfo(fe)->js_info = jss->jss_info;
}

DEV_FONT
jswl_fontdict(fe, c)
struct font_entry *fe;
int c;
{
    struct jstfmfntinfo *jsfi = jstfmfinfo(fe);

    return jswlfinfo(jsfi)->ch[jsub_to_idx94(jsfi->jsubfont,c)].dev_font;
}
