$!
$! @(#)genidx.com	6.4 99/04/11
$!
$! Generate xmcd Local Discography per-category index files.  This is the
$! equivalent of genidx.sh for use on the OpenVMS platform.
$! OpenVMS versions: 6.0 and later, tested with 7.1 on VAX(tm) machines
$!
$!    xmcd  - Motif(tm) CD Audio Player
$!    cda   - Command-line CD Audio Player
$!    libdi - CD Audio Player Device Interface Library
$!
$!    Copyright (C) 1993-1999  Ti Kan
$!    E-mail: ti@amb.org
$!    Contributing author: Michael Monscheuer
$!    E-mail: monscheuer@t-online.de
$!
$!    This program is free software; you can redistribute it and/or modify
$!    it under the terms of the GNU General Public License as published by
$!    the Free Software Foundation; either version 2 of the License, or
$!    (at your option) any later version.
$!
$!    This program is distributed in the hope that it will be useful,
$!    but WITHOUT ANY WARRANTY; without even the implied warranty of
$!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
$!    GNU General Public License for more details.
$!
$!    You should have received a copy of the GNU General Public License
$!    along with this program; if not, write to the Free Software
$!    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
$!
$!    -------------------------------------------------------------------
$!
$!	First off, some definitions for output formatting, then check out
$!      the existance of the logical name $DISCOGDIR which should point
$!	at xmcd's [.discog] directory. In case the logical does not exist
$!	inform the user and exit.
$!
$	CR[0,8]=13
$	LF[0,8]=10
$	BELL[0,8]=7
$	IF F$VERIFY()
$	 THEN
$	  CR = "<CR>"
$	  LF = "<LF>"
$	  BELL = "^G"
$	ENDIF
$	IF F$TRNLNM("$DISCOGDIR") .EQS. "" 
$	 THEN
$	  WRITE SYS$OUTPUT "''BELL'''CR'''LF'%GIX-F-NLNM, no logical name match, logical $DISCOGDIR not defined."
$	  EXIT
$	ENDIF
$!
$!	Setup symbol DISCOGDIR for this procedure's internal use derived 
$!	from the logical name $DISCOGDIR. Set default to this directory
$!	and start looking for category subdirectories in this location.
$!
$	WRITE SYS$OUTPUT "''CR'''LF'%GIX-I-GENIDX, generating xmcd Local Discography category index."
$	ENVI = F$ENVIRONMENT("DEFAULT")
$	IDENT = F$ENVIRONMENT("PROCEDURE")
$	IDENT = IDENT - F$PARSE(IDENT,,,"VERSION") + ";0"
$	SET DEFAULT $DISCOGDIR:[000000]
$	DISCOGDIR = F$TRNLNM("$DISCOGDIR")
$	DISK = F$ELEMENT(0,":",DISCOGDIR)
$	DISCOGDIR = DISCOGDIR - "''DISK':[" - "]"
$	DIR = ""
$ GETDIR:
$	NAM = F$ELEMENT(0,".",DISCOGDIR)
$	IF NAM .EQS. "" THEN GOTO GOTDIR
$	DIR = DIR + "/''NAM'"
$	DISCOGDIR = DISCOGDIR - "''NAM'."
$	GOTO GETDIR
$ GOTDIR:
$!	
$!	Found category subdirectory, set default to this location and
$!	cleanup obsolete files before generating the particular catgeory's
$!	index file.
$!	
$	DISCOGDIR = "''DISK'''DIR'"
$ CATEGORY_LOOP:	
$	NEXTDIR = F$SEARCH("*.DIR;*",1)
$	IF NEXTDIR .EQS. "" THEN GOTO DONE
$	NEXTDIR = F$PARSE(NEXTDIR,,,"NAME")
$	WRITE SYS$OUTPUT "%GIX-S-IDXCAT, generating ''NEXTDIR' category index."
$	SET DEF [.'NEXTDIR']
$	IF F$SEARCH("INDEX.HTML") .NES. "" THEN DELETE/NOCONFIRM INDEX.HTML;*
$	'NEXTDIR'_IDX = 0
$	OPEN/WRITE 0 INDEX.HTML
$	WRITE 0 "<!-- xmcd Local Discography index"
$	WRITE 0 "     DO NOT EDIT: Generated by @(#)genidx.com	6.4 99/04/11"
$	WRITE 0 "     Copyright (C) 1993-1999 Ti Kan"
$	WRITE 0 "     E-mail: xmcd@amb.org URL: http://metalab.unc.edu/tkan/xmcd/"
$	WRITE 0 "     Contributing author: Michael Monscheuer, E-mail: Monscheuer@t-online.de -->"
$	WRITE 0 "<HTML>"
$	WRITE 0 "<HEAD>"
$	WRITE 0 "<TITLE>xmcd: Local Discographies index for &quot;''NEXTDIR'&quot;</TITLE>"
$	WRITE 0 "</HEAD>"
$	WRITE 0 "<BODY BGCOLOR=""#FFFFFF"" BACKGROUND=""/''DISCOGDIR'/bkgnd.gif"">"
$	WRITE 0 "<DIV ALIGN=""center"">"
$	WRITE 0 "<A HREF=""http://metalab.unc.edu/tkan/xmcd/"">"
$	WRITE 0 "<IMG SRC=""/''DISCOGDIR'/xmcdlogo.gif"" ALT=""xmcd"" BORDER=""0""></A>"
$	WRITE 0 "<H3>Local Discography: Index for &quot;''NEXTDIR'&quot;</H3>"
$	WRITE 0 "<P>"
$!	
$!	Now check out the existance of INDEX.HTML files in the particular
$!	category's subdirectories. Branch depending upon circumstances.
$!	
$ IDX_LOOP:
$	NEXTIDX = F$SEARCH("[.*]INDEX.HTML;0",2)
$	IF NEXTIDX .EQS. "" 
$	 THEN
$	  IF .NOT. 'NEXTDIR'_IDX
$	   THEN
$	    WRITE 0 "<B>No entries found in this category</B>"
$	    WRITE 0 "<P>"
$	   ELSE
$	    WRITE 0 "</TABLE>"
$	    WRITE 0 "<P>"
$	  ENDIF
$	  GOSUB BOTTOM
$	  SET DEFAULT [-]
$	  GOTO CATEGORY_LOOP
$	ENDIF
$!	
$!	Add each entry found in the subdirectories to the category's
$!	INDEX.HTML entry table.
$!	
$	IF 'NEXTDIR'_IDX .EQ. 1 THEN GOTO SKIP_TABLE
$	WRITE 0 "<TABLE CELLSPACING=""0"" CELLPADDING=""2"" BORDER=""1"""
$	WRITE 0 "<TR>"
$	WRITE 0 "<TD ALIGN=""center"">Disc ID</TD>"
$	WRITE 0 "<TD ALIGN=""center"">Description<BR></TD>"
$	WRITE 0 "</TR>"
$	'NEXTDIR'_IDX = 1
$ SKIP_TABLE:
$!	
$!	Search CD's INDEX.HTML for title information and extract it for
$!	it to the category's INDEX.HMTL entry table.
$!	
$	NEXTIDD = F$PARSE(NEXTIDX,,,"DIRECTORY")
$	DISCID = F$EXTRACT(F$LENGTH(NEXTIDD)-9,8,NEXTIDD)
$	SEARCH/EXACT/OUT=TMP.TMP [.'DISCID']INDEX.HTML "<!-- tItLe: "
$	OPEN/READ 10 TMP.TMP
$	READ 10 LINE
$	CLOSE 10
$	DELETE/NOCONFIRM TMP.TMP;0
$	CDTITLE = LINE - "<!-- tItLe: " - " -->"
$
$	WRITE 0 "<TR>"
$	WRITE 0 "<TD ALIGN=""left"">"
$	WRITE 0 "<A HREF=""/''DISCOGDIR'/''NEXTDIR'/''DISCID'/index.html"">''DISCID'</A>"
$	WRITE 0 "</TD>"
$	WRITE 0 "<TD ALIGN=""left"">"
$	WRITE 0 "''CDTITLE'"
$	WRITE 0 "<BR></TD>"
$	WRITE 0 "</TR>"
$	GOTO IDX_LOOP
$ BOTTOM:
$!	
$!	Add bottom part to the particular category's INDEX.HTML
$!	
$	WRITE 0 "To re-generate this page, please run ''IDENT'"
$	WRITE 0 "<P>"
$	WRITE 0 "</DIV>"
$	WRITE 0 "<H4>Local Discography</H4>"
$	WRITE 0 "<P>"
$	WRITE 0 "<UL>"
$	WRITE 0 "<LI>Browse category:"
$	WRITE 0 "<UL>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/rock/index.html"">rock</A>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/jazz/index.html"">jazz</A>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/blues/index.html"">blues</A>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/folk/index.html"">folk</A>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/reggae/index.html"">reggae</A>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/newage/index.html"">newage</A>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/classical/index.html"">classical</A>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/country/index.html"">country</A>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/soundtrack/index.html"">soundtrack</A>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/misc/index.html"">misc</A>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/data/index.html"">data</A>"
$	WRITE 0 "</UL>"
$	WRITE 0 "</LI>"
$	WRITE 0 "<LI><A HREF=""/''DISCOGDIR'/discog.html"">How to set up Local Discography</A></LI>"
$	WRITE 0 "</UL>"
$	WRITE 0 "<H4>Links</H4>"
$	WRITE 0 "<P>"
$	WRITE 0 "<UL>"
$	WRITE 0 "<LI><A HREF=""http://metalab.unc.edu/tkan/xmcd/"">Browse the official Xmcd web site</A></LI>"
$	WRITE 0 "<LI><A HREF=""http://www.cddb.com/"">Browse the official CDDB web site</A></LI>"
$	WRITE 0 "<LI><A HREF=""http://www.yahoo.com/Entertainment/Music/Reviews/"">Browse music reviews</A></LI>"
$	WRITE 0 "</UL>"
$	WRITE 0 "<HR>"
$	WRITE 0 "<FONT SIZE=""-1"">Generated on ''F$TIME()' by @(#)genidx.com	6.4 99/04/11</FONT>"
$	WRITE 0 "</BODY>"
$	WRITE 0 "</HTML>"
$	CLOSE 0
$	RETURN
$ DONE:
$!	
$!	Index processing and generation complete. Resubmit procedure for 
$!	subsequent execution if possible. Set default back to original
$!	value and exit.
$!	If you do not want automatic resubmission of this procedure please
$!	uncomment the following line.
$!
$!	GOTO EXIT
$!
$	WRITE SYS$OUTPUT ""
$	CHKQ = "SYS$BATCH"
$	DUM = F$GETQUI("")
$ CHQXS:
$	QNAM= F$GETQUI("DISPLAY_QUEUE","QUEUE_NAME","*")
$	IF QNAM .EQS. "" 
$	 THEN 
$	  IF CHKQ .EQS. "XMCD$BATCH" THEN GOTO EXIT
$	  CHKQ = "XMCD$BATCH"
$	  DUM = F$GETQUI("")
$	  GOTO CHQXS
$	ENDIF
$	IF QNAM .NES. "''CHKQ'" THEN GOTO CHQXS
$	SUBMIT/QUEUE='CHKQ'/NOLOG/NOPRINT/AFTER="TOMORROW+03:00" 'IDENT'
$ EXIT:
$	WRITE SYS$OUTPUT ""
$	SET DEF 'ENVI'
$	EXIT
