#!/bin/sh
# the next line restarts using wish \
exec wish8.0 "$0" "$@"

package require -exact snack 1.6
package require http

option add *font {Helvetica 10 bold}
set width 500
set home http://www.speech.kth.se/snack/
set version ""
set colors {#000 #006 #00B #00F #03F #07F #0BF #0FF #0FB #0F7 \
	    #0F0 #3F0 #7F0 #BF0 #FF0 #FB0 #F70 #F30 #F00}

sound s1 -load ex1.wav
sound s2

snack::menuInit
snack::menuPane File
snack::menuCommand File About { tk_messageBox -icon info -type ok \
	-title "About Widget Demo" -message \
	"Snack sound extension demonstration\n\n\
	Get the latest version at $home\n\n\
	Copyright (c) 1997-1999\n\nKare Sjolander"
}
snack::menuCommand File "Version" {
    set version "Looking up latest version at $home ..."
    catch {::http::geturl $home/$tcl_platform(platform).date -command CheckV}
}
snack::menuCommand File Quit exit

snack::menuPane Settings
snack::menuCommand Settings Volume... {snack::gainBox pr}
if {[audio inputs] != ""} {
    foreach jack [audio inputs] {
	audio input $jack v(in$jack)
	snack::menuCheck Settings $jack v(in$jack)
    }
}
if {[audio outputs] != ""} {
    foreach jack [audio outputs] {
	audio output $jack v(out$jack)
	snack::menuCheck Settings $jack v(out$jack)
    }
}

proc CheckV token {
    global version
    set version "Your version of Snack was released June 22, 1999. \
	    Latest version released [::http::data $token]."
}

# Title label

pack [frame .t] -pady 15
pack [label .t.l -text "Snack Sound Extension Demonstrations"\
	-font {Helvetica 14 bold}]

# Basic sound handling

snack::createIcons
pack [frame .f0] -pady 5
pack [label .f0.l -text "Basic sound handling:"] -anchor w
label  .f0.time -text "0.00 sec" -width 10
button .f0.br -bitmap record -command {s2 record ; Timer} -fg red
button .f0.bs -bitmap stop -command {s2 stop ; after cancel Timer}
button .f0.bp -bitmap play -command {s2 play}
button .f0.bu -bitmap pause -command {s2 pause}
button .f0.bl -image snackOpen -command OpenSound
button .f0.ba -image snackSave -command SaveSound
pack .f0.br .f0.bs .f0.bp .f0.bu .f0.bl	.f0.ba .f0.time -side left

proc OpenSound {} {
    set filename [snack::getOpenFile]
    if {$filename == ""} return
    s2 read $filename
    .f0.time config -text [format "%.2f sec" [s2 length -units seconds]]
}

proc SaveSound {} {
    set filename [snack::getSaveFile]
    if {$filename == ""} return
    s2 write $filename
}

proc Timer {} {
    .f0.time config -text [format "%.2f sec" [s2 length -units seconds]]
    after 100 Timer
}

# Canvas item types

pack [canvas .c -width 720 -height 240 -highlightthickness 0] -pady 15
.c create text 0 0 -text "Waveform canvas item type:" -anchor nw
.c create waveform 0 20 -sound s1 -height 100 -width $width -frame yes
.c create text 0 120 -text "Spectrogram canvas item type:" -anchor nw
.c create spectrogram 0 140 -sound s1 -hei 100 -wid $width -colormap $colors
.c create text 500 0 -text "Section canvas item type:" -anchor nw
.c create section 500 20 -sound s1 -height 220 -width 220 -frame yes -start 9002 -end 12000

pack [frame  .f1] -pady 5
pack [label  .f1.l  -text "Waveform examples:" -wi 22 -anchor w] -side left
pack [button .f1.b1 -text "Simple" -com {Exec MinWave.tcl}] -side left
pack [button .f1.b2 -text "See Code" -com {Browse MinWave.tcl}] -side left
pack [button .f1.b3 -text "Fancy" -com {Exec Waveform.tcl}] -side left
pack [button .f1.b4 -text "See Code" -com {Browse Waveform.tcl}] -side left
pack [frame  .f2] -pady 5
pack [label  .f2.l  -text "Spectrogram examples:" -wi 22 -anchor w] -side left
pack [button .f2.b1 -text "Simple" -com {Exec MinSpeg.tcl}] -side left
pack [button .f2.b2 -text "See Code" -com {Browse MinSpeg.tcl}] -side left
pack [button .f2.b3 -text "Fancy" -com {Exec Spectrogram.tcl}] -side left
pack [button .f2.b4 -text "See Code" -com {Browse Spectrogram.tcl}] -side left
pack [frame  .f3] -pady 5
pack [label  .f3.l -text "Section examples:" -wi 22 -anchor w] -side left
pack [button .f3.b1 -text "Simple" -com {Exec MinSect.tcl}] -side left
pack [button .f3.b2 -text "See Code" -com {Browse MinSect.tcl}] -side left
pack [button .f3.b3 -text "Fancy" -com {Exec Section.tcl}] -side left
pack [button .f3.b4 -text "See Code" -com {Browse Section.tcl}] -side left
pack [frame  .f4] -pady 5
pack [label  .f4.l -text "Sound viewers:"] -side left
pack [button .f4.b1 -text "Simple" -com {Exec cool.tcl}] -side left
pack [button .f4.b2 -text "xs" -com {Exec xs.tcl ex2.wav ex2.phn}] -side left
pack [label .v -textvar version]

source widutil.tcl
