#include "gcd.h"

void ncurses_init()
{  
   printf("\033\050\125");
   
   initscr();	
   cbreak();
   noecho();
   nonl();
   nodelay(stdscr, TRUE);
   intrflush(stdscr, FALSE);
   keypad(stdscr, TRUE);

   if (has_colors() == FALSE)
   {
     endwin();
     printf("You're console doesn't appear to have color capabilities.\n");
     printf("This program currently doesn't support your terminal.\n\n");
     exit(0);
   }

   start_color();  

   init_pair(C_WHITE, COLOR_WHITE, COLOR_BLACK);
   init_pair(C_BLUE, COLOR_BLUE, COLOR_BLACK);
   init_pair(C_GREEN, COLOR_GREEN, COLOR_BLACK);
   init_pair(C_RED, COLOR_RED, COLOR_BLACK);
   init_pair(C_MAGENTA, COLOR_MAGENTA, COLOR_BLACK);
   init_pair(C_CYAN, COLOR_CYAN, COLOR_BLACK);
   init_pair(C_YELLOW, COLOR_YELLOW, COLOR_BLACK);
   init_pair(C_BLUE_HL, COLOR_WHITE, COLOR_BLUE);
   init_pair(C_MAGENTA_HL, COLOR_WHITE, COLOR_MAGENTA);
   init_pair(C_RED_HL, COLOR_WHITE, COLOR_RED);
   init_pair(C_CYAN_HL, COLOR_WHITE, COLOR_CYAN);
   init_pair(C_BLUE_YELLOW, COLOR_YELLOW, COLOR_BLUE);
   init_pair(C_MAGENTA_YELLOW, COLOR_YELLOW, COLOR_MAGENTA);
   init_pair(C_GREEN_YELLOW, COLOR_BLACK, COLOR_GREEN);
   init_pair(C_BLACK, COLOR_BLACK, COLOR_BLACK);
   init_pair(C_GREEN_HL, COLOR_WHITE, COLOR_GREEN);
   init_pair(C_BLUE_BOX, COLOR_CYAN, COLOR_BLUE);
   
/* mbox = newwin(10, 60, 1, 1);
   wbkgd(mbox, COLOR_PAIR(C_BLUE_BOX) | 32);
   box(mbox,ACS_VLINE,ACS_HLINE); 
*/

   attrset(COLOR_PAIR(C_BLUE_HL)|A_BOLD);
   draw_line(23,0,80);
   draw_line(24,0,80);   
   
// wrefresh(mbox);
}
