/*
 * color_win.c source file for extace (color picker)
 * 
 * /GDK/GNOME sound (esd) system output display program
 * 
 * Copyright (C) 1998 by Michael Fullbright
 * Re-hacked to look good by The Rasterman
 * 
 * Hacked some more by Dave J. Andruczyk <dave@techdev.buffalostate.edu>
 * to be fully scalable with lots of new options, for tilting the axis's
 * and various other cool stuff.
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You use this program at your own risk.
 */

#include <config.h>
#include <globals.h>
#include <protos.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <time.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>


// See globals.h for variable declarations and DEFINES

gint color_event (GtkWidget *widget, GdkEventButton *event)
{

    gdouble colsel_colors[3];
    gint handled = FALSE;
    GtkWidget *colorsel;

    /* where did the user press the button */
    color_loc = widget->allocation.height - event->y;
    colsel_colors[0] = cr[color_loc]/255.0;
    colsel_colors[1] = cg[color_loc]/255.0;
    colsel_colors[2] = cb[color_loc]/255.0;

    /* Check if we've received a button pressed event */
    
           if (event->type == GDK_BUTTON_PRESS && colorseldlg == NULL)
	   {
	       /* Yes, we have an event and there's no colorseldlg yet! */
	       colorseldlg = gtk_color_selection_dialog_new("Select color");

	       /* Get the ColorSelection widget */

	       colorsel = GTK_COLOR_SELECTION_DIALOG(colorseldlg)->colorsel;

	       /* Connect to the "color_changed" signal, set the client-data
		*          *             * to the colorsel widget */

	       gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorseldlg)->ok_button), "clicked",(GtkSignalFunc)color_button, (gpointer)OK);
				  
	       gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorseldlg)->cancel_button), "clicked",(GtkSignalFunc)color_button, (gpointer)CANCEL);
	       /* Show the dialog */
	       
	       /* Set the color in the selction dialog to wherever we clicked */


		gtk_color_selection_set_color (GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(colorseldlg)->colorsel),colsel_colors);


	       gtk_widget_show(colorseldlg);
	   }

    return handled;

}
int color_button(GtkWidget *widget, gpointer data)
{
    if (data == (gpointer)OK)
    {
	color_changed_cb(NULL,GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(colorseldlg)->colorsel));
	update_gradient(NULL, color_loc);
	init_colortab();
	gtk_widget_destroy(colorseldlg);
	colorseldlg=NULL;
    }
    else if (data == (gpointer)CANCEL)
    {
	gtk_widget_destroy(colorseldlg);
	        colorseldlg=NULL;
    }
    return TRUE;
}
void color_changed_cb (GtkWidget *widget, GtkColorSelection *colorsel)
{
    gdouble color[3];
    GdkColormap *colormap;

    /* Get drawingarea colormap */

    colormap = gdk_window_get_colormap (grad_win->window);

    /* Get current color */

    gtk_color_selection_get_color (colorsel,color);

    /* Fit to a unsigned 16 bit integer (0..65535) and
     *      *         * insert into the GdkColor structure */

    temp_color.red = (guint16)(color[0]*255.0);
    temp_color.green = (guint16)(color[1]*255.0);
    temp_color.blue = (guint16)(color[2]*255.0);

}
void update_gradient(GtkWidget *widget, int y)
{
//    y = MAXBANDS-y;
    if (y <= 16) // start color
	start = temp_color;
    if ((y > 16) && (y <= 48)) // part 2 color
	pt2 = temp_color;
    if ((y > 48) && (y <= 80)) // part 3 color
	pt3 = temp_color;
    if ((y > 80) && (y <= 112)) // part 4 color
	pt4 = temp_color;
    if (y > 112) // end color
	end = temp_color;
}

void init_colortab(void)
{
    gint i,j;
    gint w, h;
    gint r,g,b;

    unsigned char *data;

    j=0;
    for(i=0;i<32;i++)
    {
	cr[j]=(((31-i)*start.red)+(i*pt2.red))/31;
	cg[j]=(((31-i)*start.green)+(i*pt2.green))/31;
	cb[j]=(((31-i)*start.blue)+(i*pt2.blue))/31;
	j++;
    }
    for(i=0;i<32;i++)
    {
	cr[j]=(((31-i)*pt2.red)+(i*pt3.red))/31;
	cg[j]=(((31-i)*pt2.green)+(i*pt3.green))/31;
	cb[j]=(((31-i)*pt2.blue)+(i*pt3.blue))/31;
	j++;
    }
    for(i=0;i<32;i++)
    {
	cr[j]=(((31-i)*pt3.red)+(i*pt4.red))/31;
	cg[j]=(((31-i)*pt3.green)+(i*pt4.green))/31;
	cb[j]=(((31-i)*pt3.blue)+(i*pt4.blue))/31;
	j++;
    }
    for(i=0;i<32;i++)
    {
	cr[j]=(((31-i)*pt4.red)+(i*end.red))/31;
	cg[j]=(((31-i)*pt4.green)+(i*end.green))/31;
	cb[j]=(((31-i)*pt4.blue)+(i*end.blue))/31;
	j++;
    }
    for(i=0;i<bands;i++)
    {
	for(j=0;j<MAXBANDS;j++)
	{
	    r=cr[j]+((i-16)*2);
	    g=cg[j]+((i-16)*2);
	    b=cb[j]+((i-16)*2);
	    if (r<0) r=0;
	    else if (r>255) r=255;
	    if (g<0) g=0;
	    else if (g>255) g=255;
	    if (b<0) b=0;
	    else if (b>255) b=255;
	    colortab[i][j]=gdk_imlib_best_color_match(&r,&g,&b);
	}
    }
    data=malloc(MAXBANDS*3);
    for(i=0;i<MAXBANDS;i++)
    {
	data[(i*3)]=cr[(MAXBANDS-1)-i];
	data[(i*3)+1]=cg[(MAXBANDS-1)-i];
	data[(i*3)+2]=cb[(MAXBANDS-1)-i];
    }
    im=gdk_imlib_create_image_from_data(data,NULL,1,MAXBANDS);
    free(data);
    w=MAXBANDS;
    h=im->rgb_height;

    for(i=128;i<256;i++)
    {
	gdk_imlib_render(im,1,i-127);
	grad[i]=gdk_imlib_move_image(im);
    }
    gdk_imlib_flip_image_vertical(im);
    for(i=0;i<127;i++)
    {
	gdk_imlib_render(im,1,127-i);
	grad[i]=gdk_imlib_move_image(im);
    }
    if (ready)
	grad_win_create();
    else if ((!ready) && (grad_win_present)) /* from past run i.e. conf file */
	grad_win_create();	
    gdk_imlib_kill_image(im);
}

void grad_win_create()
{
    int h = MAXBANDS;
    int w = MAXBANDS*1.25;

    if(!grad_win)
    {
	grad_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	grad_win_ptr = grad_win;
	gtk_widget_set_uposition(grad_win,grad_x_origin,grad_y_origin);
	gtk_window_set_title(GTK_WINDOW(grad_win),"Color Picker");
	gtk_widget_set_usize(grad_win,w,h);
	gtk_window_set_policy(GTK_WINDOW(grad_win), FALSE,   // allow shrink
			      FALSE,         // allow grow
			      FALSE);       // auto shrink
	gtk_signal_connect(GTK_OBJECT(grad_win),"delete_event",
			   GTK_SIGNAL_FUNC(close_grad_win),NULL);
	gtk_widget_set_events (grad_win, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(grad_win), "button_press_event",
			   (GtkSignalFunc) color_event, NULL);
	gtk_signal_connect(GTK_OBJECT(grad_win), "focus_out_event",
			   (GtkSignalFunc) grad_win_save_state, NULL);
	gtk_widget_set_events (grad_win,GDK_BUTTON_PRESS_MASK
			       | GDK_EXPOSURE_MASK
			       | GDK_FOCUS_CHANGE_MASK);


	grad_disp = gtk_drawing_area_new();
	gtk_container_add(GTK_CONTAINER(grad_win), grad_disp);
	gtk_widget_show(grad_disp);
	gtk_widget_realize(grad_disp);

	gtk_widget_show_all(grad_win);
    }
    if (grad_pixmap)
	gdk_pixmap_unref(grad_pixmap);

    grad_pixmap = gdk_pixmap_new(grad_disp->window,width,height,
				 gtk_widget_get_visual(grad_disp)->depth);

    gdk_imlib_flip_image_vertical(im);
    gdk_imlib_render(im,w,h);
    grad_pixmap=gdk_imlib_move_image(im);

    gdk_window_set_back_pixmap(grad_disp->window,grad_pixmap,0);

    gdk_draw_pixmap(grad_disp->window,
		    grad_disp->style->fg_gc[GTK_WIDGET_STATE (grad_disp)],
		    grad_pixmap,
		    0,0,
		    0,0,
		    w,h);
    if (!grad_win_present)
    {
	gtk_widget_show(grad_win);
	gtk_widget_set_uposition(grad_win,grad_x_origin,grad_y_origin);
	grad_win_present = 1;
    }


}

gint grad_win_save_state(GtkWidget *widget, GdkEventFocus *event)
{
    int x,y;
    if(!grad_win_present)
	return TRUE;
    if (!event->in)
    {
	gdk_window_get_root_origin((gpointer) grad_win_ptr->window, &x, &y);
	grad_x_origin = x;
	grad_y_origin = y;
    }

    return FALSE;
}
