/*
 * BUTTONS.C extace source file
 * 
 /GDK/GNOME sound (esd) system output display program
 * 
 * Copyright (C) 1999 by Dave J. Andruczyk 
 * 
 * Based upon Code written by The Rasterman and DrMike from redhat.com
 * Re-hacked to look good by The Rasterman (Michael Fullbright)
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You use this program at your own risk.
 */

#include <config.h>
#include <globals.h>
#include <protos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>
#include "logo.xpm"


void leave(GtkWidget *widget, gpointer *data)
{
    int i;
    save_config();
    close(sound);
    
    // Free all malloc'd areas...
    g_free(audio_data);
    g_free(audio_left);
    g_free(audio_right);
    g_free(audio_last_l);
    g_free(audio_last_r);
    g_free(raw_fft_out);
    g_free(norm_fft);
    g_free(datawindow);
    g_free(pip_arr);
    g_free(disp_val);
    for (i=0;i<BUFS;i++)
    {
	g_free(incoming_buf[i]);
	g_free(mixdown_buf[i]);
    }

    gtk_main_quit();
}

gint button_options(GtkWidget *widget, gpointer *data)
{
    if (GTK_TOGGLE_BUTTON (widget)->active)
    {                                           // button's down
	gtk_widget_show(options);
    }
    else
    {
	gtk_widget_hide(options);
    }
    return 0;
}
gint close_dir_win(GtkWidget *widget, gpointer *data)
{
    if (dir_win_present)
    {
	gtk_widget_hide(dir_win);
	dir_win_present = 0;
    }
    return TRUE;
}

gint close_grad_win(GtkWidget *widget, gpointer *data)
{
    if (grad_win_present)
    {
	gtk_widget_hide(grad_win);
	grad_win_present = 0;
    }
    return TRUE;
}

gint close_options(GtkWidget *widget, gpointer *data)
{
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(optionsbut), FALSE);
    return TRUE;
}

gint slider_changed(GtkWidget *widget, gpointer *data)
{
    switch ((gint)data)
    {
	case BANDS:
	    bands = GTK_ADJUSTMENT(widget)->value;
	    scalefixed = 0;		// MUST recaluclate scalefactor
	    break;
	case SENSE:
	    sensitivity = GTK_ADJUSTMENT(widget)->value;
	    sensefixed = 0;		// redraw EQ window
	    break;
	case DECAY:
	    decay_val = GTK_ADJUSTMENT(widget)->value;
	    break;
	case LAG:
	    lag = GTK_ADJUSTMENT(widget)->value;
	    break;
	default:
	    break;
    }
    return 0;
}

gint button_handle(GtkWidget *widget, gpointer *data)
{
    if (GTK_TOGGLE_BUTTON(widget)->active) // its pressed
    {
	switch((gint)data)
	{
	    case SUPPRESS:

		gtk_label_set(GTK_LABEL(GTK_BIN (widget)->child),
			      "Show Leading Edge");
		show_leader = 0;
		break;
	    case DECAY:
		gtk_label_set(GTK_LABEL(GTK_BIN (widget)->child),
			      "Disable Decay");
		slide = 1;
		break;
	    default:
		break;
	}
    }
    else
    {
	switch((gint)data)
	{
	    case SUPPRESS:
		gtk_label_set(GTK_LABEL(GTK_BIN (widget)->child),
			      "Hide Leading Edge");
		show_leader = 1;
		break;
	    case DECAY:
		gtk_label_set(GTK_LABEL(GTK_BIN (widget)->child),
			      "Enable Decay");
		slide = 0;
		break;
	    default:
		break;
	}

    }
    return 0;
}
	

gint button_3d_fft(GtkWidget *widget, gpointer *data)

{
    if (mode == STARS)
	kt_stars_stop(disp);
    gdk_draw_rectangle( pixmap,
			disp->style->black_gc,
			TRUE, 0,0,
			width,height);
    gdk_window_clear(win);
    mode = LAND_3D;
    if (data == (gpointer)FILL_3D)
	sub_mode=(gint)data;
    if (data == (gpointer)WIRE_3D)
	sub_mode=(gint)data;

    if (!dir_win_present)
    {
	gtk_widget_show(dir_win);
	gtk_widget_set_uposition(dir_win,dir_x_origin,dir_y_origin);
	dir_win_present = 1;
    }
	dir_configure(dir_area, NULL);
	update_pointer();


    return 0;
}

gint button_2d_fft(GtkWidget *widget, gpointer *data)
{
    if (mode == STARS)
	kt_stars_stop(disp);
    gdk_draw_rectangle( pixmap,
			disp->style->black_gc,
			TRUE, 0,0,
			width,height);
    gdk_window_clear(win);
    mode = EQ_2D;
    if(dir_win_present)
    {
	gtk_widget_hide(dir_win);
	dir_win_present = 0;
    }

    return 0;
}

gint button_oscilloscope(GtkWidget *widget, gpointer *data)
{
    if (mode == STARS)
	kt_stars_stop(disp);
    gdk_draw_rectangle( pixmap,
			disp->style->black_gc,
			TRUE, 0,0,
			width,height);
    gdk_window_clear(win);
    mode = SCOPE;

    if(dir_win_present)
    {
	gtk_widget_hide(dir_win);
	dir_win_present = 0;
    }
    

    return 0;
}
gint scope_mode(GtkWidget *widget, gpointer *data)
{
    if (data == (gpointer)DOT_SCOPE)
	scope_sub_mode = (gint)data;
    if (data == (gpointer)LINE_SCOPE)
	scope_sub_mode = (gint)data;
    if (data == (gpointer)GRAD_SCOPE)
	scope_sub_mode = (gint)data;

    if (mode == SCOPE)
    {
	    gdk_draw_rectangle( pixmap,
				disp->style->black_gc,
				TRUE, 0,top,
				lo_width,bottom);
	gdk_window_clear_area(win,0,top,width,height);
    }
    return 0;
}

gint button_specgram(GtkWidget *widget, gpointer *data)
{
    if (mode == STARS)
	kt_stars_stop(disp);
    gdk_draw_rectangle( pixmap,
			disp->style->black_gc,
			TRUE, 0,0,
			width,height);
    gdk_window_clear(win);
    mode = SPECGRAM;
    if(dir_win_present)
    {
	gtk_widget_hide(dir_win);
	dir_win_present = 0;
    }
    display_markers = 1;
    
    return 0;
}

gint button_3d_detailed(GtkWidget *widget, gpointer *data)
{
    if (mode == STARS)
	kt_stars_stop(disp);
    gdk_draw_rectangle( pixmap,
			disp->style->black_gc,
			TRUE, 0,0,
			width,height);
    gdk_window_clear(win);
    mode = SPIKE_3D;
    if (!dir_win_present)
    {
	gtk_widget_show(dir_win);
	gtk_widget_set_uposition(dir_win,dir_x_origin,dir_y_origin);
	dir_win_present = 1;
    }
	dir_configure(dir_area, NULL);
	update_pointer();

    return 0;
}

gint button_about(GtkWidget *widget, gpointer *data)
{
    static GtkWidget *stars = NULL;

    if (mode == STARS)
    {
	gtk_object_set_data(GTK_OBJECT(disp), "reset", (gpointer)1);
	kt_stars_stop(disp);
    }
    gdk_draw_rectangle( pixmap,
			disp->style->black_gc,
			TRUE, 0,0,
			width,height);
    gdk_window_clear(win);
    if (!stars)
    {
	GdkPixmap *pm = NULL, *mk = NULL;

	stars = (GtkWidget *)kt_stars_new(disp, pixmap);
	pm = gdk_pixmap_create_from_xpm_d(stars->window, &mk, NULL, logo_xpm);
	kt_stars_set_logo_pixmp(stars, pm, mk);
    }
    mode=STARS;
    if(dir_win_present)
    {
	gtk_widget_hide(dir_win);
	dir_win_present = 0;
    }
    kt_stars_start(stars, stars->allocation.width, stars->allocation.height);
    return 0;
}

