/*
 * This is part of DCD, Dave's CD Player.
 * (C) 1998,1999 David E. Smith <dave@technopagan.org>
 * Released under GNU GPL v2. (See 'COPYING' for details.)
 *
 * Much of this code was shamelessly stolen from a sockets example
 * cooked up by LordVader. His code worked; if mine doesn't, it's MY
 * fault, not his. :-) Per his request, here's some more headers...
 */ 

/*
 * Webdump program by Jesse Estum, a.k.a LordVader on DALnet.  darkdarth@yahoo.com
 * Re-distributable under the terms of the GNU General Public Licence version of your choice.
 * This header MUST remain in re-distributed versions.
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <unistd.h>
#include <string.h>
#include <netdb.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "dcd.h"
#include "libcdplay.h"
#include "cdindex.h"

#define NAMESIZE 80
#define NO_TRACKNAME "Trackname unavailable"
#define REMOTE_SITE "www.cdindex.org."
#define REMOTE_PORT 80
#define NET_BUF_SZ 1024

static char trackname[100][NAMESIZE];
static int cdi_flag;
static int net_flag;
static int cdi_check_matches (FILE *fd);

int cdi_status (void) {
  return cdi_flag;
}

static char * fname (void) {
  char *home = getenv("HOME");
  char *ret = malloc(1024);
  memset (ret, '\0', sizeof(ret));
  snprintf (ret, 1024, "%s/%s/%s", home, CDINDEX_HOME, cd_discid());
  return ret;
}


#define QUIET_CDI
void cdi_noinit (void) {
  cdi_flag = CDI_NONE;
  #ifndef QUIET_CDI
    fprintf (stderr, "Unable to open CD Index file for this disc. Track names unavailable.\n");
  #endif
}

int cdi_init (int net_toggle) {
  int i, s, fflag = 0;
  int ft = cd_first_track();
  int lt = cd_last_track();
  char trknm[NAMESIZE]; /* XXX bounded, UNSAFE! */
  FILE *fd;
  char *tn;
  cdi_flag = CDI_NONE;

  #ifdef DEBUG
    fprintf (stderr, "Entering cdi_init()\n");
  #endif

  net_flag = net_toggle; /* wheee! */

  fd = fopen(fname(), "r");
  if (NULL == fd) {
    fflag = cdi_get_info_net();
    if (fflag == FALSE) {
      cdi_noinit();
      return -1;
    }
    fd = fopen (fname(), "r");
  }

  /* if we get here, we know we have a file there of some sort */

  clearerr (fd);
  i = cdi_check_matches (fd);
  if (i != 1) {
    #ifdef DEBUG
      fprintf (stderr, "cdi_check_matches returned %i\n", i);
    #endif
    cdi_noinit();
    return -1;
  }
  fclose(fd);
  fd = fopen (fname(), "r");
  clearerr (fd);

  for ( i=0; i<lt; i++) {
    tn = malloc(NAMESIZE);
    memset (tn, '\0', sizeof(tn));
    snprintf (tn, NAMESIZE, "%s\n", NO_TRACKNAME);
    strncpy (trackname[i], tn, NAMESIZE);
  }

  /* wheee. we've set up our backup. now let's have fun. */

  #ifdef DEBUG
    fprintf (stderr, "cdi_init: entering trackscan loop\n");
  #endif
  while ((!feof(fd)) && (!ferror(fd))) {
    i = 0;
    #ifdef DEBUG
      fprintf (stderr, "Scanning: ");
    #endif
    s = fscanf (fd, "Track%i: ", &i);
    if ((s > 0) && (i >= ft) && (i <= lt)) {
      fgets (trknm, NAMESIZE, fd);
      strncpy (trackname[i-1], trknm, NAMESIZE);
      #ifdef DEBUG
        fprintf (stderr, "%i (%s)\n", i, trknm);
      #endif
    if (feof(fd) || (EOF == s)) break; /* eeeeek! */
    } /* track-name matching loop */
    else {
      fgets(trknm, NAMESIZE, fd); /* clear to newline */
      #ifdef DEBUG
        fprintf (stderr, "failed\n");
      #endif
    }
  }
  #ifdef DEBUG
    fprintf (stderr, "cdi_init: leaving the loop\n");
  #endif 

  fclose (fd);
  cdi_flag = CDI_OK;
  #ifdef DEBUG
    fprintf (stderr, "Leaving cdi_init()\n");
  #endif
  return 0;
}

char* cdi_trackname (int trknum) {
  char *ret = malloc(NAMESIZE);
  #ifdef DEBUG
    fprintf (stderr, "Calling cdi_trackname(%i)\n", trknum);
  #endif
  memset (ret, '\n', sizeof(ret));
  snprintf (ret, NAMESIZE, "%s", trackname[trknum-1]);
  return ret;
}

int cdi_get_info_net (void) {
  int sockfd;
  struct sockaddr_in server_addr;
  struct hostent *h;
  char *l_msg, *l_buffer;
  FILE *outfile;

  #ifdef DEBUG
    fprintf (stderr, "Entering cdi_get_info_net()\n");
  #endif

  if (net_flag == FALSE) return FALSE;

  l_msg = (char *)malloc (128);
  l_buffer = (char *)malloc (NET_BUF_SZ);

  if ((l_msg == NULL) || (l_buffer == NULL)) {
    #ifdef DEBUG
      fprintf (stderr, "Unable to malloc, bailing\n");
    #endif
    return 1;
  }
  memset (l_buffer, '\0', NET_BUF_SZ);

  /* setup for net stuffz */

  #ifdef DEBUG
    fprintf (stderr, "Entering network setup phase.");
  #endif

  h = gethostbyname (REMOTE_SITE);

  #ifdef DEBUG
    fprintf (stderr, ".");
  #endif

  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(REMOTE_PORT);
  server_addr.sin_addr = *((struct in_addr *)h->h_addr);
  memset(server_addr.sin_zero, '\0', 8);

  #ifdef DEBUG
    fprintf (stderr, ". done.\n");
  #endif

  if (connect(sockfd, (struct sockaddr *)&server_addr,
      sizeof(struct sockaddr)) == -1)  return FALSE;
  
  sprintf (l_msg,
          "GET http://www.cdindex.org/cgi-bin/cdi/get.pl?id=%s HTTP/1.0\n\n",
          cd_discid() ); 

  #ifdef DEBUG
    fprintf (stderr, "Request formed:\n%s\n", l_msg);
  #endif

  outfile = fopen (fname(), "w");
  if (NULL == outfile) {
    #ifdef DEBUG
      fprintf (stderr, "Unable to open new file, bailing\n");
    #endif
    return 1;
  }

  send(sockfd, l_msg, strlen(l_msg), 0);
  while (recv(sockfd, l_buffer, NET_BUF_SZ, 0) == NET_BUF_SZ) {
    fputs(l_buffer, outfile);
    memset (l_buffer, '\0', NET_BUF_SZ);
  }
  fputs(l_buffer, outfile);
  
  /* cleanup */
  fclose(outfile);
  close (sockfd);
  free (l_buffer);
  free (l_msg);

  #ifdef DEBUG
    fprintf (stderr, "Successfully exiting net_get()\n");
  #endif

  return TRUE;
}

static int cdi_check_matches (FILE *fd) {
  int i; int s; char trknm[100];
  while ((!feof(fd)) && (!ferror(fd))) {
    s = fscanf (fd, "NumMatches: %i", &i);
    #ifdef DEBUG
      fprintf (stderr, "Scanning, found %i alleged matches\n", i);
    #endif
    if (s > 0) switch (i) { /* the latter is a sanity check */
      case 0: printf ("CD Index doesn't know about this CD. Track names unavailable.\n");
              printf ("If you want to avoid this error in the future, consider submitting\n");
              printf ("information about this CD to the CD Index by using this URL:\n");
              printf ("%s\n", cd_subid());
              unlink(fname()); /* don't care about errors */
              break;
      case 1: break; /* this is the "good" case */
      default: printf ("CD Index claims >1 match for this CD. This shouldn't be possible...\n");
               printf ("Please send email to dave@technopagan.org about this. In the meantime,\n");
               printf ("track names will be unavailable.\n");
               break;
    } /* switch */
    else fgets(trknm, NAMESIZE, fd); /* clear to newline */
  } /* while */    
  return i;
} /* func */
