## This is the plugin to handle appletalk laserwriters under
## tkchooser2. It has no access to global variables, only
## procedures and functions
##
## Ethan Gold <etgold@cs.vassar.edu> 2/24/98
##

## must provide a name, public name, and icon in addition to
## start and stop procedures

## these don't work as globals, only for
## non-procedural initialization

if {[debug]} { puts "loading lwplug..." }

## register the plugin with the main chooser
register_plugin appletalk lwplug LaserWriters

########## required functions #################

#### required procedures that simply return plugin information
proc lwplug.geticon {} { return "laserwriter.pnm" }
proc lwplug.getpubname {} { return "LaserWriters" }
proc lwplug.getprotocol {} { return "appletalk" }
## not required for API - using as a global variable
proc lwplug.afterdelay {} { return "120000" }

## start function - required
proc lwplug.start {} {
    global env
    if {[debug]} { puts "started LaserWriter Plugin" }

    set entlabel [plug_list_label]
    $entlabel configure -text "LaserWriters:"
    update
    ## make sure there aren't any undeleted widgets
    lwplug.widgets stop
    lwplug.widgets start
    lwplug.refresh
    if [file readable $env(HOME)/.paprc] {
	set fd [open $env(HOME)/.paprc r]
	gets $fd currprinter
	close $fd
	unset fd
	set_glob currprinter "[lindex [split $currprinter :] 0]@[lindex \
		[split $currprinter @] 1]"
    }
    [plug_frame].status configure -text "Printer: [get_glob currprinter]"
}

## stop funtion - required
proc lwplug.stop {} {
    if {[debug]} { puts "stopped LaserWriter Plugin" }
    lwplug.clearentities
    set ID [get_glob afterID]
    if {[string compare $ID ""] != 0 } {
	after cancel $ID
    }
    lwplug.widgets stop
}

## function to call when a listitem is double-clicked
proc lwplug.doubleclick {} {
    if {[debug]} { puts "lwplug: got double-click with [get_curr_item]" }
    ## create a window with papstatus information in it
    lwplug.showprinterstatus [get_curr_item] [appletalk.getcurrzone]
}

proc lwplug.newzone {} {
    set plugframe [plug_frame]
    $plugframe.status configure -text "scanning [appletalk.getcurrzone]..."
    update
    lwplug.clearentities
    lwplug.showentities [lwplug.getnames]
    $plugframe.status configure -text "Printer: [get_glob currprinter]"
}

############# End required functions ##################

## procedure to show the status of a printer
proc lwplug.showprinterstatus {printer zone} {

    ## make sure the name we use in the printer window path
    ## variable doesn't have any spaces.
    regsub -all " " $printer "" prnt

    set status "waiting for reply..."
    set w .lwplug_status_$prnt
    
    ## replace the current window for this printer
    ## if it exists
    destroy $w
    
    toplevel $w -class Dialog
    label $w.label -text "$printer@$zone" -relief groove
    message $w.mesg -width 300 -text $status
    button $w.close -text "Close" \
	    -command "destroy $w" -default active

    pack $w.label -side top -fill x
    pack $w.mesg -side top -fill x
    pack $w.close -side left -anchor s
    update

    bind $w <Return> "$w.close invoke"

    ## get the status
    set status [lwplug.getprinterstatus $printer $zone]
    $w.mesg configure -text $status
    focus $w
}

## function to get and return the status of a printer
proc lwplug.getprinterstatus {printer zone} {
    #global appletalkdir

    set plugframe [plug_frame]
    $plugframe.status configure -text "querying $printer..."
    update

    set statfd [open "|papstatus -p \"$printer@$zone\"" r]
    set status ""
    while {[gets $statfd line] != -1} {
	if {[string compare $status ""] == 0} {
	    set status $line
	} else {set status "$status\n$line"}
    }
    if {[string compare $status ""] == 0} {
	set status "no response."
    }
    $plugframe.status configure -text "Printer: [get_glob currprinter]"
    return $status
}

proc lwplug.refresh {} {
    lwplug.newzone
    set_glob afterID [ after [lwplug.afterdelay] {lwplug.refresh}]
}

## procedure to call appletalk print function
proc lwplug.printfile {filterflag} {
    set thefile [get_glob "file"]
    if {[string compare $thefile ""] == 0} {
	puts "lwplug: no file specified"
	return
    }
    set printer "[get_curr_item]\:LaserWriter\@[appletalk.getcurrzone]"
    set filename [tilde $thefile]
    puts "lwplug: trying to print $filename to $printer"
    set result [appletalk.print $printer $filename $filterflag]
    if {[debug]} { puts "lwplug: print result: $result" }
}

## procedure to preview a file to be printed
proc lwplug.previewfile {filterflag} {
    global printpreviewer printfilterfile
    if {[string compare $printpreviewer "" ] == 0 || !$filterflag} {
	set printpreviewer "xterm -e more"
    }
    set thefile [get_glob "file"]
    if {[string compare $thefile ""] == 0} {
	puts "lwplug: no file specified"
	return
    }
    set filename [lwplug.tilde $thefile]
    if {$filterflag} {
	if {[file readable $printfilterfile]} {
	    ## read in filter command
	    set filtfd [open "$printfilterfile" r]
	    gets $filtfd filtcmd
	    close $filtfd
	    if {[debug]} {
		puts "lwplug: opening |$filtcmd $filename | $printpreviewer"
	    }
	    set result ""
	    catch {eval exec $filtcmd $filename | $printpreviewer} result
	    if {[debug]} {puts "lwplug: $result"}
	} else {
	    error "LaserWriter" "Could not find the printfilter file \
		    $printfilterfile. Please uncheck the filter \
		    option and try again."
	    return
	}
    } else {
	catch {eval exec $printpreviewer $filename } result
    }
}

## procedure to set the selected printer in the filesystem
proc lwplug.selectprinter {newprinter} {
    global env
    set pfd [open $env(HOME)/.paprc w]
    puts $pfd "$newprinter:LaserWriter@[appletalk.getcurrzone]"
    close $pfd
    set_glob currprinter "$newprinter@[appletalk.getcurrzone]"
    [plug_frame].status configure -text "Printer: [get_glob currprinter]"
}

## procedure to build and destroy lwplug widgets
proc lwplug.widgets {command} {
    set plugframe [plug_frame]

    set filterflag 0
    set_glob file ""
    if {[string compare $command "start"] == 0} {
	frame $plugframe.fframe
	checkbutton $plugframe.filter -variable filterflag -text "use filter"
	label $plugframe.fframe.label -text "File:"
	message $plugframe.fframe.filename -width 160 -relief sunken -text ""
	#button $plugframe.preview -text "Preview File" -command "lwplug.previewfile \$filterflag"
	button $plugframe.print -text "Print File" \
		-command "lwplug.printfile \$filterflag"
	button $plugframe.select -text "Select" \
		-command "lwplug.selectprinter \[get_curr_item\]"

	#pack $plugframe.preview
	pack $plugframe.select -fill x -expand 1
	pack $plugframe.fframe.label -side left
	pack $plugframe.fframe.filename -side right -fill x -expand 1
	pack $plugframe.fframe -fill x
	pack $plugframe.filter -side left
	pack $plugframe.print -side right
	$plugframe.status configure -text "Printer: [get_glob currprinter]"

	bind $plugframe.fframe.filename <ButtonRelease> {
	    fileselect lwplug.getfilename
	}

    } else {
	destroy $plugframe.print
	#destroy $plugframe.preview
	destroy $plugframe.select
	destroy $plugframe.filter
	destroy $plugframe.fframe.filename
	destroy $plugframe.fframe.label
	destroy $plugframe.fframe
    }
    
}

## procedure to get a filename, set it globally, and list
## it in the filename widget
proc lwplug.getfilename {filename} {
    set plugframe [plug_frame]
    set_glob file "[pwd]/$filename"
    $plugframe.fframe.filename configure -text [get_glob "file"]
    if {[debug]} { puts "lwplug: file was [get_glob file]" }
}

## function to return the laserwriters in the current zone
proc lwplug.getnames {} {
    return [appletalk.namesfromlkup [lwplug.getentities]]
}

proc lwplug.getentities {} {
    set currzone [appletalk.getcurrzone]
    set entity "=:LaserWriter@$currzone"
    set results [appletalk.nbplkup $entity]
    set results [appletalk.namesfromlkup $results]
    return $results
}

## function to display passed in entities in
## the plugin's entity list frame
proc lwplug.showentities {entitylist} {
    set lbox [plug_list]
    foreach entity $entitylist {
	$lbox insert end $entity
    }
}

proc lwplug.clearentities {} {
    set lbox [plug_list]
    $lbox delete 0 end
}

if {[debug]} { puts "finished loading lwplug." }
