/* pilrctst.c:  Test program for PilRC
 *
 * Wes Cherry
 * wesc@ricochet.net
 */

#pragma pack(2)

#include "pilrctst.h"
#include "resource.h"	/* generated by pilrc */
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

int kidForm;

void CopyFontWidths(int ifnt);

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
	{
	short err;
	EventType e;
	FormType *pfrm;

	if (!cmd) 
		{
		FontPtr font128;
		long dwVer;
		int wPalmOSVerMajor;
		
		kidForm = kidForm1;
		
		FtrGet(sysFtrCreator, sysFtrNumROMVersion, &dwVer);
		wPalmOSVerMajor = sysGetROMVerMajor(dwVer);
		if (wPalmOSVerMajor >= 3)
			{
			font128=MemHandleLock(DmGetResource('NFNT', 1000));
			FntDefineFont(128, font128);
			}
		
		FrmGotoForm(kidForm);

	    while(1) 
			{
			EvtGetEvent(&e, 100);
			if (SysHandleEvent(&e)) 
				continue;
			if (MenuHandleEvent((void *)0, &e, &err)) 
				continue;
	
			switch (e.eType) 
				{
			case ctlSelectEvent:
				if (e.data.ctlSelect.controlID == kidOk)
					{
					kidForm++;
					if (kidForm > kidFormLast)
						kidForm = kidForm1;
					FrmGotoForm(kidForm); 
					break;
					}
				goto Dft;
				break;
		
			case frmLoadEvent:	
				FrmSetActiveForm(FrmInitForm(e.data.frmLoad.formID));
				break;
	
			case frmOpenEvent:
				pfrm = FrmGetActiveForm();
				FrmDrawForm(pfrm);
				
				/* Hack to copy font widths */
				CopyFontWidths(e.data.frmLoad.formID - kidForm1);

				if (e.data.frmLoad.formID == kidForm12)
					{
					TableType *ptbl;
	
					ptbl = FrmGetObjectPtr(pfrm, FrmGetObjectIndex(pfrm, kidTable));
	
					TblSetColumnUsable(ptbl, 0, true);
					TblSetColumnUsable(ptbl, 1, true);
					TblSetColumnUsable(ptbl, 2, true);
					TblSetColumnUsable(ptbl, 3, true);
					TblSetColumnUsable(ptbl, 4, true);
					TblSetRowUsable(ptbl, 0, true);
					TblSetRowUsable(ptbl, 1, true);
	
					TblSetItemStyle(ptbl, 0, 0, textTableItem);
					TblSetItemStyle(ptbl, 1, 0, textTableItem);
					TblSetItemStyle(ptbl, 2, 0, textTableItem);
					TblDrawTable(ptbl);
					}
							
				break;

			case menuEvent:
				FrmAlert(kidAlert1);
				break;

			case appStopEvent:
				return 0;

			default:
Dft:
				pfrm = FrmGetActiveForm();
				if (pfrm != NULL)
					FrmHandleEvent(pfrm, &e);
				}
			}
		}
	return 0;
	}

void CopyFontWidths(int i)
	{
	int ch;
	char *pch;
	char *rgb;
	
	
	if (i > largeBoldFont)
		return;
	FntSetFont(i);
	rgb = MemPtrNew(3*256+1+128);
	if (rgb == NULL)
		return;
	pch = rgb;
	for (ch = 0; ch < 256; ch++)
		{
		SWord dx;
		
		dx = FntCharWidth(ch);
		StrIToA(pch, dx);
		pch += StrLen(pch);
		*pch++ = ',';
		if ((ch+1)%8 == 0)
			*pch++ = '\n';
		}
	*pch = 0;
	ClipboardAddItem(clipboardText, rgb, pch-rgb);
	MemPtrFree(rgb);
	}
