/* NNTP part of spoolnews; uses tcp.c to connect to the nntpserver */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>

#include "nntp.h"
#include "tcp.h"
#include "postit.h"

#define TIMEOUT 60
#define MAX_BLOCK_SIZE 2048

void message(char *text)
{
  printf("%s\n",text);
}

void error(char *text)
{
  printf("%s\n",text);
}


void output(char *prefix, char *what)
{
  if (verbosity>=2) printf("%s%s",prefix,what);
}


int nntp_open_connection(char *servername, int port)
{
  char line[LONGSTRING];
  int x;
  int socket;

  socket=tcp_open_connection(servername,port);
  if (socket<0) printf("%d\n",socket);
  if (socket==-6) {
    return -1;
  }
  if (socket<0) {
    error("network failure");
    return -1;
  }
  x=tcp_receive_line_to(socket,line,LONGSTRING,TIMEOUT);
  if (x) {
    sscanf(line,"%d",&x);
    output("<",line);
  }
  if (!x||(x!=200&&x!=201)) {
    tcp_close_connection(socket);
    if (x) error("NNTPserver does not welcome us");
    else error("NNTPserver closed connection");
    return -1;
  }
  return socket;
}

/* Send an NNTP command (must be \0 terminated), wait for response,
   suppressing multi-line responses on-the-fly, returning server reply */
int nntp_send_command(int socknr, char *command)
{
  char reply[512];

  nntp_send_line(socknr,command);
  while (1) {
    if (tcp_receive_line_to(socknr,reply,512,TIMEOUT)<=0) return -1;
    output("<",reply);
    if (!(isdigit(reply[0])&&isdigit(reply[1])&&isdigit(reply[2]))) continue;
    if (reply[3]!='-') break; /* multi-line response */
  }
  return atoi(reply);
}

int nntp_close_connection(int socket)
{
  int x;
	
  x=nntp_send_command(socket,"quit");
  if (x!=205) {
    printf("server does not understand QUIT??? oh well...");
  }
  tcp_close_connection(socket);
  return 0;
}

void nntp_send_line(int socket,char *line)
{
  char buf[VERYLONGSTRING];
  char *s,*t;

  s=line; t=buf;
  while (*s&&*s!='\r'&&*s!='\n') *t++=*s++;
  *t++='\r';
  *t++='\n';
  *t++='\0';
  output(">",buf);
  tcp_send_line(socket,buf);
}

int nntp_end_of_article(int socket)
{
  return nntp_send_command(socket,".");
}

/* this sends a null-terminated block of characters, could be an article
   for example :-)  */
int nntp_send_block(int socknr, char *block)
{
  int l,l2;
  int errcount=0;
  char *s;
  char buf[80];

#ifdef DEBUG
  printf("*** enter nntp_send_block\n");
  fflush(stdout);
#endif
  while (*block) {
    for (s=block; *s&&s-block<MAX_BLOCK_SIZE; s++);
    l=s-block;
    l2=write(socknr,block,l);
    if (l<0) {
      printf(buf,"tcp error: couldn't write %d chars, errno=%d",l,errno);
      if (++errcount>20) return -1;
      sleep(1);
    }
    else if (!l) sleep(1);
    else block+=l;
  }
#ifdef DEBUG
  printf("*** leave nntp_send_block\n");
  fflush(stdout);
#endif
  return 0;
}


/* This sends an article from a stream */
int nntp_send_stream(int socknr, FILE *f)
{
  int l;
  char buf[MAX_BLOCK_SIZE+1];

#ifdef DEBUG
  printf("*** enter nntp_send_stream\n");
  fflush(stdout);
#endif
  while (1) {
    l=fread(buf,1,MAX_BLOCK_SIZE,f);
    if (!l) break;
    buf[l]=0;
    nntp_send_block(socknr,buf);
    if (l<MAX_BLOCK_SIZE) break;
  }
#ifdef DEBUG
  printf("*** leave nntp_send_stream\n");
  fflush(stdout);
#endif
  return 0;
}


