#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include "npnews.h"

int NP_News::rewrite_newsrc( int last )
{
   char old_path[ 1024 ], new_path[ 1024 ];
   NP_File old_newsrc, new_newsrc;

   snprintf( old_path, sizeof old_path, "%s/.peruser4-newsrc", home );
   if ( old_newsrc.openr( old_path ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "rewrite_newsrc(): %s", old_newsrc.get_error());
      return 1;
   }

   snprintf( new_path, sizeof new_path, "%s:temp", old_path );
   if ( new_newsrc.openw( new_path ))
   {
      snprintf( error_message, sizeof error_message, "NP_Transder: "
                "rewrite_newsrc(): %s", new_newsrc.get_error());
      return 1;
   }

   char *line;
   while(( line = old_newsrc.get_string()) != NULL )
   {
      if ( !isspace( *line ))
      {
         if ( new_newsrc.put_string( line ))
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "rewrite_newsrc(): %s", new_newsrc.get_error());
            return 1;
         }

         continue;
      }

      char buffer[ 1024 ];
      strcpy( buffer, line + strspn( line, " \t" ));
      strtok( buffer, ":" );

      if ( !strcmp( buffer, group ))
      {
         snprintf( buffer, sizeof buffer, "\t%s: %d\n", group, last );
         if ( new_newsrc.put_string( buffer ))
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      " rewrite_newsrc(): %s", new_newsrc.get_error());
            return 1;
         }

         while(( line = old_newsrc.get_string()) != NULL )
            if ( new_newsrc.put_string( line ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "rewrite_newsrc(): %s", new_newsrc.get_error());
               return 1;
            }

         break;
      }

      if ( new_newsrc.put_string( line ))
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "rewrite_newsrc(): %s", new_newsrc.get_error());
         return 1;
      }
   }

   new_newsrc.close();
   old_newsrc.close();

   remove( old_path );
   rename( new_path, old_path );

   return 0;
}
