#include <unistd.h>

#include "nptext.h"

void input_callback( gpointer data, gint fd, GdkInputCondition condition )
{
   NP_Text *text = ( NP_Text *)data;

   if ( text->input == NULL )
   {
      text->input = fdopen( STDIN_FILENO, "r" );
      if ( text->input == NULL )
      {
         perror( "fdopen" );
         exit( 1 );
      }

      text->input_id =
         gdk_input_add( STDIN_FILENO, GDK_INPUT_READ, input_callback, text );
   }
   
   if ( text->update() )
   {
      fclose( text->input );
      text->input = NULL;
      gdk_input_remove( text->input_id );
      text->input_id = -1;
   }
   
   return;
}
