#include <stdlib.h>
#include <stdio.h>
#include <regex.h>
#include <getopt.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>

#include "npfile.h"
#include "npstringarray.h"
#include "nppex.h"
#include "npsearch.h"
#include "npsepax.h"

int main( int argc, char **argv )
{
   NP_Sepax sepax;
   
   struct option long_options[] =
   {
         { "search", 1, NULL, 's' },
         { "pack", 0, NULL, 'p' },
         { "expire", 0, NULL, 'e' },
         { 0, 0, NULL, 0 }
   };

   int c = getopt_long( argc, argv, "s:pe", long_options, NULL );
   if ( c < 0 || c == '?' )
   {
      fprintf( stderr, "usage: npsepax (((-s|--search) REGEXP)|(-p|--pack)"
               "|(-e|--expire))\n" );
      return 1;
   }

   if ( c == 's' && sepax.compile( optarg ))
   {
      sepax.print_error();
      return 1;
   }

   int requests = 0;
   
   for( ; ; )
   {
      char buffer[ 1024 ];

      if ( fgets( buffer, sizeof buffer, stdin ) == NULL )
         break;
      
      char *server = strtok( buffer, ":" );
      char *group = strtok( NULL, "\n" );

      if ( c != 's' )
      {
         if ( !strcasecmp( server, "Folders" ) ||
              !strcasecmp( group, "FOLLOW-UPS" ) ||
              !strcasecmp( group, "POSTED" ) ||
              !strcasecmp( group, "OUTBOX" ) ||
              !strcasecmp( group, "SENT-MAIL" ))
            continue;
      }

      switch( c )
      {
      case 's':

         if ( sepax.search( server, group, requests ))
            sepax.print_error();
         break;

      case 'p':

         if ( sepax.pack( server, group ))
            sepax.print_error();
         break;

      case 'e':
         if ( sepax.expire( server, group ))
            sepax.print_error();
         break;

      case '?':
         return 1;
         break;
      }

      ++requests;

      fflush( stderr );
      fflush( stdout );
   }
   
   return 0;
}
