#include "npconfig.h"

void remove_folder_callback( GtkWidget *widget, gpointer data )
{
   NP_Config *config = ( NP_Config *)data;

   if ( config->folder_clist_line < 0 )
   {
      config->show_message(
         "Select a folder entry in the list to remove, first.", 0 );
      return;
   }

   NP_Folders *folders = &config->folders_f;

   GtkWidget *entry =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ), 
                                         "name_entry" );

   char *old = gtk_entry_get_text( GTK_ENTRY( entry ));

   if ( folders->remove( old ))
   {
      folders->print_error();
      return;
   }

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "Folders-%s", old );
   if ( config->deleted.add_item( buffer ))
      config->deleted.print_error();

   GtkWidget *clist =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                         "clist" );
   
   gtk_clist_remove( GTK_CLIST( clist ), config->folder_clist_line );
   
   config->dirty = 1;

   return;
}
