/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#if defined HP_UX || defined OSF1 || defined SunOS_SOLARIS
#include <sys/termio.h>
#endif
#if defined unicos
#include <sys/termios.h>
#endif
#if defined FreeBSD || defined OpenBSD
#include <sys/errno.h>
#include <sys/ioctl_compat.h>
#endif
#include <sys/errno.h>
#include <sys/ioctl.h>
#ifdef SunOS_SOLARIS
#include <fcntl.h>
#endif
#include "main.h"

#ifndef TCGETA
#define TCGETA TIOCGETP
#define TCSETA TIOCSETP
#else
#define SYSV
#endif

#ifdef SYSV
#include <termios.h>
#endif

#define DEFAULTROWS 24 /* defaul number of rows, if window size is unknown */
#define DEFAULTCOLS 80 /* defaul number of columns, if window size is unknown */

void set_tty(int i)
{
#if !defined SYSV
   static struct sgttyb tori;
   struct sgttyb tnew;
#else
   static struct termio tori;
   struct termio tnew;
#endif
   volatile struct winsize ws;

   if (isatty(0)) {
      if (i==3) {
         /*
          * Get window size.
          */
         ioctl(0, TIOCGWINSZ, &ws);
         _WINROWS_= ws.ws_row ? ws.ws_row : DEFAULTROWS;
         _WINCOLS_= ws.ws_col ? ws.ws_col : DEFAULTCOLS;

         /*
          * Get current tty settings.
          */
         if (ioctl(0, TCGETA, &tori) < 0) {
            fprintf(stderr, "** ioctl: %s\n", _PFTP_ERROR_ARRAY_);
            exit(PFTP_IOCTL_TTY_ERR);
         }
      }
      else if (i) {
         /*
          * Change terminal modes.
          */
         tnew = tori;
#ifndef SYSV
         tnew.sg_flags |= CBREAK;
         if (i==2) tnew.sg_flags &= ~ECHO;
#else
         if (i==2) tnew.c_lflag &= ~ECHO;
         tnew.c_lflag &= ~ICANON;
         tnew.c_lflag &= ~ISIG;
         tnew.c_cc[VMIN] = 1;
         tnew.c_cc[VTIME] = 0;
#endif

         /*
          * Set new tty modes.
          */
         if (ioctl(0, TCSETA, &tnew) < 0) {
            fprintf(stderr, "** ioctl: %s\n", _PFTP_ERROR_ARRAY_);
            exit(PFTP_IOCTL_TTY_ERR);
         }
      }
      else {
         /*
          * Reset old tty modes.
          */
         if (ioctl(0, TCSETA, &tori) < 0) {
            fprintf(stderr, "** ioctl: %s\n", _PFTP_ERROR_ARRAY_);
            exit(PFTP_IOCTL_TTY_ERR);
         }
      }
   }
}
