/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#if defined unicos || defined SunOS
#include <fcntl.h>
#endif
#if defined HAVE_LIBCRYPT && !defined HP_UX && !defined FreeBSD && !defined OpenBSD && !defined unicos
#include <crypt.h>
#endif
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "main.h"

extern short get_var_from_pftprc(FILE *, const char *, char *, int);
extern char *time_string(void);
extern long dir_size(char **);
extern int wait_for_data(int, int);
extern int printlist(char **, char *, short);
extern int check_accepted_hosts(char **, int);
extern void free_vec(char **);
void send_oob_error(int, char *);


short check_pass(int strnum)
{
   int goon=0;
   int check=0;
   time_t curtime;
   char str[LONAME], tmpstr[LONAME], ch[1];
   char stmp[SONAME];
   char *tmp=NULL;
   char *sargv[PFTP_MAX_PFM_ENTRY];
   char *accepted_hosts[SONAME];
   char *salt;
   int h=0;

   /*
    * Reading and checking PFTPDCLIENT from user's resource file.
    */
   if (get_var_from_pftprc((FILE *)NULL, "PFTPDCLIENT", stmp, strnum)) {
      if ((check = printlist(accepted_hosts, stmp, strnum))) {
         check = check_accepted_hosts(accepted_hosts, strnum);
      }
      if (!check) {
         send((*(statstr+strnum))->ws, PFTP_DATA_DENIED, PFTP_DATA_DENIED_LEN, MSG_OOB);
         if (slfp) {
            fprintf(slfp, "%s %s accepts no data from %s@%s\n", \
            time_string(), (*(statstr+strnum))->pw_name, (*(statstr+strnum))->from, \
            (*(statstr+strnum))->REMOTEHOSTNAME);
         }
         free_vec(accepted_hosts);
         return 0;
      }
      free_vec(accepted_hosts);
   }

   if (*((*(statstr+strnum))->from)) {
      /*
       * Set the destination directory.  If PFTPRECEIVE
       * is not set the connection is closed.
       */
      if (get_var_from_pftprc((FILE *)NULL, "PFTPRECEIVE", str, strnum) && *str == '/') {
         char timestr[SONAME];
         struct stat buf;
         for (tmp=str; *tmp; tmp++);
         if (*--tmp == '/') *tmp = '\0';
         strcpy((*(statstr+strnum))->uploaddir, str);
         sprintf((*(statstr+strnum))->uploaddir_lock, "%s/ilock", str);

         /*
          * Get maximum upload limit.
          */
         if (get_var_from_pftprc((FILE *)NULL, "PFTPUPLIMIT", timestr, strnum)) {
            (*(statstr+strnum))->mul = (double)atol(timestr) * 1024.0F;
         }
         else {
            (*(statstr+strnum))->mul = (double)MAXIMUM_UPLOAD_LIMIT * 1024.0F;
         }

         /*
          * Skip calculation of upload limit if PFTPUPLIMIT
          * is set to zero.
          */
         if ((*(statstr+strnum))->mul) {
            *sargv = str;
            *(sargv+1) = NULL;
            (*(statstr+strnum))->last_dir_size = (double)dir_size(sargv);
            if (((*(statstr+strnum))->mul <= (*(statstr+strnum))->last_dir_size)) {
               send((*(statstr+strnum))->ws, PFTP_NOSPACELEFT, PFTP_NOSPACELEFT_LEN, MSG_OOB);
               if (slfp) {
                  fprintf(slfp, "%s %s No space left\n", \
                  time_string(), (*(statstr+strnum))->pw_name);
               }
               return 0;
            }
         }

         /*
          * Check if directory exists.  If not create it.
          */
         if (stat(str, &buf)) {
            if (mkdir(str, 0755) < 0) {
               send_oob_error(strnum, str);
               return 0;
            }
         }

         /*
          * Change to the `from@host' directory.
          */
         sprintf(tmpstr, "%s/%s@%s", str, \
         (*(statstr+strnum))->from, (*(statstr+strnum))->REMOTEHOSTNAME);
         if (stat(tmpstr, &buf)) {
            if (mkdir(tmpstr, (mode_t)0700)) {
               send_oob_error(strnum, tmpstr);
               return 0;
            }
         }

         /*
          * Create time directory.
          */
         time(&curtime);
         sprintf(timestr, "%010ld", (long)curtime);
         sprintf((*(statstr+strnum))->incoming_lock, "%s/incoming:%s", tmpstr, timestr);
         sprintf(str, "%s/%s", tmpstr, timestr);
         if (mkdir(str, (mode_t)0700)) {
            send_oob_error(strnum, str);
            return 0;
         }
         strcpy((*(statstr+strnum))->cwd, str);
         (*(statstr+strnum))->cwd_last_ch = \
         (*(statstr+strnum))->cwd + strlen((*(statstr+strnum))->cwd);
         *((*(statstr+strnum))->cwd_last_ch) = '/';
         (*(statstr+strnum))->cwd_last_ch++;

         /*
          * Create incoming link to let the pfm
          * get informed of just incoming data.
          * No check if mul is zero due to possible
          * host specific variables.
          */
         if (symlink(timestr, (*(statstr+strnum))->incoming_lock) < 0) {
            send_oob_error(strnum, (*(statstr+strnum))->incoming_lock);
            *((*(statstr+strnum))->incoming_lock) = 0;
            return 0;
         }

         /*
          * Set ilock for possible recalculation calculation
          * of the upload limit.
          */
         if ((h = open((*(statstr+strnum))->uploaddir_lock, O_CREAT, 0600)) < 0) {
            send_oob_error(strnum, (*(statstr+strnum))->uploaddir_lock);
            return 0;
         }
         close(h);
         sprintf((*(statstr+strnum))->uplimit_lock, "%s/%s", str, PFTP_LOCK_FILE);
         if (link((*(statstr+strnum))->uploaddir_lock, (*(statstr+strnum))->uplimit_lock)) {
            *(*(statstr+strnum))->uplimit_lock = 0;
            send_oob_error(strnum, (*(statstr+strnum))->uplimit_lock);
            return 0;
         }
         buf.st_mode = 0;
         if (stat((*(statstr+strnum))->uploaddir_lock, &buf)) {
            send_oob_error(strnum, (*(statstr+strnum))->uploaddir_lock);
            return 0;
         }
         if (buf.st_nlink != 2) (*(statstr+strnum))->calc_dir = BIT_ONE;
      }
      else {
         send((*(statstr+strnum))->ws, PFTP_DATA_DENIED, PFTP_DATA_DENIED_LEN, MSG_OOB);
         if (slfp) {
            fprintf(slfp, "%s %s accepts no data from %s@%s\n", \
            time_string(), (*(statstr+strnum))->pw_name, (*(statstr+strnum))->from, \
            (*(statstr+strnum))->REMOTEHOSTNAME);
         }
         return 0;
      }

      /*
       * Come on client send the stuff.
       */
      if (write((*(statstr+strnum))->ws, "COME ON", 7) < 0) return 0;
   }
   else {
      /*
       * If present take password from pftp resource file
       * instread of the one from the password entry.
       */
      if (get_var_from_pftprc((FILE *)NULL, "PFTPPASS", str, strnum)) {
         strcpy((*(statstr+strnum))->pw_passwd, str);
      }

      /*
       * Get salt from passwd entry.
       */
      salt = (*(statstr+strnum))->pw_passwd;
      for (tmp=salt; *tmp && *tmp != ' ' && *tmp != '\t'; tmp++);
      *tmp = '\0';

      /*
       * Check if user allows login.
       */
      if (*salt == '*' && !*(salt+1)) {
         send((*(statstr+strnum))->ws, PFTP_USER_DENIED, PFTP_USER_DENIED_LEN, MSG_OOB);
         if (slfp) {
            fprintf(slfp, "%s %s accepts no data from %s\n", \
            time_string(), (*(statstr+strnum))->pw_name, (*(statstr+strnum))->REMOTEHOSTNAME);
         }
         return 0;
      }

      /*
       * Come on client send the stuff.
       */
      if (write((*(statstr+strnum))->ws, "COME ON", 7) < 0) return 0;

      /*
       * Wait for data or time out.
       */
      if (!wait_for_data((*(statstr+strnum))->ns, strnum)) {
         send((*(statstr+strnum))->ws, PFTP_LOGIN_ERR, PFTP_LOGIN_ERR_LEN, MSG_OOB);
         return 0;
      }

      /*
       * Read destination directory and password.
       */
      do {
         memset(str, 0, LONAME);
         for (h=0, tmp=str; h < LONAME && read((*(statstr+strnum))->fd, ch, sizeof(ch)); h++, tmp++) {
            *tmp = *ch;
            if (*tmp == '\n') break;
         }
         if (*tmp != '\n') {
            check = 0;
            break;
         }
         *tmp = '\0';
#ifdef _PFTP_DEBUG_
         /*
          * Just for debugging
          */
         if (slfp) {
            fprintf(slfp, "%s\n", str);
            fflush(slfp);
         }
#endif
         if (strlen(str) < 6 || *(str+4) != ' ') {
            check = 0;
            break;
         }
         /*
          * Setting prot.
          */
         *(str+4) = '\0';
         if (!strcmp(str, "DDIR")) {
            /*
             * Set the appropriate directory.
             */
            *tmpstr = '\0';
            if (*(str+5) == '~' && !*(str+6)) {
               strcpy(tmpstr, (*(statstr+strnum))->pw_dir);
            }
            else if (*(str+5) == '/') strcpy(tmpstr, (str+5));
            else if (*(str+5) == '~' && *(str+6) == '/') {
               sprintf(tmpstr, "%s%s", (*(statstr+strnum))->pw_dir, (str+6));
            }
            else sprintf(tmpstr, "%s/%s", (*(statstr+strnum))->pw_dir, (str+5));

            if (access(tmpstr, X_OK)) {
               send_oob_error(strnum, tmpstr);
               memset(str, 0, SONAME);
               memset((*(statstr+strnum))->pw_passwd, 0, SONAME);
               memset((*(statstr+strnum))->pw_dir, 0, LONAME);
               return 0;
            }
            else {
               strcpy((*(statstr+strnum))->cwd, tmpstr);
               (*(statstr+strnum))->cwd_last_ch = \
               (*(statstr+strnum))->cwd + strlen((*(statstr+strnum))->cwd);
               if (*((*(statstr+strnum))->cwd_last_ch - 1) != '/') {
                  *((*(statstr+strnum))->cwd_last_ch) = '/';
                  (*(statstr+strnum))->cwd_last_ch++;
               }
               check |= BIT_TWO;
            }
         }
         else if (!strcmp(str, "PASS")) {
            char *rp_ptr=NULL;
            char *lp_ptr=NULL;
            int l=0;
            rp_ptr = (char *)crypt((str+5), salt);
            lp_ptr = (*(statstr+strnum))->pw_passwd;
            /*
             * Checking password.
             */
            for (l=0; *rp_ptr && *lp_ptr && *rp_ptr == *lp_ptr; rp_ptr++, lp_ptr++, l++);
            if (!(*rp_ptr) && !(*lp_ptr) && l >= 13) check |= BIT_ONE;
            else {
               check= 0;
               break;
            }
         }
         else if (!strcmp(str, "GOON")) goon=1;
      } while (!goon);
      memset(str, 0, SONAME);
      memset((*(statstr+strnum))->pw_passwd, 0, SONAME);
      memset((*(statstr+strnum))->pw_dir, 0, LONAME);
      if (check != (BIT_ONE | BIT_TWO)) {
         send((*(statstr+strnum))->ws, PFTP_LOGIN_ERR, PFTP_LOGIN_ERR_LEN, MSG_OOB);
         if (slfp) {
            fprintf(slfp, "%s Wrong password from %s\n", time_string(), \
            (*(statstr+strnum))->REMOTEHOSTNAME);
         }
         return 0;
      }
   }
   return 1;
}

void send_oob_error(int strnum, char *str)
{
   char error_str[LONAME];
   sprintf(error_str, "ERRO ** %s: %s\n", str, _PFTP_ERROR_ARRAY_);
   send((*(statstr+strnum))->ws, error_str, strlen(error_str), MSG_OOB);
   if (slfp) {
      if ((*statstr)->_PFTP_DAEMON_) fprintf(slfp, "%s %s%s", \
         time_string(), (*(statstr+strnum))->rlogin, error_str+7);
      else {
         *(error_str+4) = '\n';
         fputs(error_str+4, slfp);
      }
   }
}
