/*
  $Id: mp.h,v 1.7 1996/10/22 00:49:57 luik Exp $

  mp.h - input/output multiplexing definitions for omirrd.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef MP_H_INCLUDED
#define MP_H_INCLUDED

#include <signal.h>
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#endif /* HAVE_SYS_TIME_H */
#include <sys/types.h>

#ifndef NSIG
#ifdef _NSIG
#define NSIG _NSIG
#else /* !defined(_NSIG) */
#define NSIG 32
#endif /* !defined(_NSIG) */
#endif /* !defined(NSIG) */

#ifdef	__cplusplus
extern "C" {
#endif

#define MP_SIG_DFL (MpSignalCallbackFunc) SIG_DFL
#define MP_SIG_IGN (MpSignalCallbackFunc) SIG_IGN

typedef int (*MpCallbackFunc)(int fd, void *data);
typedef RETSIGTYPE (*MpSignalCallbackFunc)(int sig, void *data);

typedef struct MpCallback_ {
    MpCallbackFunc callback;
    void *data;
} *MpCallback, MpCallbackRec;

typedef struct MpSignalCallback_ {
    MpSignalCallbackFunc callback;
    void *data;
    sig_atomic_t flag;
} *MpSignalCallback, MpSignalCallbackRec;

typedef struct MpContext_ *MpContext;

typedef struct MpContext_ {
    int nfds;
    fd_set readfds;
    fd_set writefds;
    fd_set exceptfds;
    MpCallbackRec readcbs[FD_SETSIZE];
    MpCallbackRec writecbs[FD_SETSIZE];
    MpCallbackRec exceptcbs[FD_SETSIZE];
    MpCallbackRec errorcbs[FD_SETSIZE];
    MpSignalCallbackRec signalcbs[NSIG];
    MpContext next;
} MpContextRec;

/* mp.c */
extern MpContext mpAlloc(void);
extern void mpFree(MpContext context);
extern MpContext mpAddReadCallback(MpContext context, int fd, MpCallbackFunc callback, void *data);
extern MpContext mpAddWriteCallback(MpContext context, int fd, MpCallbackFunc callback, void *data);
extern MpContext mpAddExceptCallback(MpContext context, int fd, MpCallbackFunc callback, void *data);
extern MpContext mpAddErrorCallback(MpContext context, int fd, MpCallbackFunc callback, void *data);
extern MpContext mpSetSignalCallback(MpContext context, int sig, MpSignalCallbackFunc callback, MpSignalCallbackFunc *ocallback, void *data);
extern MpContext mpRemoveReadCallback(MpContext context, int fd);
extern MpContext mpRemoveWriteCallback(MpContext context, int fd);
extern MpContext mpRemoveExceptCallback(MpContext context, int fd);
extern MpContext mpRemoveErrorCallback(MpContext context, int fd);
extern MpContext mpFlush(MpContext context, int fd);
extern int mpMainLoop(MpContext context);

#ifdef	__cplusplus
}
#endif

#endif /* defined(MP_H_INCLUDED) */
