dnl Additional autoconf macros for omirrd online mirror daemon.
dnl Copyright (C) 1996, Andreas Luik <luik@pharao.s.bawue.de>.
dnl
dnl This file is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl This file is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this file; if not, write to the Free Software
dnl Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl

dnl OM_PATH_GFIND - determine full pathname of GNU find and set GFIND.
AC_DEFUN(OM_PATH_GFIND,
[AC_MSG_CHECKING(for GNU find)
AC_CACHE_VAL(om_cv_path_gfind,
[for om_prog in gfind find ; do
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:"
  for om_dir in $PATH; do
    test -z "$om_dir" && om_dir=.
    if test -f $om_dir/$om_prog; then
      if $om_dir/$om_prog . -print0 1>/dev/null 2>&AC_FD_CC; then
        om_cv_path_gfind="$om_dir/$om_prog"
        break
      fi
    fi
  done
  IFS="$ac_save_ifs"
done
])dnl
if test -n "$om_cv_path_gfind"; then
  GFIND="$om_cv_path_gfind"
  AC_MSG_RESULT($GFIND)
else
  AC_MSG_RESULT(no)
  AC_MSG_WARN(Essential program GNU find not found. Please install it, then)
  AC_MSG_WARN(re-run configure before continuing with installation.)
  GFIND="gfind"
fi
AC_SUBST(GFIND)dnl
])

dnl OM_MNT_TYPE - determine operating system mount table format and define
dnl GETMOUNT_TYPE accordingly.
AC_DEFUN(OM_MNT_TYPE,
[AC_MSG_CHECKING(for mount table format)
AC_CACHE_VAL(om_cv_mnt_type,
[om_cv_mnt_type=no
# The order of these tests is important.
if test $om_cv_mnt_type = no; then
AC_TRY_CPP([#include <sys/mnttab.h>], om_cv_mnt_type=SYSV)
fi
if test $om_cv_mnt_type = no; then
AC_TRY_CPP([#include <mntent.h>], om_cv_mnt_type=BSD)
fi
])dnl
AC_MSG_RESULT($om_cv_mnt_type)
case "$om_cv_mnt_type" in
  SYSV) AC_DEFINE(GETMOUNT_TYPE,GETMOUNT_SYSV) ;;
  BSD)  AC_DEFINE(GETMOUNT_TYPE,GETMOUNT_BSD) ;;
  *)    AC_DEFINE(GETMOUNT_TYPE,GETMOUNT_UNKNOWN) ;;
esac
])

dnl OM_CHECK_TYPE(TYPE, DEFAULT, INCLUDE)
AC_DEFUN(OM_CHECK_TYPE,
[AC_REQUIRE([AC_HEADER_STDC])dnl
AC_MSG_CHECKING(for $1)
AC_CACHE_VAL(ac_cv_type_$1,
[AC_EGREP_CPP($1, ifelse([$3], , [[#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#endif]],[[#include <$3>]]), ac_cv_type_$1=yes, ac_cv_type_$1=no)])dnl
AC_MSG_RESULT($ac_cv_type_$1)
if test $ac_cv_type_$1 = no; then
  AC_DEFINE($1, $2)
fi
])

dnl OM_FUNC_LSTAT - determine whether lstat is available.
dnl AC_CHECK_FUNC does not work with Linux libc because lstat is a static
dnl inline function in <sys/stat.h>.
AC_DEFUN(OM_FUNC_LSTAT,
[AC_CACHE_CHECK(for lstat, om_cv_func_lstat,
[AC_TRY_LINK([#include <sys/types.h>
#include <sys/stat.h>], [struct stat statbuf;
lstat("/", &statbuf);], om_cv_func_lstat=yes, om_cv_func_lstat=no)])
test $om_cv_func_lstat = yes && AC_DEFINE(HAVE_LSTAT)
])

dnl OM_FUNC_SIGSETJMP - determine whether sigsetjmp is available
AC_DEFUN(OM_FUNC_SIGSETJMP,
[AC_CACHE_CHECK(for sigsetjmp/siglongjmp, om_cv_func_sigsetjmp,
[AC_TRY_LINK([#include <setjmp.h>], [sigjmp_buf env;
sigsetjmp(env, 1);], om_cv_func_sigsetjmp=yes, om_cv_func_sigsetjmp=no)])
test $om_cv_func_sigsetjmp = yes && AC_DEFINE(HAVE_SIGSETJMP)
])

