/*
 *  Copyright (C) 1998-99 Luca Deri <deri@unipi.it>
 *                      
 *			  Centro SERRA, University of Pisa
 *			  http://www-serra.unipi.it/
 *  					
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ntop.h"

/* Extern */
extern int newSock, refreshRate;
extern time_t initialSniffTime;

#ifdef HAVE_GDBM_H
extern GDBM_FILE gdbm_file, pwFile;
#ifdef MULTITHREADED
extern pthread_mutex_t gdbmMutex;
#endif
#endif

extern FlowFilterList *flowsList;
#ifndef WIN32
extern void execCGI(char* cgiName);
#endif
extern char deviceName[];
#ifdef HAVE_CURSES
extern RETSIGTYPE cleanup(int signo);
#endif
extern int handlePluginHTTPRequest(char* url);
extern void printAllSessionsHTML(char* host);
extern void printMulticastStats(int, int);
extern void printHostsTraffic(int, int, int, int);
extern void printIpAccounting(int, int, int);
extern void printHostsInfo(int, int);
extern void printActiveTCPSessions();
extern void printIpProtocolDistribution(int mode, int);
extern void printIpTrafficMatrix();
extern void printIpProtocolUsage();
extern void printThptStats(int);
extern void printDomainStats(char*, int, int);
extern void showPluginsList();
extern void listNetFlows();
extern void resetStats();
extern void printProtoTraffic();
#ifdef HAVE_LSOF
extern void printLsofData(int mode);
extern void printProcessInfo(int processPid);
#endif
#ifdef MULTITHREADED
extern pthread_mutex_t hostsHashMutex; 
#endif
extern time_t actTime;

/* Forward */
#ifdef HAVE_GDBM_H
extern void showUsers();
extern void addUser(char*);
extern void deleteUser(char*);
extern void doAddUser(int);
extern void showURLs();
extern void addURL(char*);
extern void deleteURL(char*);
extern void doAddURL(int);
#endif

/* Global */
static char requestedURL[128], pw[64];

char *dirs[] = { 
  ".",                   /* Local   */
  "/etc/ntop",           /* Default */
  "/opt/ntop/etc/ntop",  /* Solaris */
  "/usr/local/etc/ntop", /* BSD     */
  NULL };


/* ************************* */

int readHTTPheader() {
  char aChar[8] /* just in case */, lastChar, preLastChar, lineStr[256];
  int rc, idxChar=0, contentLen=-1;

  pw[0] = '\0';
  preLastChar = '\r';
  lastChar = '\n';
  requestedURL[0] = '\0';

  for(;;) {
    rc = recv(newSock, aChar, 1, 0);
      
      if(rc != 1) {
	  idxChar=0;     
	  break; /* Empty line */
	} else {	  
	  if((aChar[0] == '\n') && (lastChar == '\r') && (preLastChar == '\n')) {
	      idxChar=0;
	      break;
	    } else {
	      if(aChar[0] == '\n') {
		  lineStr[idxChar-1] = '\0';

		  /* printf("%s [%d]\n", lineStr, idxChar); */

		  if((idxChar >= 21) && (strncmp(lineStr, "Authorization: Basic ", 21) == 0))
		    strcpy(pw, &lineStr[21]);
		  else if((idxChar >= 16) && (strncasecmp(lineStr, "Content-length: ", 16) == 0)) {
		    contentLen = atoi(&lineStr[16]);
		    /* printf("len=%d [%s/%s]\n", contentLen, lineStr, &lineStr[16]); */
		  } else if((idxChar >= 3) && (strncmp(lineStr, "GET ", 4) == 0)) {
		    strcpy(requestedURL, &lineStr[4]);
		  } else if((idxChar >= 3) && (strncmp(lineStr, "POST ", 5) == 0)) {
		    strcpy(requestedURL, &lineStr[5]);
		  }

		  idxChar=0;
		} else {
		  if(idxChar < 256)
		    lineStr[idxChar++] = aChar[0];
		}

	      preLastChar = lastChar;
	      lastChar = aChar[0];
	    }			 
	}
    }

  return(contentLen);
}

/* ************************* */

int decodeString(char *bufcoded, 
		 unsigned char *bufplain,
		 int outbufsize) {
  /* single character decode */
#define DEC(c) pr2six[(int)c]
#define MAXVAL 63
  unsigned char pr2six[256];
  char six2pr[64] = {
    'A','B','C','D','E','F','G','H','I','J','K','L','M',
    'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
    'a','b','c','d','e','f','g','h','i','j','k','l','m',
    'n','o','p','q','r','s','t','u','v','w','x','y','z',
    '0','1','2','3','4','5','6','7','8','9','+','/'
  };  
  /* static */ int first = 1;

  int nbytesdecoded, j;
  register char *bufin = bufcoded;
  register unsigned char *bufout = bufplain;
  register int nprbytes;

   /* If this is the first call, initialize the mapping table.
    * This code should work even on non-ASCII machines.
    */
  if(first) {
    first = 0;
    for(j=0; j<256; j++) pr2six[j] = MAXVAL+1;
    
    for(j=0; j<64; j++) pr2six[(int)six2pr[j]] = (unsigned char) j;
#if 0
    pr2six['A']= 0; pr2six['B']= 1; pr2six['C']= 2; pr2six['D']= 3; 
    pr2six['E']= 4; pr2six['F']= 5; pr2six['G']= 6; pr2six['H']= 7; 
    pr2six['I']= 8; pr2six['J']= 9; pr2six['K']=10; pr2six['L']=11; 
    pr2six['M']=12; pr2six['N']=13; pr2six['O']=14; pr2six['P']=15; 
    pr2six['Q']=16; pr2six['R']=17; pr2six['S']=18; pr2six['T']=19; 
    pr2six['U']=20; pr2six['V']=21; pr2six['W']=22; pr2six['X']=23; 
    pr2six['Y']=24; pr2six['Z']=25; pr2six['a']=26; pr2six['b']=27; 
    pr2six['c']=28; pr2six['d']=29; pr2six['e']=30; pr2six['f']=31; 
    pr2six['g']=32; pr2six['h']=33; pr2six['i']=34; pr2six['j']=35; 
    pr2six['k']=36; pr2six['l']=37; pr2six['m']=38; pr2six['n']=39; 
    pr2six['o']=40; pr2six['p']=41; pr2six['q']=42; pr2six['r']=43; 
    pr2six['s']=44; pr2six['t']=45; pr2six['u']=46; pr2six['v']=47; 
    pr2six['w']=48; pr2six['x']=49; pr2six['y']=50; pr2six['z']=51; 
    pr2six['0']=52; pr2six['1']=53; pr2six['2']=54; pr2six['3']=55; 
    pr2six['4']=56; pr2six['5']=57; pr2six['6']=58; pr2six['7']=59; 
    pr2six['8']=60; pr2six['9']=61; pr2six['+']=62; pr2six['/']=63;
#endif
  }

  /* Strip leading whitespace. */

  while(*bufcoded==' ' || *bufcoded == '\t') bufcoded++;

  /* Figure out how many characters are in the input buffer.
    * If this would decode into more bytes than would fit into
    * the output buffer, adjust the number of input bytes downwards.
    */
  bufin = bufcoded;
  while(pr2six[(int)*(bufin++)] <= MAXVAL)
    ;
   
  nprbytes = bufin - bufcoded - 1;
  nbytesdecoded = ((nprbytes+3)/4) * 3;
  if(nbytesdecoded > outbufsize) {
    nprbytes = (outbufsize*4)/3;
  }

  bufin = bufcoded;
   
  while (nprbytes > 0) {
    *(bufout++) = (unsigned char) (DEC(*bufin) << 2 | DEC(bufin[1]) >> 4);
    *(bufout++) = (unsigned char) (DEC(bufin[1]) << 4 | DEC(bufin[2]) >> 2);
    *(bufout++) = (unsigned char) (DEC(bufin[2]) << 6 | DEC(bufin[3]));
    bufin += 4;
    nprbytes -= 4;
  }
   
  if(nprbytes & 03) {
    if(pr2six[(int)bufin[-2]] > MAXVAL) {
      nbytesdecoded -= 2;
    } else {
      nbytesdecoded -= 1;
    }
  }

  return(nbytesdecoded);
}

/* ************************* */

void sendStringLen(char *theString, int len) {
  int bytesSent, rc, retries = 0;
  static char buffer[2*BUF_SIZE];

  if(len == 0)
    return; /* Nothing to send */
  else
    memcpy(buffer, theString, len);

  bytesSent = 0;

  while(len > 0)
    {
    RESEND:
      errno=0;
	  
      rc = send(newSock, &buffer[bytesSent], len, 0);

      /* printf("rc=%d\n", rc); */

      if((errno != 0) || (rc < 0))
	{
	  if((errno == EAGAIN /* Resource temporarily unavailable */) && (retries<3))
	    {
	      len -= rc;
	      bytesSent += rc;
	      retries++;
	      goto RESEND;
	    }
	  else if (errno == EPIPE /* Broken pipe: the  client has disconnected */)
	    {
#ifndef WIN32
		  close(newSock);
#else
		  closesocket(newSock);
#endif
	      return;
	    }
	  else if (errno == EBADF /* Bad file descriptor: a 
				     disconnected client is still sending */)
	    return;
	  else
	    return;
	}
      else
	{
	  len -= rc;
	  bytesSent += rc;
	}
    }
}

/* ************************* */

void sendString(char *theString) {
  sendStringLen(theString, strlen(theString));
}

/* ************************* */

void printHTTPheader() {
   char buf[BUF_SIZE];

   sendString("<HTML>\n<HEAD>\n<META HTTP-EQUIV=REFRESH CONTENT=");
   sprintf(buf, "%d", refreshRate); 
   sendString(buf);
   sendString(">\n</HEAD>\n<BODY BGCOLOR=#FFFFFF>\n");
}

/* ************************* */

void printHTTPtrailer() {
  char buf2[BUF_SIZE];
  sendString("\n</CENTER><hr><FONT FACE=Helvetica>");

  sprintf(buf2, "<H5>Report created on %s<br>\n", ctime(&actTime));
  sendString(buf2);
  
  sprintf(buf2, "Generated by <A HREF=\"http://www-serra.unipi.it/~ntop/\">"
	  "ntop</A> v.%s %s [%s]"
	  " listening on %s"
	  "<br>\n", 
	  version, THREAD_MODE, osName, deviceName); 
  sendString(buf2);    
  sendString("<address>&copy; 1998-99 by <A HREF=mailto:deri@unipi.it>L. Deri</A>"
	     "</H5></font></BODY></HTML>\n");
}

/* ************************* */

void returnHTTPaccessDenied() {
  sendString("HTTP/1.0 401 Unauthorized to access the document\n");	
  sendString("WWW-Authenticate: Basic realm=\"ntop HTTP server\"\n");
  sendString("Connection: close\n");
  sendString("Content-Type: text/html\n\n"); 
  sendString("<HTML>\n<TITLE>Error</TITLE>\n<BODY>\n"
	     "<H1>Error 401</H1>\nUnauthorized to access the document\n</BODY>\n</HTML>\n");
}

/* ************************* */

void sendHTTPHeaderType() {
  sendString("Content-type: text/html\n");
  sendString("Cache-Control: no-cache\n");
  sendString("Expires: 0\n\n");
}

/* ************************* */

void sendHTTPProtoHeader() {
  char tmpStr[64];

  sendString("HTTP/1.0 200 OK\n");
  sprintf(tmpStr, "Server: ntop/%s (%s)\n", version, osName);
  sendString(tmpStr);
}

/* ************************* */

void returnHTTPPage(char* pageName, int postLen) {
  char *questionMark = strchr(pageName, '?');
  int sortedColumn, printTrailer=1, idx;
  FILE *fd;
  char tmpStr[256];
  short revertOrder=0;

  if(questionMark == NULL)
    sortedColumn = 0;
  else {
    sortedColumn = abs(atoi(&questionMark[1]));

    if(questionMark[1] == '-')
      revertOrder=1;
  }

  if(pageName[0] == '\0') strcpy(pageName, "index.html");

  /* Search in the local directory first... */
  for(idx=0; dirs[idx] != NULL; idx++) {    
    sprintf(tmpStr, "%s/html/%s", dirs[idx], pageName);    

#ifdef WIN32
    i=0;
    while(tmpStr[i] != '\0') {
      if(tmpStr[i] == '/') tmpStr[i] = '\\';
      i++;
    }
#endif	  
    if((fd = fopen(tmpStr, "rb")) != NULL)
      break;
  }
  
  if(fd != NULL) {
    int len = strlen(pageName);
    
    if((len > 4) 
       && ((strcmp(&pageName[len-4], ".gif") == 0)
	   || (strcmp(&pageName[len-4], ".jpg") == 0))) {

      sendHTTPProtoHeader(); 
      if(strcmp(&pageName[len-4], ".gif") == 0)
	sendString("Content-type: image/gif\n"); 
      else
	sendString("Content-type: image/jpeg\n"); 

      fseek(fd, 0, SEEK_END);
      sprintf(tmpStr, "Content-length: %d\n\n", (len = ftell(fd)));
      fseek(fd, 0, SEEK_SET);
      sendString(tmpStr);
    } else {
      sendHTTPProtoHeader();
      sendHTTPHeaderType();
    }

    for(;;) {
      len = fread(tmpStr, sizeof(char), 255, fd);
      if(len <= 0) break;
      sendStringLen(tmpStr, len);
    }
    
    fclose(fd);
    close(newSock);

    return;
  }

#ifndef WIN32
  if(strncmp(pageName, CGI_HEADER, strlen(CGI_HEADER)) == 0) {
    execCGI(&pageName[strlen(CGI_HEADER)]);
    return;
  }
#endif

  if((strncmp(pageName, PLUGINS_HEADER, strlen(PLUGINS_HEADER)) == 0)
     && handlePluginHTTPRequest(&pageName[strlen(PLUGINS_HEADER)]))
    return;

/* 
   Putting this here (and not on top of this function)
   helps because at least a partial respose
   has been send back to the user in the meantime 
*/
#ifdef MULTITHREADED
  accessMutex(&hostsHashMutex);
#endif

  if(strcmp(pageName, "index.html") == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    sendString("<html>\n");
    sendString("<title>Welcome to ntop!</title>\n");
    sendString("</head>\n");
    sendString("<frameset cols=160,* FRAMESPACING=0 BORDER=0 FRAMEBORDER=0>\n");
    sendString("    <frame src=leftmenu.html name=Menu MARGINWIDTH=0 MARGINHEIGHT=0>\n");
    sendString("    <frame src=home.html name=area MARGINWIDTH=5 MARGINHEIGHT=0>\n");
    sendString("    <noframes>\n");
    sendString("    <body>\n\n");
    sendString("    </body>\n");
    sendString("    </noframes>\n");
    sendString("</frameset>\n");
    sendString("</html>\n");
  } else if(strcmp(pageName, "leftmenu.html") == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    sendString("<HTML>\n<BODY BGCOLOR=#663399 LINK=#CCCCFF VLINK=#FFFFFF>\n<center>\n<pre>\n\n</pre>\n\n");
    sendString("<FONT FACE=Helvetica SIZE=+2 COLOR=#FFFFFF>Welcome<br>to<br>\n");
    sendString("ntop!</FONT>\n<pre>\n</pre>\n");
    sendString("<p></center><p>\n<FONT FACE=Helvetica SIZE=-1 COLOR=#FFFFFF><b>\n<ol>\n");
    sendString("<li><a href=home.html target=area>What's ntop?</a></li>\n");
    sendString("<li>Data Rcvd<ul>");
    sendString("<li><a href="STR_SORT_DATA_RECEIVED_PROTOS" target=area "
	       "ALT=\"Data Received (all protocols)\">All Protoc.</a></li>\n");
    sendString("<li><a href="STR_SORT_DATA_RECEIVED_IP" target=area "
	       "ALT=\"IP Data Received\">IP</a></li>\n");
    sendString("<li><a href="STR_SORT_DATA_RECEIVED_THPT" target=area "
	       "ALT=\"Data Received Throughput\">Thpt</a></li></ul></li>\n");

    sendString("<li>Data Sent<ul>");
    sendString("<li><a href="STR_SORT_DATA_SENT_PROTOS" target=area "
	       "ALT=\"Data Sent (all protocols)\">All Protoc.</a></li>\n");
    sendString("<li><a href="STR_SORT_DATA_SENT_IP" target=area "
	       "ALT=\"IP Data Sent\">IP</a></li>\n");
    sendString("<li><a href="STR_SORT_DATA_SENT_THPT" target=area "
	       "ALT=\"Data Sent Throughput\">Thpt</a></li></ul></li>\n");
    sendString("<li><a href="STR_MULTICAST_STATS" target=area ALT=\"Multicast Stats\">"
	       "Multicast Stats</a></li>\n");
    sendString("<li><a href=trafficStats.html target=area ALT=\"Traffic Statistics\">"
	       "Traffic Stats</a></li>\n");
    sendString("<li><a href="STR_DOMAIN_STATS" target=area ALT=\"Domain Traffic Statistics\">"
	       "Domain Stats</a></li>\n");
    sendString("<li><a href="STR_SHOW_PLUGINS" target=area ALT=\"Plugins List\">"
	       "Plugins</a></li>\n");
    sendString("<li><a href=thptStats.html target=area ALT=\"Throughput Statistics\">"
	       "Thpt Stats</a></li>\n");
    sendString("<li><a href="HOSTS_INFO_HTML" target=area ALT=\"Hosts Information\">"
	       "Hosts Info</a></li>\n");
    sendString("<li><a href=IpR2L.html target=area ALT=\"Remote to Local IP Traffic\">"
	       "R-&gt;L IP Traffic</a></li>\n");
    sendString("<li><a href=IpL2R.html target=area ALT=\"Local to Remote IP Traffic\">"
	       "L-&gt;R IP Traffic</a></li>\n");
    sendString("<li><a href=IpL2L.html target=area ALT=\"Local IP Traffic\">"
	       "L&lt;-&gt;L IP Traffic</a></li>\n");
    sendString("<li><a href=NetNetstat.html target=area ALT=\"Active TCP Sessions\">"
	       "Active TCP Sessions</a></li>\n");
    sendString("<li><a href=ipProtoDistrib.html target=area ALT=\"IP Protocol Distribution\">"
	       "IP Protocol Distribution</a></li>\n");
    sendString("<li><a href=ipProtoUsage.html target=area ALT=\"IP Protocol Subnet Usage\">"
	       "IP Protocol Usage</a></li>\n");
    sendString("<li><a href=ipTrafficMatrix.html target=area ALT=\"IP Traffic Matrix\">"
	       "IP Traffic Matrix</a></li>\n");
#ifdef HAVE_LSOF
    sendString("<li><a href="STR_LSOF_DATA" target=area "
	       "ALT=\"Local Processes Nw Usage\">Local Nw Usage</a></li>\n");
#endif /* HAVE_LSOF */

    if(flowsList != NULL)
      sendString("<li><a href=NetFlows.html target=area ALT=\"NetFlows\">"
		 "NetFlows List</a></li>\n");

    sendString("<li><a href=Credits.html target=area ALT=\"Credits\">Credits</a></li>\n");
#ifdef HAVE_GDBM_H
    sendString("<li><a href=showUsers.html target=area ALT=\"Admin Users\">Admin Users</a></li>\n");
    sendString("<li><a href=showURLs.html target=area ALT=\"Admin URLs\">Admin URLs</a></li>\n");
#endif
    sendString("<li><a href=ntop.html target=area ALT=\"Man Page\">Man Page</a></li>\n");
    sendString("</ol>\n<center>\n<b>\n\n");
    sendString("<pre>\n</pre>&copy; 1998-99<br>by<br>"
	       "<A HREF=\"http://jake.unipi.it/~deri/\" target=\"area\">"
	       "Luca Deri</A></FONT><pre>\n");
    sendString("</pre>\n</b>\n</center>\n</body>\n</html>\n");    
    printTrailer=0;
  } else if(strcmp(pageName, "home.html") == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    sendString("<html>\n<body bgcolor=#FFFFFF><CENTER><FONT FACE=Helvetica><H1>Welcome to ntop!</H1></center><hr>");
    sendString("<b>ntop</b> shows the current network usage. It displays a list of hosts that are\n"); 
    sendString("currently using the network and reports information concerning the IP\n"); 
    sendString("(Internet Protocol) traffic generated by each host. The traffic is \n"); 
    sendString("sorted according to host and protocol. Protocols (user configurable) include:\n"); 
    sendString("<ul><li>TCP/UDP/ICMP<li>(R)ARP<li>IPX<li>DLC<li>Decnet<li>AppleTalk<li>Netbios<li>IP<ul><li>FTP<li>HTTP<li>DNS<li>Telnet<li>SMTP/POP/IMAP<li>SNMP<li>\n"); 
    sendString("NFS<li>X11</ul></UL>\n<p>\n"); 
    sendString("<b>ntop</b>'s author strongly believe in <A HREF=http://www.opensource.org/>\n");
    sendString("open source software</A> and encourage everyone to modify, improve\n ");
    sendString("and extend <b>ntop</b> in the interest of the whole Internet community according\n");
    sendString("to the enclosed licence (see COPYING).<p>Problems, bugs, questions, ");
    sendString("desirable enhancements, source code contributions, etc., should be sent to the ");
    sendString("<A HREF=mailto:ntop@unipi.it> mailing list</A>.\n</font>");
    sendString("</font></body></html>\n");
  } else if(strncmp(pageName, STR_SORT_DATA_RECEIVED_PROTOS, strlen(STR_SORT_DATA_RECEIVED_PROTOS)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHostsTraffic(0, 0, sortedColumn, revertOrder);
  } else if(strncmp(pageName, STR_SORT_DATA_RECEIVED_IP, strlen(STR_SORT_DATA_RECEIVED_IP)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHostsTraffic(0, 1, sortedColumn, revertOrder);
  } else if(strncmp(pageName, STR_SORT_DATA_THPT_STATS, strlen(STR_SORT_DATA_THPT_STATS)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printThptStats(sortedColumn);
  } else if(strncmp(pageName, STR_SORT_DATA_RECEIVED_THPT, strlen(STR_SORT_DATA_RECEIVED_THPT)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHostsTraffic(0, 2, sortedColumn, revertOrder);
  } else if(strncmp(pageName, STR_SORT_DATA_SENT_PROTOS, strlen(STR_SORT_DATA_SENT_PROTOS)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHostsTraffic(1, 0, sortedColumn, revertOrder);
  } else if(strncmp(pageName, STR_SORT_DATA_SENT_IP, strlen(STR_SORT_DATA_SENT_IP)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHostsTraffic(1, 1, sortedColumn, revertOrder);
  } else if(strncmp(pageName, STR_SORT_DATA_SENT_THPT, strlen(STR_SORT_DATA_SENT_THPT)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHostsTraffic(1, 2, sortedColumn, revertOrder);
  } else if(strncmp(pageName, HOSTS_INFO_HTML, strlen(HOSTS_INFO_HTML)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHostsInfo(sortedColumn, revertOrder);
  }
#ifdef HAVE_LSOF
  else if(strncmp(pageName, PROCESS_INFO_HTML, strlen(PROCESS_INFO_HTML)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printProcessInfo(sortedColumn /* process PID */);
  } else if(strncmp(pageName, STR_LSOF_DATA, strlen(STR_LSOF_DATA)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printLsofData(sortedColumn);
  } 
#endif /* HAVE_LSOF */
  else if(strcmp(pageName, "NetFlows.html") == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    listNetFlows();
  } 
  else if(strncmp(pageName, IP_R_2_L_HTML, strlen(IP_R_2_L_HTML)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHTTPheader();
    sendString("<CENTER><p><H1><FONT FACE=Helvetica>Remote to Local IP Traffic</FONT></H1><p>\n");
    printIpAccounting(REMOTE_TO_LOCAL_ACCOUNTING, sortedColumn, revertOrder);
    sendString("</CENTER></BODY></HTML>\n");
  } else if(strncmp(pageName, IP_L_2_R_HTML, strlen(IP_L_2_R_HTML)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHTTPheader();
    sendString("<CENTER><p><H1><FONT FACE=Helvetica>Local to Remote IP Traffic</FONT></H1><p>\n");
    printIpAccounting(LOCAL_TO_REMOTE_ACCOUNTING, sortedColumn, revertOrder);
    sendString("</CENTER></BODY></HTML>\n");
 } else if(strncmp(pageName, IP_L_2_L_HTML, strlen(IP_L_2_L_HTML)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHTTPheader();
    sendString("<CENTER><p><H1><FONT FACE=Helvetica>Local IP Traffic</FONT></H1><p>\n");
    printIpAccounting(LOCAL_TO_LOCAL_ACCOUNTING, sortedColumn, revertOrder);
    sendString("</CENTER></BODY></HTML>\n");
  } else if(strcmp(pageName, "NetNetstat.html") == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHTTPheader();
    sendString("<CENTER><p><H1><FONT FACE=Helvetica>Active TCP Sessions</FONT></H1><p>\n");
    printActiveTCPSessions();
    sendString("</CENTER></BODY></HTML>\n");
  } else if(strncmp(pageName, RESET_STATS_HTML, strlen(RESET_STATS_HTML)) == 0) {
    /* Courtesy of Daniel Savard <daniel.savard@gespro.com> */
    printHTTPheader();
     resetStats();
     sendString("<CENTER><p><H1><FONT FACE=Helvetica>All statistics are now reseted</FONT></H1><p>\n");
     sendString("</CENTER></BODY></HTML>\n"); 
  } else if(strncmp(pageName, STR_MULTICAST_STATS, strlen(STR_MULTICAST_STATS)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printMulticastStats(sortedColumn, revertOrder);
  } else if(strncmp(pageName, STR_DOMAIN_STATS, strlen(STR_DOMAIN_STATS)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printDomainStats(NULL, abs(sortedColumn), revertOrder);
  } else if(strncmp(pageName, STR_SHOW_PLUGINS, strlen(STR_SHOW_PLUGINS)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    showPluginsList();
  } else if(strncmp(pageName, DOMAIN_INFO_HTML, strlen(DOMAIN_INFO_HTML)) == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    if(questionMark == NULL) questionMark = "";
    pageName[strlen(pageName)-5-strlen(questionMark)] = '\0';
    printDomainStats(&pageName[strlen(DOMAIN_INFO_HTML)+1], abs(sortedColumn), revertOrder);
  } else if(strcmp(pageName, "trafficStats.html") == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHTTPheader();
    printHostsTraffic(2, 0, 0, revertOrder);
    printProtoTraffic();
    sendString("<p>\n");
    printIpProtocolDistribution(LONG_FORMAT, revertOrder);
    sendString("<p></BODY></HTML>\n");
  } else if(strcmp(pageName, "ipProtoDistrib.html") == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHTTPheader();
    printIpProtocolDistribution(SHORT_FORMAT, revertOrder);
    sendString("</BODY></HTML>\n");
  } else if(strcmp(pageName, "ipTrafficMatrix.html") == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHTTPheader();
    sendString("<CENTER><p><H1><FONT FACE=Helvetica>IP Subnet Traffic Matrix</FONT></H1><p>\n");
    printIpTrafficMatrix();
    sendString("</BODY></HTML>\n");
  } else if(strcmp(pageName, "ipProtoUsage.html") == 0) {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHTTPheader();
    sendString("<CENTER><p><H1><FONT FACE=Helvetica>IP Protocol Subnet Usage</FONT></H1><p>\n");
    printIpProtocolUsage();
    sendString("</BODY></HTML>\n");
   } else if(strcmp(pageName, "Credits.html") == 0) {
     sendHTTPProtoHeader(); sendHTTPHeaderType();
     sendString("<HTML>\n<BODY BGCOLOR=#FFFFFF>\n<FONT FACE=Helvetica>\n");
     sendString("<H1><center>Credits</H1></center><p><hr><br><b>ntop</b> has been created by\n");
     sendString("<A HREF=\"http://jake.unipi.it/~deri/\">Luca Deri</A> while studying how to model\n");
     sendString("network traffic. He was unsatisfied of the many network traffic analysis tools\n");
     sendString("he had access to, and decided to write a new application able to report network\n");
     sendString("traffic information in a way similar to the popular Unix top command. At that \n");
     sendString("point in time (it was June 1998) <b>ntop</b> was born.<p>The current release is very\n");
     sendString("different from the initial one for several reasons. In particular it: <ul>\n");
     sendString("<li>is much more sofisticated <li>has both a command line and a web interface\n");
     sendString("<li>is capable of handling both IP and non IP protocols </ul> <p> Although it\n");
     sendString("might not seem so, <b>ntop</b> has definitively more than an author.\n");
     sendString("<A HREF=\"mailto:stefano@unipi.it\">Stefano Suin</A> has contributed with ");
     sendString("some code fragments to the verion 1.0 of <b>ntop</b>\n");
     sendString("crew. In addition, many other people downloaded this program, tested it,\n");
     sendString("joined the <A HREF=http://mailserver.unipi.it/lists/ntop/archive/>ntop mailing list</A>,\n");
     sendString("reported problems, changed it and improved significantly. This is because\n");
     sendString("they have realised that <b>ntop</b> doesn't belong uniquely to its author, but\n");
     sendString("to the whole Internet community. Their names are throught "
		"the whole <b>ntop</b> code.<p>");
     sendString("The author would like to thank all these people who contributed to <b>ntop</b> and\n");
     sendString("turned it into a first class network monitoring tool. Many thanks guys!<p>\n");
     sendString("</FONT><p>\n");
#ifdef HAVE_GDBM_H
   } else if(strcmp(pageName, "showUsers.html") == 0) {
     sendHTTPProtoHeader(); sendHTTPHeaderType();
     showUsers();     
   } else if(strcmp(pageName, "addUser.html") == 0) {
     sendHTTPProtoHeader(); sendHTTPHeaderType();
     addUser(NULL);     
   } else if(strncmp(pageName, "modifyUser", strlen("modifyUser")) == 0) {
     sendHTTPProtoHeader(); sendHTTPHeaderType();
     if((questionMark == NULL) || (questionMark[0] == '\0')) 
		 addUser(NULL);
	 else
		 addUser(&questionMark[1]);
   } else if(strncmp(pageName, "deleteUser", strlen("deleteUser")) == 0) {
     if((questionMark == NULL) || (questionMark[0] == '\0')) 
		 deleteUser(NULL);
	 else
		 deleteUser(&questionMark[1]);
   } else if(strcmp(pageName, "doAddUser") == 0) {
     doAddUser(postLen);     
   } else if(strcmp(pageName, "showURLs.html") == 0) {
     sendHTTPProtoHeader(); sendHTTPHeaderType();
     showURLs();     
   } else if(strcmp(pageName, "addURL.html") == 0) {
     sendHTTPProtoHeader(); sendHTTPHeaderType();
     addURL(NULL);     
   } else if(strncmp(pageName, "modifyURL", strlen("modifyURL")) == 0) {
     sendHTTPProtoHeader(); sendHTTPHeaderType();
     if((questionMark == NULL) || (questionMark[0] == '\0')) 
		 addURL(NULL);
	 else
		 addURL(&questionMark[1]);
   } else if(strncmp(pageName, "deleteURL", strlen("deleteURL")) == 0) {
     if((questionMark == NULL) || (questionMark[0] == '\0')) 
		 deleteURL(NULL);
	 else
		 deleteURL(&questionMark[1]);
   } else if(strcmp(pageName, "doAddURL") == 0) {
     doAddURL(postLen);     
#endif /* HAVE_GDBM_H */
    } else if(strlen(pageName) > 5) {
    int i;
    char hostName[32];

    pageName[strlen(pageName)-5] = '\0';

    /* Patch for ethernet addresses and MS Explorer */
    for(i=0; pageName[i] != '\0'; i++) 
      if(pageName[i] == '_')
	pageName[i] = ':';

    strcpy(hostName, pageName);
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHTTPheader();
    printAllSessionsHTML(hostName);
    sendString("</CENTER>\n");
  } else {
    sendHTTPProtoHeader(); sendHTTPHeaderType();
    printHTTPheader();
    sendString("<HTML>\n<TITLE>???</TITLE>\n<BODY>\n<H1>Error</H1>\nUnknown page\n"); 
  }

  if(printTrailer && (postLen == -1)) printHTTPtrailer();

#ifdef MULTITHREADED
  releaseMutex(&hostsHashMutex);
#endif      
}

/* ************************* */

/* similar to Java.String.trim() */
void trimString(char* str)
{
  int len = strlen(str), i, idx;
  char out[512];

  for(i=0, idx=0; i<len; i++)
    {
      switch(str[i])
	{
	case ' ':
	case '\t':
	  if((idx > 0) 
	     && (out[idx-1] != ' ') 
	     && (out[idx-1] != '\t'))
	  out[idx++] = str[i];
	  break;
	default:
	  out[idx++] = str[i];
	  break;
	}
    }

  out[idx] = '\0';
  strcpy(str, out);
}

/* ************************* */

#ifndef HAVE_GDBM_H
int checkHTTPpassword(char *requestedURL) {
  return 1; /* Access granted - security is disabled */
}
#else
int checkHTTPpassword(char *requestedURL) {
  char outBuffer[64], *user, users[BUF_SIZE];
  int i, rc;
  datum key_data, return_data;

#ifdef DEBUG
  printf("Checking '%s'\n", requestedURL);
#endif

#ifdef MULTITHREADED
  accessMutex(&gdbmMutex);
#endif 
  return_data = gdbm_firstkey (pwFile);
  outBuffer[0] = '\0';

  while (return_data.dptr != NULL) {   
    key_data = return_data;
   
    if(key_data.dptr[0] == '2') /* 2 = URL */ { 
      if(strncmp(&requestedURL[1], &key_data.dptr[1], 
		 strlen(key_data.dptr)-1) == 0) {  
	strcpy(outBuffer, key_data.dptr);
	free (key_data.dptr);
	break;
      }
    }

    return_data = gdbm_nextkey(pwFile, key_data);
    free(key_data.dptr);
  }

  if(outBuffer[0] == '\0') {
#ifdef MULTITHREADED
    releaseMutex(&gdbmMutex);
#endif 
    return 1; /* This is a non protected URL */
  }

  key_data.dptr = outBuffer;
  key_data.dsize = strlen(outBuffer)+1;
  return_data = gdbm_fetch(pwFile, key_data);

  i = decodeString(pw, (unsigned char*)outBuffer, 64);

  if(i == 0) {
      user = "", pw[0] = '\0';
      outBuffer[0] = '\0';
   } else {
      outBuffer[i] = '\0';

      for(i=0; i<64; i++)
	if(outBuffer[i] == ':')
	  {
	    outBuffer[i] = '\0';
	    user = outBuffer;
	    break;
	  }

      strcpy(pw, &outBuffer[i+1]);
    }

#ifdef DEBUG
  printf("User='%s' - Pw='%s'\n", user, pw);
#endif

  sprintf(users, "1%s", user);

  if(strstr(return_data.dptr, users) == NULL) {
#ifdef MULTITHREADED
    releaseMutex(&gdbmMutex);
#endif 
    return 0; /* The specified user is not among those who are
		 allowed to access the URL */
  }

  key_data.dptr = users;
  key_data.dsize = strlen(users)+1;
  return_data = gdbm_fetch(pwFile, key_data);


  if (return_data.dptr != NULL) {
#ifdef WIN32
	rc = !strcmp(return_data.dptr, pw);
#else
	rc = !strcmp(return_data.dptr, 
		     (char*)crypt((const char*)pw, (const char*)CRYPT_SALT));
#endif
    free (return_data.dptr);  
  } else
    rc = 0;
  
#ifdef MULTITHREADED
    releaseMutex(&gdbmMutex);
#endif 
  return(rc);
}
#endif

/* ************************* */

void handleHTTPrequest() {
  int postLen = readHTTPheader();
  
  if(checkHTTPpassword(requestedURL) != 1) {
    returnHTTPaccessDenied();
    return;
  }
  
  /* fprintf(stdout, "URL = '%s'\n", requestedURL);  */

  actTime = time(NULL); /* Don't forget this */

  if((requestedURL[0] == '\0')
     || (strncmp(requestedURL, "/", 1) == 0)
     || (strncmp(requestedURL, "/index.html", strlen("/index.html")) == 0)
     || (strncmp(requestedURL, "/leftmenu.html", strlen("/leftmenu.html")) == 0)
     || (strncmp(requestedURL, "/home.html", strlen("/home.html")) == 0)) {
    requestedURL[strlen(requestedURL)-9] = '\0';
    returnHTTPPage(&requestedURL[1], postLen);
  } else {
    char buf[64];

    sendString("HTTP/1.0 200 OK\n");
    sprintf(buf, "Server: ntop/%s (%s)\n", version, osName);
    sendString(buf);
    sendHTTPProtoHeader(); sendHTTPHeaderType(); 
    sendString("<HTML>\n<TITLE>???</TITLE>\n<BODY>\n"
	       "<H1>Error</H1>\nUnkown page\n</BODY>\n</HTML>\n");
  }
}

