.TH EXPORTS 5 "28 October 1999"
.UC 5
.SH NAME
exports \- NFS file systems being exported (for Kernel based NFS)
.SH SYNOPSIS
.B /etc/exports
.SH DESCRIPTION
The file
.I /etc/exports
serves as the access control list for file systems which may be
exported to NFS clients.  It is used by
.IR exportfs (8)
to give information to
.IR mountd (8)
and to the kernel based NFS file server daemon
.IR nfsd (8).
.PP
The file format is similar to the SunOS
.I exports
file, except that several additional options are permitted.  Each line
contains an export point and a list of machine or netgroup names allowed
to mount the file system at that point.  An optional parenthesized list
of export parameters may follow each machine name.  Blank lines are
ignored, and a # introduces a comment to the end of the line. Entries may
be continued across newlines using a backslash.
.PP
.SS Machine Name Formats
NFS clients may be specified in a number of ways:
.IP "single host
This is the most common format. You may specify a host either by an
abbreviated name recognized be the resolver, the fully qualified domain
name, or an IP address.
.IP "netgroups
NIS netgroups may be given as
.IR @group .
Only the host part of each
netgroup members is consider in checking for membership.  Empty host
parts or those containing a single dash (\-) are ignored.
.IP "wildcards
Machine names may contain the wildcard characters \fI*\fR and \fI?\fR.
This can be used to make the \fIexports\fR file more compact; for instance,
\fI*.cs.foo.edu\fR matches all hosts in the domain \fIcs.foo.edu\fR. However,
these wildcard characters do not match the dots in a domain name, so the
above pattern does not include hosts such as \fIa.b.cs.foo.edu\fR.
.IP "IP networks
You can also export directories to all hosts on an IP (sub-) network
simultaneously. This is done by specifying an IP address and netmask pair
as
.IR address/netmask .
.TP
'''.B =public
'''This is a special ``hostname'' that identifies the given directory name
'''as the public root directory (see the section on WebNFS in
'''.BR nfsd (8)
'''for a discussion of WebNFS and the public root handle). When using this
'''convention,
'''.B =public
'''must be the only entry on this line, and must have no export options
'''associated with it. Note that this does
'''.I not
'''actually export the named directory; you still have to set the exports
'''options in a separate entry.
'''.PP
'''The public root path can also be specified by invoking
'''.I nfsd
'''with the
'''.B \-\-public\-root
'''option. Multiple specifications of a public root will be ignored.
.PP
.SS General Options
.IR exportfs
understands the following export options:
.TP
.IR secure "\*d
This option requires that requests originate on an internet port less
than IPPORT_RESERVED (1024). This option is on by default. To turn it
off, specify
.IR insecure .
.TP
.IR rw
Allow both read and write requests on this NFS volume. The
default is to disallow any request which changes the filesystem.
This can also be made explicit by using
the
.IR ro " option.
.TP
.IR sync
This option requests that all file writes be committed to disc before
the write request completes.  This is required for complete safety of
data in the face of a server crash, but incurs a performance hit.
The default is to allow the server to write the data out whenever it
is ready.  This can be explicitly requested with the
.IR async " option.
.TP
.IR no_wdelay
This option only has effect if
.I sync
is also set.  The NFS server will normally delay committing a write request
to disc slightly if it suspects that another related write request may be in
progress or may arrive soon.  This allows multiple write requests to
be committed to disc with the one operation which can improve
performance.  If an NFS server received mainly small unrelated
requests, this behaviour could actually reduce performance, so
.IR no_wdelay
is available to turn it off.
The default can be explicitly requested with the
.IR wdelay " option.
.TP
.IR nohide
This option is based on the option of the same name provided in IRIX
NFS.  Normally, if a server exports two filesystems one of which is
mounted on the other, then the client will have to mount both
filesystems explicitly to get access to them.  If it just mounts the
parent, it will see an empty directory at the place where the other
filesystem is mounted.  That filesystem is "hidden".

Setting the
.I nohide
option on a filesystem causes it not to be hidden, and an
appropriately authorised client will be able to move from the parent to
that filesystem without noticing the change.

However, some NFS clients do not cope well with this situation as, for
instance, it is then possible for two files in the one apparent
filesystem to have the same inode number.

The
.I nohide
option is currently only effective on
.I "single host
exports.  It does not work reliably with netgroup, subnet, or wildcard
exports. 

This option can be very useful in some situations, but it should be
used with due care, and only after confirming that the client system
copes with the situation effectively.

The option can be explicitly disabled with
.IR hide .
.TP
.IR no_subtree_check
This option disables subtree checking, which has mild security
implications, but can improve reliability is some circumstances.

If a subdirectory of a filesystem is exported, but the whole
filesystem isn't then whenever a NFS request arrives, the server must
check not only that the accessed file is in the appropriate filesystem
(which is easy) but also that it is in the exported tree (which is
harder). This check is called the
.IR subtree_check .

In order to perform this check, the server must include some
information about the location of the file in the "filehandle" that is
given to the client.  This can cause problems with accessing files that
are renamed while a client has them open (though in many simple cases
it will still work).

subtree checking is also used to make sure that files inside
directories to which only root has access can only be accessed if the
filesystem is exported with
.I no_root_squash
(see below), even the file itself allows more general access.

As a general guide, a home directory filesystem, which is normally
exported at the root and may see lots of file renames, should be
exported with subtree checking disabled.  A filesystem which is mostly
readonly, and at least doesn't see many file renames (e.g. /usr or
/var) and for which subdirectories may be exported, should probably be
exported with subtree checks enabled.

The default of having subtree checks enabled, can be explicitly
requested with
.IR subtree_check .

.TP
.IR insecure_locks
.TP
.IR no_auth_nlm
This option (the two names are synonymous) tells the NFS server not to require authentication of
locking requests (i.e. requests which use the NLM protocol).  Normally
the NFS server will require a lock request to hold a credential for a
user who has read access to the file.  With this flag no access checks
will be performed.

Early NFS client implementations did not send credentials with lock
requests, and many current NFS clients still exist which are based on
the old implementations.  Use this flag if you find that you can only
lock files which are world readable.

The default behaviour of requiring authentication for NLM requests can
be explicitly requested with either of the synonymous
.IR auth_nlm ,
or
.IR secure_locks .

'''.TP
'''.I noaccess
'''This makes everything below the directory inaccessible for the named
'''client.  This is useful when you want to export a directory hierarchy to
'''a client, but exclude certain subdirectories. The client's view of a
'''directory flagged with noaccess is very limited; it is allowed to read
'''its attributes, and lookup `.' and `..'. These are also the only entries
'''returned by a readdir.
'''.TP
'''.IR link_relative
'''Convert absolute symbolic links (where the link contents start with a
'''slash) into relative links by prepending the necessary number of ../'s
'''to get from the directory containing the link to the root on the
'''server.  This has subtle, perhaps questionable, semantics when the file
'''hierarchy is not mounted at its root.
'''.TP
'''.IR link_absolute
'''Leave all symbolic link as they are. This is the default operation.
.SS User ID Mapping
.PP
.I nfsd
bases its access control to files on the server machine on the uid and
gid provided in each NFS RPC request. The normal behavior a user would
expect is that she can access her files on the server just as she would
on a normal file system. This requires that the same uids and gids are
used on the client and the server machine. This is not always true, nor
is it always desirable.
.PP
Very often, it is not desirable that the root user on a client machine
is also treated as root when accessing files on the NFS server. To this
end, uid 0 is normally mapped to a different id: the so-called
anonymous or
.I nobody
uid. This mode of operation (called `root squashing') is the default,
and can be turned off with
.IR no_root_squash .
.PP
By default,
'''.I nfsd
'''tries to obtain the anonymous uid and gid by looking up user
'''.I nobody
'''in the password file at startup time. If it isn't found, a uid and gid
.I exportfs
chooses a uid and gid
of -2 (i.e. 65534) for squashed access. These values can also be overridden by
the
.IR anonuid " and " anongid
options.
'''.PP
'''In addition to this, 
'''.I nfsd
'''lets you specify arbitrary uids and gids that should be mapped to user
'''nobody as well.
Finally, you can map all user requests to the
anonymous uid by specifying the
.IR all_squash " option.
'''.PP 
'''For the benefit of installations where uids differ between different
'''machines, 
'''.I nfsd
'''provides several mechanism to dynamically map server uids to client
'''uids and vice versa: static mapping files, NIS-based mapping, and
'''.IR ugidd -based
'''mapping.
'''.PP
'''.IR ugidd -based
'''mapping is enabled with the 
'''.I map_daemon
'''option, and uses the UGID RPC protocol. For this to work, you have to run
'''the
'''.IR ugidd (8)
'''mapping daemon on the client host. It is the least secure of the three methods,
'''because by running
'''.IR ugidd ,
'''everybody can query the client host for a list of valid user names. You
'''can protect yourself by restricting access to
'''.I ugidd
'''to valid hosts only. This can be done by entering the list of valid
'''hosts into the
'''.I hosts.allow
'''or 
'''.I hosts.deny
'''file. The service name is
'''.IR ugidd .
'''For a description of the file's syntax, please read
'''.IR hosts_access (5).
'''.PP
'''Static mapping is enabled by using the
'''.I map_static
'''option, which takes a file name as an argument that describes the mapping.
'''NIS-based mapping queries the client's NIS server to obtain a mapping from
'''user and group names on the server host to user and group names on the
'''client.
.PP
Here's the complete list of mapping options:
.TP
.IR root_squash
Map requests from uid/gid 0 to the anonymous uid/gid. Note that this does
not apply to any other uids that might be equally sensitive, such as user
.IR bin .
.TP
.IR no_root_squash
Turn off root squashing. This option is mainly useful for diskless clients.
'''.TP
'''.IR squash_uids " and " squash_gids
'''This option specifies a list of uids or gids that should be subject to
'''anonymous mapping. A valid list of ids looks like this:
'''.IP
'''.IR squash_uids=0-15,20,25-50
'''.IP
'''Usually, your squash lists will look a lot simpler.
.TP
.IR all_squash
Map all uids and gids to the anonymous user. Useful for NFS-exported
public FTP directories, news spool directories, etc. The opposite option
is 
.IR no_all_squash ,
which is the default setting.
'''.TP
'''.IR map_daemon
'''This option turns on dynamic uid/gid mapping. Each uid in an NFS request
'''will be translated to the equivalent server uid, and each uid in an
'''NFS reply will be mapped the other way round. This option requires that
'''.IR rpc.ugidd (8)
'''runs on the client host. The default setting is
'''.IR map_identity ,
'''which leaves all uids untouched. The normal squash options apply regardless
'''of whether dynamic mapping is requested or not.
'''.TP
'''.IR map_static
'''This option enables static mapping. It specifies the name of the file
'''that describes the uid/gid mapping, e.g.
'''.IP
'''.IR map_static=/etc/nfs/foobar.map
'''.IP
'''The file's format looks like this
'''.IP
'''.nf
'''.ta +3i
'''# Mapping for client foobar:
'''#    remote     local
'''uid  0-99       -       # squash these
'''uid  100-500    1000    # map 100-500 to 1000-1400
'''gid  0-49       -       # squash these
'''gid  50-100     700     # map 50-100 to 700-750
'''.fi
'''.TP
'''.IR map_nis
'''This option enables NIS-based uid/gid mapping. For instance, when
'''the server encounters the uid 123 on the server, it will obtain the
'''login name associated with it, and contact the NFS client's NIS server
'''to obtain the uid the client associates with the name.
'''.IP
'''In order to do this, the NFS server must know the client's NIS domain.
'''This is specified as an argument to the
'''.I map_nis
'''options, e.g.
'''.IP
'''.I map_nis=foo.com
'''.IP
'''Note that it may not be sufficient to simply specify the NIS domain
'''here; you may have to take additional actions before
'''.I nfsd
'''is actually able to contact the server. If your distribution uses
'''the NYS library, you can specify one or more NIS servers for the
'''client's domain in
'''.IR /etc/yp.conf .
'''If you are using a different NIS library, you may have to obtain a
'''special
'''.IR ypbind (8)
'''daemon that can be configured via
'''.IR yp.conf .
.TP
.IR anonuid " and " anongid
These options explicitly set the uid and gid of the anonymous account.
This option is primarily useful for PC/NFS clients, where you might want
all requests appear to be from one user. As an example, consider the
export entry for
.B /home/joe
in the example section below, which maps all requests to uid 150 (which
is supposedly that of user joe).
.IP
.SH EXAMPLE
.PP
.nf
.ta +3i
# sample /etc/exports file
/               master(rw) trusty(rw,no_root_squash)
/projects       proj*.local.domain(rw)
/usr            *.local.domain(ro) @trusted(rw)
/home/joe       pc001(rw,all_squash,anonuid=150,anongid=100)
/pub            (ro,insecure,all_squash)
'''/pub/private    (noaccess)
.fi
.PP
The first line exports the entire filesystem to machines master and trusty.
In addition to write access, all uid squashing is turned off for host
trusty. The second and third entry show examples for wildcard hostnames
and netgroups (this is the entry `@trusted'). The fourth line shows the
entry for the PC/NFS client discussed above. Line 5 exports the
public FTP directory to every host in the world, executing all requests
under the nobody account. The
.I insecure 
option in this entry also allows clients with NFS implementations that
don't use a reserved port for NFS.
''' The last line denies all NFS clients
'''access to the private directory.
'''.SH CAVEATS
'''Unlike other NFS server implementations, this
'''.I nfsd
'''allows you to export both a directory and a subdirectory thereof to
'''the same host, for instance 
'''.IR /usr " and " /usr/X11R6 .
'''In this case, the mount options of the most specific entry apply. For
'''instance, when a user on the client host accesses a file in 
'''.IR /usr/X11R6 ,
'''the mount options given in the 
'''.I /usr/X11R6 
'''entry apply. This is also true when the latter is a wildcard or netgroup
'''entry.
.SH FILES
/etc/exports
'''.SH DIAGNOSTICS
'''An error parsing the file is reported using syslogd(8) as level NOTICE from
'''a DAEMON whenever nfsd(8) or mountd(8) is started up.  Any unknown
'''host is reported at that time, but often not all hosts are not yet known
'''to named(8) at boot time, thus as hosts are found they are reported
'''with the same syslogd(8) parameters.
