#include "links.h"

/*static inline struct session *get_term_session(struct terminal *term)
{
	if ((void *)term->windows.prev == &term->windows) {
		internal("terminal has no windows");
		return NULL;
	}
	return ((struct window *)term->windows.prev)->data;
}*/

void menu_about(struct terminal *term, void *d, struct session *ses)
{
	msg_box(term, NULL, get_text("About"), AL_CENTER, get_text("Links " VERSION_STRING "\n\nLynx-like text WWW browser"), NULL, 1, get_text("OK"), NULL, B_ENTER | B_ESC);
}

void menu_keys(struct terminal *term, void *d, struct session *ses)
{
	msg_box(term, NULL, get_text("Keys"), AL_LEFT, get_text("ESC      display menu\n^C       quit\n^P, ^N   scroll up, down\n[, ]     scroll left, right\nup, down select link\n->       follow link\n<-       go back\ng        go to url\n/        search\n?        search back\nn        find next\nN        find previous\n=        document info\n\\        document source\nd        download"), NULL, 1, get_text("OK"), NULL, B_ENTER | B_ESC);
}

void menu_copying(struct terminal *term, void *d, struct session *ses)
{
	msg_box(term, NULL, get_text("Copying"), AL_CENTER, get_text("Links " VERSION_STRING "\n\n(C) 1999 Mikulas Patocka\n\nThis program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version."), NULL, 1, get_text("OK"), NULL, B_ENTER | B_ESC);
}

void menu_for_frame(struct terminal *term, void (*f)(struct session *, struct f_data_c *, int), struct session *ses)
{
	do_for_frame(ses, f, 0);
}

void menu_goto_url(struct terminal *term, void *d, struct session *ses)
{
	dialog_goto_url(ses);
}

void menu_save_url_as(struct terminal *term, void *d, struct session *ses)
{
	dialog_save_url(ses);
}

void menu_go_back(struct terminal *term, void *d, struct session *ses)
{
	go_back(ses);
}

void menu_reload(struct terminal *term, void *d, struct session *ses)
{
	reload(ses, -1);
}

void exit_prog(struct terminal *term, void *d, struct session *ses)
{
	register_bottom_half((void (*)(void *))destroy_terminal, term);
}

/*struct refresh {
	struct terminal *term;
	struct window *win;
	struct session *ses;
	void (*fn)(struct terminal *term, void *d, struct session *ses);
	void *data;
	int timer;
};

void refresh(struct refresh *r)
{
	delete_window(r->win);
	r->fn(r->term, r->data, r->ses);
	mem_free(r);
}

void end_refresh(struct refresh *r)
{
	if (r->timer != -1) kill_timer(r->timer);
	mem_free(r);
}*/

void cache_inf(struct terminal *term, void *d, struct session *ses)
{
	unsigned char *a;
	int l = 0;
	/*struct refresh *r;*/
	if (!(a = init_str())) return;
	/*if (!(r = mem_alloc(sizeof(struct refresh)))) {
		mem_free(a);
		return;
	}
	r->term = term;
	r->win = NULL;
	r->ses = ses;
	r->fn = cache_inf;
	r->data = d;
	r->timer = -1;*/
	add_to_str(&a, &l, get_text("Resources: "));
	add_num_to_str(&a, &l, select_info(CI_FILES));
	add_to_str(&a, &l, get_text(" handles, "));
	add_num_to_str(&a, &l, select_info(CI_TIMERS));
	add_to_str(&a, &l, get_text(" timers."));
	add_to_str(&a, &l, "\n");
	add_to_str(&a, &l, get_text("Connections: "));
	add_num_to_str(&a, &l, connect_info(CI_FILES));
	add_to_str(&a, &l, get_text(" connections, "));
	add_num_to_str(&a, &l, connect_info(CI_CONNECTING));
	add_to_str(&a, &l, get_text(" connecting, "));
	add_num_to_str(&a, &l, connect_info(CI_TRANSFER));
	add_to_str(&a, &l, get_text(" transferring, "));
	add_num_to_str(&a, &l, connect_info(CI_KEEP));
	add_to_str(&a, &l, get_text(" keepalive."));
	add_to_str(&a, &l, "\n");
	add_to_str(&a, &l, get_text("Memory cache: "));
	add_num_to_str(&a, &l, cache_info(CI_BYTES));
	add_to_str(&a, &l, get_text(" bytes, "));
	add_num_to_str(&a, &l, cache_info(CI_FILES));
	add_to_str(&a, &l, get_text(" files, "));
	add_num_to_str(&a, &l, cache_info(CI_LOCKED));
	add_to_str(&a, &l, get_text(" locked, "));
	add_num_to_str(&a, &l, cache_info(CI_LOADING));
	add_to_str(&a, &l, get_text(" loading."));
	add_to_str(&a, &l, "\n");
	add_to_str(&a, &l, get_text("Formatted document cache: "));
	add_num_to_str(&a, &l, formatted_info(CI_FILES));
	add_to_str(&a, &l, get_text(" documents, "));
	add_num_to_str(&a, &l, formatted_info(CI_LOCKED));
	add_to_str(&a, &l, get_text(" locked."));
	msg_box(term, getml(a, NULL), get_text("Resources"), AL_LEFT, a, /*r*/NULL, 1, get_text("OK"), /*end_refresh*/ NULL, B_ENTER | B_ESC);
	/*r->win = term->windows.next;
	r->timer = install_timer(RESOURCE_INFO_REFRESH, (void (*)(void *))refresh, r);*/
}

#ifdef DEBUG

void list_cache(struct terminal *term, void *d, struct session *ses)
{
	unsigned char *a;
	int l = 0;
	/*struct refresh *r;*/
	struct cache_entry *ce, *cache;
	if (!(a = init_str())) return;
	/*if (!(r = mem_alloc(sizeof(struct refresh)))) {
		mem_free(a);
		return;
	}
	r->term = term;
	r->win = NULL;
	r->ses = ses;
	r->fn = list_cache;
	r->data = d;
	r->timer = -1;*/
	cache = (struct cache_entry *)cache_info(CI_LIST);
	add_to_str(&a, &l, get_text("Cache content:"));
	foreach(ce, *cache) {
		add_to_str(&a, &l, "\n");
		add_to_str(&a, &l, ce->url);
	}
	msg_box(term, getml(a, NULL), get_text("Cache info"), AL_LEFT, a, /*r*/ NULL, 1, get_text("OK"), /*end_refresh*/ NULL, B_ENTER | B_ESC);
	/*r->win = term->windows.next;
	r->timer = install_timer(RESOURCE_INFO_REFRESH, (void (*)(void *))refresh, r);*/
}

#endif

#ifdef LEAK_DEBUG

void memory_cld(struct terminal *term, void *d)
{
	last_mem_amount = mem_amount;
#ifdef MAX_DEBUG_SIZE
	memcpy(last_debug_sizes, debug_sizes, sizeof(long) * MAX_DEBUG_SIZE);
#endif
#ifdef MAX_LIST_SIZE
	memcpy(last_memory_list, memory_list, sizeof(struct md) * MAX_LIST_SIZE);
#endif
}

#define MSG_BUF	2000
#define MSG_W	100

void memory_info(struct terminal *term, void *d, struct session *ses)
{
	char message[MSG_BUF];
	char *p = message;
	p += sprintf(p, "%ld %s", mem_amount, get_text("memory allocated"));
	if (last_mem_amount != -1) p += sprintf(p, ", %s %ld, %s %ld", get_text("last"), last_mem_amount, get_text("difference"), mem_amount - last_mem_amount);
	p += sprintf(p, ".");
#ifdef MAX_DEBUG_SIZE
	if (last_mem_amount != -1) {
		long i;
		int l = 0;
		for (i = 0; i < MAX_DEBUG_SIZE; i++) if (debug_sizes[i] != last_debug_sizes[i]) {
			if (!l) p += sprintf(p, "\n%s", get_text("Differences: ")), l = 1;
			else p += sprintf(p, ", ");
			p += sprintf(p, "%ldx%ld", debug_sizes[i] - last_debug_sizes[i], i);
			if (p - message >= MSG_BUF - MSG_W) {
				p += sprintf(p, "..");
				break;
			}
		}
		if (!l) p += sprintf(p, "\n%s", get_text("No differences"));
		p += sprintf(p, ".");
	}
#endif
#ifdef MAX_LIST_SIZE
	if (last_mem_amount != -1) {
		long i, j;
		int l = 0;
		for (i = 0; i < MAX_LIST_SIZE; i++) if (memory_list[i].p && memory_list[i].p != last_memory_list[i].p) {
			for (j = 0; j < MAX_LIST_SIZE; j++) if (last_memory_list[j].p == memory_list[i].p) goto b;
			if (!l) p += sprintf(p, "\n%s", get_text("New addresses: ")), l = 1;
			else p += sprintf(p, ", ");
			p += sprintf(p, "#%p of %d at %s:%d", memory_list[i].p, (int)memory_list[i].size, memory_list[i].file, memory_list[i].line);
			if (p - message >= MSG_BUF - MSG_W) {
				p += sprintf(p, "..");
				break;
			}
			b:;
		}
		if (!l) p += sprintf(p, "\n%s", get_text("No new addresses"));
		p += sprintf(p, ".");
	}
#endif
	if (!(p = stracpy(message))) return;
	msg_box(term, getml(p, NULL), get_text("Memory info"), AL_CENTER, p, NULL, 2, get_text("OK"), NULL, B_ENTER | B_ESC, get_text("Mark"), memory_cld, 0);
}

#endif

void flush_caches(struct terminal *term, void *d, void *e)
{
	shrink_memory(1);
}

void downloads_menu(struct terminal *term, void *ddd, struct session *ses)
{
	struct download *d;
	struct menu_item *mi;
	int n = 0;
	if (!(mi = new_menu(3))) return;
	foreachback(d, downloads) {
		add_to_menu(&mi, stracpy(d->url), "", 0, MENU_FUNC display_download, d, 0);
		n++;
	}
	if (!n) add_to_menu(&mi, stracpy(get_text("No downloads")), "", M_BAR, NULL, NULL, 0);
	do_menu(term, mi, ses);
}

void menu_doc_info(struct terminal *term, void *ddd, struct session *ses)
{
	state_msg(ses);
}

void display_codepage(struct terminal *term, void *pcp, struct session *ses)
{
	int cp = (int)pcp;
	struct term_spec *t = new_term_spec(term->term);
	if (t) t->charset = cp;
	redraw_terminal_cls(term);
}

void assumed_codepage(struct terminal *term, void *pcp, struct session *ses)
{
	int cp = (int)pcp;
	ses->assume_cp = cp;
	redraw_terminal_cls(term);
}

void set_default_cp(struct terminal *term, void *xxx, struct session *ses)
{
	assume_cp = ses->assume_cp;
}

void charset_list(struct terminal *term, int disp, struct session *ses)
{
	int i, sel;
	unsigned char *n;
	struct menu_item *mi;
	if (!(mi = new_menu(1))) return;
	/*if (!disp) {
		add_to_menu(&mi, get_text("None"), "", 0, MENU_FUNC display_codepage, (void *)-1, 0);
	}*/
	for (i = 0; (n = get_cp_name(i)); i++) {
		if (disp && is_cp_special(i)) continue;
		add_to_menu(&mi, get_cp_name(i), "", 0, disp ? MENU_FUNC display_codepage : MENU_FUNC assumed_codepage, (void *)i, 0);
	}
	if (!disp) {
		add_to_menu(&mi, "", "", M_BAR, NULL, NULL, 0);
		add_to_menu(&mi, get_text("Set default"), "", 'd', MENU_FUNC set_default_cp, NULL, 0);
	}
	sel = disp ? get_term_spec(term->term)->charset : ses->assume_cp;
	if (sel < 0) sel = 0;
	do_menu_selected(term, mi, ses, sel);
}

unsigned char *td_labels[] = { "No frames", "VT 100 frames", "Linux or OS/2 frames", "Use ^[[11m", "Restrict frames in cp850/852", "Color", NULL };

void terminal_options(struct terminal *term, void *xxx, struct session *ses)
{
	struct dialog *d;
	struct term_spec *ts = new_term_spec(term->term);
	if (!ts) return;
	if (!(d = mem_alloc(sizeof(struct dialog) + 9 * sizeof(struct dialog_item)))) return;
	memset(d, 0, sizeof(struct dialog) + 9 * sizeof(struct dialog_item));
	d->title = get_text("Terminal options");
	d->fn = checkbox_list_fn;
	d->udata = td_labels;
	d->refresh = (void (*)(void *))redraw_terminal_cls;
	d->refresh_data = term;
	d->items[0].type = D_CHECKBOX;
	d->items[0].gid = 1;
	d->items[0].gnum = TERM_DUMB;
	d->items[0].dlen = sizeof(int);
	d->items[0].data = (void *)&ts->mode;
	d->items[1].type = D_CHECKBOX;
	d->items[1].gid = 1;
	d->items[1].gnum = TERM_VT100;
	d->items[1].dlen = sizeof(int);
	d->items[1].data = (void *)&ts->mode;
	d->items[2].type = D_CHECKBOX;
	d->items[2].gid = 1;
	d->items[2].gnum = TERM_LINUX;
	d->items[2].dlen = sizeof(int);
	d->items[2].data = (void *)&ts->mode;
	d->items[3].type = D_CHECKBOX;
	d->items[3].gid = 0;
	d->items[3].dlen = sizeof(int);
	d->items[3].data = (void *)&ts->m11_hack;
	d->items[4].type = D_CHECKBOX;
	d->items[4].gid = 0;
	d->items[4].dlen = sizeof(int);
	d->items[4].data = (void *)&ts->restrict_852;
	d->items[5].type = D_CHECKBOX;
	d->items[5].gid = 0;
	d->items[5].dlen = sizeof(int);
	d->items[5].data = (void *)&ts->col;
	d->items[6].type = D_BUTTON;
	d->items[6].gid = B_ENTER;
	d->items[6].fn = ok_dialog;
	d->items[6].data = get_text("OK");
	d->items[7].type = D_BUTTON;
	d->items[7].gid = B_ESC;
	d->items[7].fn = cancel_dialog;
	d->items[7].data = get_text("Cancel");
	d->items[8].type = D_END;
	do_dialog(term, d, getml(d, NULL));
}

unsigned char max_c_str[3];
unsigned char max_cth_str[2];
unsigned char max_t_str[2];
unsigned char time_str[5];
unsigned char unrtime_str[5];

void refresh_net(void *xxx)
{
	abort_all_connections();
	max_connections = atoi(max_c_str);
	max_connections_to_host = atoi(max_cth_str);
	max_tries = atoi(max_t_str);
	receive_timeout = atoi(time_str);
	unrestartable_receive_timeout = atoi(unrtime_str);
}

unsigned char *net_msg[] = {
	"HTTP proxy (host:port)",
	"FTP proxy (host:port)",
	"Max connections",
	"Max connections to one host",
	"Retries",
	"Receive timeout (sec)",
	"Timeout when unrestartable",
	"Async DNS lookup",
};

void netopt_fn(struct dialog_data *dlg)
{
	int max = 0, min = 0;
	int w, rw;
	int x, y = -1;
	max_text_width(net_msg[0], &max);
	min_text_width(net_msg[0], &min);
	max_text_width(net_msg[1], &max);
	min_text_width(net_msg[1], &min);
	max_group_width(net_msg + 2, dlg->items + 2, 6, &max);
	min_group_width(net_msg + 2, dlg->items + 2, 6, &min);
	max_buttons_width(dlg->items + 8, 2, &max);
	min_buttons_width(dlg->items + 8, 2, &min);
	w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
	if (w > max) w = max;
	if (w < min) w = min;
	if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
	if (w < 1) w = 1;
	rw = 0;
	dlg_format_text(NULL, net_msg[0], 0, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
	y += 2;
	dlg_format_text(NULL, net_msg[1], 0, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
	y += 2;
	dlg_format_group(NULL, net_msg + 2, dlg->items + 2, 6, 0, &y, w, &rw);
	y++;
	dlg_format_buttons(NULL, dlg->items + 8, 2, 0, &y, w, &rw, AL_CENTER);
	w = rw;
	dlg->xw = w + 2 * DIALOG_LB;
	dlg->yw = y + 2 * DIALOG_TB;
	center_dlg(dlg);
	draw_dlg(dlg);
	y = dlg->y + DIALOG_TB;
	dlg_format_text(dlg->win->term, net_msg[0], dlg->x + DIALOG_LB, &y, w, NULL, COLOR_DIALOG_TEXT, AL_LEFT);
	dlg_format_field(dlg->win->term, &dlg->items[0], dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
	y++;
	dlg_format_text(dlg->win->term, net_msg[1], dlg->x + DIALOG_LB, &y, w, NULL, COLOR_DIALOG_TEXT, AL_LEFT);
	dlg_format_field(dlg->win->term, &dlg->items[1], dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
	y++;
	dlg_format_group(dlg->win->term, net_msg + 2, &dlg->items[2], 6, dlg->x + DIALOG_LB, &y, w, NULL);
	y++;
	dlg_format_buttons(dlg->win->term, &dlg->items[8], 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_CENTER);
}

void net_options(struct terminal *term, void *xxx, void *yyy)
{
	struct dialog *d;
	snprint(max_c_str, 3, max_connections);
	snprint(max_cth_str, 2, max_connections_to_host);
	snprint(max_t_str, 2, max_tries);
	snprint(time_str, 5, receive_timeout);
	snprint(unrtime_str, 5, unrestartable_receive_timeout);
	if (!(d = mem_alloc(sizeof(struct dialog) + 12 * sizeof(struct dialog_item)))) return;
	memset(d, 0, sizeof(struct dialog) + 12 * sizeof(struct dialog_item));
	d->title = get_text("Network options");
	d->fn = netopt_fn;
	d->refresh = (void (*)(void *))refresh_net;
	d->items[0].type = D_FIELD;
	d->items[0].dlen = MAX_STR_LEN;
	d->items[0].data = http_proxy;
	d->items[1].type = D_FIELD;
	d->items[1].dlen = MAX_STR_LEN;
	d->items[1].data = ftp_proxy;
	d->items[2].type = D_FIELD;
	d->items[2].data = max_c_str;
	d->items[2].dlen = 3;
	d->items[2].fn = check_number;
	d->items[2].gid = 1;
	d->items[2].gnum = 16;
	d->items[3].type = D_FIELD;
	d->items[3].data = max_cth_str;
	d->items[3].dlen = 2;
	d->items[3].fn = check_number;
	d->items[3].gid = 1;
	d->items[3].gnum = 8;
	d->items[4].type = D_FIELD;
	d->items[4].data = max_t_str;
	d->items[4].dlen = 2;
	d->items[4].fn = check_number;
	d->items[4].gid = 1;
	d->items[4].gnum = 16;
	d->items[5].type = D_FIELD;
	d->items[5].data = time_str;
	d->items[5].dlen = 5;
	d->items[5].fn = check_number;
	d->items[5].gid = 1;
	d->items[5].gnum = 1800;
	d->items[6].type = D_FIELD;
	d->items[6].data = unrtime_str;
	d->items[6].dlen = 5;
	d->items[6].fn = check_number;
	d->items[6].gid = 1;
	d->items[6].gnum = 1800;
	d->items[7].type = D_CHECKBOX;
	d->items[7].data = (unsigned char *)&async_lookup;
	d->items[7].dlen = sizeof(int);
	d->items[8].type = D_BUTTON;
	d->items[8].gid = B_ENTER;
	d->items[8].fn = ok_dialog;
	d->items[8].data = get_text("OK");
	d->items[9].type = D_BUTTON;
	d->items[9].gid = B_ESC;
	d->items[9].fn = cancel_dialog;
	d->items[9].data = get_text("Cancel");
	d->items[10].type = D_END;
	do_dialog(term, d, getml(d, NULL));
}

void net_opt_ask(struct terminal *term, void *xxx, void *yyy)
{
	if (list_empty(downloads)) {
		net_options(term, xxx, yyy);
		return;
	}
	msg_box(term, NULL, get_text("Network options"), AL_CENTER, get_text("Warning: configuring network will terminate all running downloads. Do you really want to configure network?"), term, 2, get_text("Yes"), (void (*)(void *))net_options, B_ENTER, get_text("No"), NULL, B_ESC);
}

unsigned char mc_str[8];
unsigned char doc_str[4];

void cache_refresh(void *xxx)
{
	memory_cache_size = atoi(mc_str) * 1024;
	max_format_cache_entries = atoi(doc_str);
	count_format_cache();
	shrink_memory(0);
}

unsigned char *cache_texts[] = { "Memory cache size (kB)", "Number of formatted documents" };

void cache_opt(struct terminal *term, void *xxx, void *yyy)
{
	struct dialog *d;
	snprint(mc_str, 8, memory_cache_size / 1024);
	snprint(doc_str, 4, max_format_cache_entries);
	if (!(d = mem_alloc(sizeof(struct dialog) + 5 * sizeof(struct dialog_item)))) return;
	memset(d, 0, sizeof(struct dialog) + 5 * sizeof(struct dialog_item));
	d->title = get_text("Cache options");
	d->fn = group_fn;
	d->udata = cache_texts;
	d->refresh = (void (*)(void *))cache_refresh;
	d->items[0].type = D_FIELD;
	d->items[0].dlen = 8;
	d->items[0].data = mc_str;
	d->items[0].fn = check_number;
	d->items[0].gid = 0;
	d->items[0].gnum = MAXINT;
	d->items[1].type = D_FIELD;
	d->items[1].dlen = 4;
	d->items[1].data = doc_str;
	d->items[1].fn = check_number;
	d->items[1].gid = 0;
	d->items[1].gnum = 256;
	d->items[2].type = D_BUTTON;
	d->items[2].gid = B_ENTER;
	d->items[2].fn = ok_dialog;
	d->items[2].data = get_text("OK");
	d->items[3].type = D_BUTTON;
	d->items[3].gid = B_ESC;
	d->items[3].fn = cancel_dialog;
	d->items[3].data = get_text("Cancel");
	d->items[4].type = D_END;
	do_dialog(term, d, getml(d, NULL));
}

void menu_shell(struct terminal *term, void *xxx, void *yyy)
{
	unsigned char *sh;
	if (!(sh = GETSHELL)) sh = DEFAULT_SHELL;
	exec_on_terminal(term, sh, "", 1);
}

void menu_kill_background_connections(struct terminal *term, void *xxx, void *yyy)
{
	abort_background_connections();
}

struct menu_item file_menu[] = {
	"Goto URL", "g", 'g', MENU_FUNC menu_goto_url, (void *)0, 0, 0,
	"Go back", "<-", 'b', MENU_FUNC menu_go_back, (void *)0, 0, 0,
	"Reload", "Ctrl-R", 'r', MENU_FUNC menu_reload, (void *)0, 0, 0,
	"", "", M_BAR, NULL, NULL, 0, 0,
	"Save as", "", 'a', MENU_FUNC save_as, (void *)0, 0, 0,
	"Save URL as", "", 'u', MENU_FUNC menu_save_url_as, (void *)0, 0, 0,
	"", "", M_BAR, NULL, NULL, 0, 0,
	"Kill background connections", "", 'k', MENU_FUNC menu_kill_background_connections, (void *)0, 0, 0,
	"Flush all caches", "", 'f', MENU_FUNC flush_caches, (void *)0, 0, 0,
	"Resource info", "", 'i', MENU_FUNC cache_inf, (void *)0, 0, 0,
#if 0
	"Cache info", "", 'c', MENU_FUNC list_cache, (void *)0, 0, 0,
#endif
#ifdef LEAK_DEBUG
	"Memory info", "", 'm', MENU_FUNC memory_info, (void *)0, 0, 0,
#endif
	"", "", M_BAR, NULL, NULL, 0, 0,
	"OS shell", "", 'o', MENU_FUNC menu_shell, NULL, 0, 0,
	"", "", M_BAR, NULL, NULL, 0, 0,
	"Exit", "", 'E', MENU_FUNC exit_prog, (void *)0, 0, 0,
	NULL, NULL, 0, NULL, NULL, 0, 0
};

struct menu_item view_menu[] = {
	"Search", "/", 's', MENU_FUNC menu_for_frame, (void *)search_dlg, 0, 0,
	"Search back", "?", 'b', MENU_FUNC menu_for_frame, (void *)search_back_dlg, 0, 0,
	"Find next", "n", 'n', MENU_FUNC menu_for_frame, (void *)find_next, 0, 0,
	"Find previous", "N", 'p', MENU_FUNC menu_for_frame, (void *)find_next_back, 0, 0,
	"", "", M_BAR, NULL, NULL, 0, 0,
	"Toggle html/plain", "\\", 'h', MENU_FUNC menu_for_frame, (void *)toggle, 0, 0,
	"Document info", "=", 'i', MENU_FUNC menu_doc_info, NULL, 0, 0,
	"", "", M_BAR, NULL, NULL, 0, 0,
	"Assume character set", ">", 'A', MENU_FUNC charset_list, (void *)0, 1, 0,
	NULL, NULL, 0, NULL, NULL, 0, 0
};

struct menu_item help_menu[] = {
	"About", "", 'a', MENU_FUNC menu_about, (void *)0, 0, 0,
	"Keys", "", 'k', MENU_FUNC menu_keys, (void *)0, 0, 0,
	"Copying", "", 'c', MENU_FUNC menu_copying, (void *)0, 0, 0,
	NULL, NULL, 0, NULL, NULL, 0, 0
};

struct menu_item assoc_menu[] = {
	"Add", "", 'A', MENU_FUNC menu_add_ct, NULL, 0, 0,
	"Modify", ">", 'M', MENU_FUNC menu_list_assoc, menu_add_ct, 1, 0,
	"Delete", ">", 'D', MENU_FUNC menu_list_assoc, menu_del_ct, 1, 0,
	NULL, NULL, 0, NULL, NULL, 0, 0
};

struct menu_item ext_menu[] = {
	"Add", "", 'A', MENU_FUNC menu_add_ext, NULL, 0, 0,
	"Modify", ">", 'M', MENU_FUNC menu_list_ext, menu_add_ext, 1, 0,
	"Delete", ">", 'D', MENU_FUNC menu_list_ext, menu_del_ext, 1, 0,
	NULL, NULL, 0, NULL, NULL, 0, 0
};

struct menu_item setup_menu[] = {
	"Character set", ">", 'H', MENU_FUNC charset_list, (void *)1, 1, 0,
	"Terminal options", "", 'T', MENU_FUNC terminal_options, NULL, 0, 0,
	"Network options", "", 'N', MENU_FUNC net_opt_ask, NULL, 0, 0,
	"Cache", "", 'C', MENU_FUNC cache_opt, NULL, 0, 0,
	"Associations", ">", 'A', MENU_FUNC do_menu, assoc_menu, 1, 0,
	"File extensions", ">", 'E', MENU_FUNC do_menu, ext_menu, 1, 0,
	"", "", M_BAR, NULL, NULL, 0, 0,
	"Save options", "", 'S', MENU_FUNC write_config, NULL, 0, 0,
	NULL, NULL, 0, NULL, NULL, 0, 0
};

struct menu_item main_menu[] = {
	"File", "", 'F', MENU_FUNC do_menu, file_menu, 1, 1,
	"View", "", 'V', MENU_FUNC do_menu, view_menu, 1, 1,
	"Link", "", 'L', MENU_FUNC link_menu, NULL, 1, 1,
	"Downloads", "", 'D', MENU_FUNC downloads_menu, NULL, 1, 1,
	"Setup", "", 'S', MENU_FUNC do_menu, setup_menu, 1, 1,
	"Help", "", 'H', MENU_FUNC do_menu, help_menu, 1, 1,
	NULL, NULL, 0, NULL, NULL, 0, 0
};

void activate_bfu_technology(struct session *ses, int item)
{
	struct terminal *term = ses->term;
	do_mainmenu(term, main_menu, ses, item);
}

struct history goto_url_history = { 0, &goto_url_history.items, &goto_url_history.items };

void dialog_goto_url(struct session *ses)
{
	input_field(ses->term, NULL, get_text("Go to URL"), get_text("Enter URL"), get_text("OK"), get_text("Cancel"), ses, &goto_url_history, MAX_INPUT_URL_LEN, "", (void (*)(void *, unsigned char *)) goto_url, NULL);
}

void dialog_save_url(struct session *ses)
{
	input_field(ses->term, NULL, get_text("Save URL"), get_text("Enter URL"), get_text("OK"), get_text("Cancel"), ses, &goto_url_history, MAX_INPUT_URL_LEN, "", (void (*)(void *, unsigned char *)) save_url, NULL);
}

struct history file_history = { 0, &file_history.items, &file_history.items };

void query_file(struct session *ses, unsigned char *url, void (*std)(struct session *, unsigned char *), void (*cancel)(struct session *))
{
	unsigned char *file, *def;
	int dfl = 0;
	int l;
	get_filename_from_url(url, &file, &l);
	def = init_str();
	add_to_str(&def, &dfl, download_dir);
	if (*def && !dir_sep(def[strlen(def) - 1])) add_chr_to_str(&def, &dfl, '/');
	add_bytes_to_str(&def, &dfl, file, l);
	input_field(ses->term, NULL, get_text("Download"), get_text("Save to file"), get_text("OK"), get_text("Cancel"), ses, &file_history, MAX_INPUT_URL_LEN, def, (void (*)(void *, unsigned char *))std, (void (*)(void *))cancel);
	mem_free(def);
}

struct history search_history = { 0, &search_history.items, &search_history.items };

void search_back_dlg(struct session *ses, struct f_data_c *f, int a)
{
	input_field(ses->term, NULL, get_text("Search backward"), get_text("Search for text"), get_text("OK"), get_text("Cancel"), ses, &search_history, MAX_INPUT_URL_LEN, "", (void (*)(void *, unsigned char *)) search_for_back, NULL);
}

void search_dlg(struct session *ses, struct f_data_c *f, int a)
{
	input_field(ses->term, NULL, get_text("Search"), get_text("Search for text"), get_text("OK"), get_text("Cancel"), ses, &search_history, MAX_INPUT_URL_LEN, "", (void (*)(void *, unsigned char *)) search_for, NULL);
}

void free_history_lists()
{
	free_list(goto_url_history.items);
	free_list(file_history.items);
	free_list(search_history.items);
}

