/*
 setup-external.c : configuration for external plugin

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include "external.h"

static gchar *pipename;

SETUP_REC plugin_external_options[] =
{
    { SETUP_TYPE_ENTRY, &pipename, "named_pipe_name", "~/.irssi.extpipe" },

    { 0, NULL, NULL }
};

void plugin_external_get_setup(PLUGIN_REC *plugin)
{
    PLUGIN_DATA *data = plugin->data;

    data->pipename = g_strdup(pipename);
}

void plugin_external_setup_init(PLUGIN_REC *plugin)
{
    setup_read("plugin_external", plugin_external_options);
    plugin_external_get_setup(plugin);
}

void plugin_external_setup_deinit(PLUGIN_REC *plugin)
{
    setup_free(plugin_external_options);
}
