/***

ifaces.c - routine that determines whether a given interface is supported
		by IPTraf
		
Copyright (c) Gerard Paul Java 1998

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <fcntl.h>
#include <string.h>
#include <linux/if_packet.h>
#include "error.h"
#include "links.h"

#define NUM_SUPPORTED_IFACES 8

extern int daemonized;

char ifaces[NUM_SUPPORTED_IFACES][6] =
{"lo", "eth", "sl", "ppp", "ippp", "plip", "fddi", "isdn"};

/*
 * Determine if supplied interface is supported.
 */

int iface_supported(char *iface)
{
    int i;

    for (i = 0; i <= NUM_SUPPORTED_IFACES - 1; i++) {
	if (strncmp(ifaces[i], iface, strlen(ifaces[i])) == 0)
	    return 1;
    }

    return 0;
}

int iface_up(char *iface)
{
    int fd;
    int ir;
    struct ifreq ifr;

    fd = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);

    strcpy(ifr.ifr_name, iface);
    ir = ioctl(fd, SIOCGIFFLAGS, &ifr);

    close(fd);

    if ((ir != 0) || (!(ifr.ifr_flags & IFF_UP)))
	return 0;

    return 1;
}

void err_iface_unsupported(void)
{
    write_error("Specified interface not supported",
		daemonized);
}

void err_iface_down(void)
{
    write_error("Specified interface not active",
		daemonized);
}

void isdn_iface_check(int *fd, char *ifname)
{
    if (*fd == -1) {
	if (strncmp(ifname, "isdn", 4) == 0)
	    *fd = open("/dev/isdnctrl", O_RDWR);
    }
}
