%define prefix /usr

Summary:   IPTraf is a console-based network monitoring program
Name:      iptraf
Version:   2.1.1
Release:   1
Source:    ftp://ftp.cebu.mozcom.com/pub/linux/net/%{name}-%{version}.tar.gz
URL:       http://cebu.mozcom.com/riker/iptraf/
Copyright: GPL
Group:     Networking/Utilities
Buildroot: /usr/src/%{name}-%{version}-root

%description
IPTraf is a console-based network monitoring program that displays information
about IP traffic. This program can be used to determine the type of traffic on
your network, and what kind of service is the most heavily used on what
machines, among others.

%prep
%setup -q

%build
make -C src CFLAGS="$RPM_OPT_FLAGS" \
            TARGET=%{prefix}/bin \
            LOGDIR=/var/log/iptraf \
            WORKDIR=/var/iptraf

%install
rm -rf $RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT%{prefix}/bin
install -d $RPM_BUILD_ROOT%{prefix}/man/man8
#install -m755 -s src/cfconv $RPM_BUILD_ROOT%{prefix}/bin/
install -m644 Documentation/*.8 $RPM_BUILD_ROOT%{prefix}/man/man8
make -C src TARGET=$RPM_BUILD_ROOT%{prefix}/bin \
            LOGDIR=$RPM_BUILD_ROOT/var/log/iptraf \
            WORKDIR=$RPM_BUILD_ROOT/var/iptraf \
            install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc Documentation/{manual.*,*.gif} README.* COPYING CHANGES INSTALL
%{prefix}/bin/*
%attr(-,root,man) %{prefix}/man/*/*
/var/iptraf
/var/log/iptraf
