/**************************************************************************** 
** File: icmp.c
**
** Author: Mike Borella
**
** Comments: Dump ICMP  information
**
*****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "config.h"
#include "icmp.h"

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_icmp()
**
** Parse ICMP header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_icmp(u_char *bp)
{
  ICMPhdr *icmph;
  echoext *echo;

  icmph = (ICMPhdr *) bp;

  printf("----------------------------------------------------------\n");
  printf("                        ICMP Header\n");
  printf("----------------------------------------------------------\n");
  printf("Type:                   %d ", icmph->type);
  
  switch (icmph->type) 
    {
    case 0:
      printf("(echo reply)\n");
      printf("Code                    %d\n", icmph->code);
      echo = (echoext *) (bp + sizeof(ICMPhdr));
      printf("Identifier              %d\n", echo->id);
      printf("Sequence number         %d\n", echo->seqno);
      break;

    case 3:
      printf("(dest unreachable)\n");
      printf("Code:                   %d ", icmph->code);

      switch (icmph->code) 
	{
	case 0:
	  printf("(network)\n");
	  break;
	  
	case 1:
	  printf("(host)\n");
	  break;

	case 2:
	  printf("(protocol)\n");
	  break;

	case 3:
	  printf("(port)\n");
	  break;

	case 4:
	  printf("(fragment needed)\n");
	  break;

	case 5:
	  printf("(source route failed)\n");
	  break;

	case 6:
	  printf("(network unknown)\n");
	  break;

	case 7:
	  printf("(host unknown)\n");
	  break;

	case 9:
	  printf("(network prohibited)\n");
	  break;

	case 10:
	  printf("(host prohibited)\n");
	  break;

	case 11:
	  printf("(network unreachable for TOS)\n");
	  break;

	case 12:
	  printf("(host unreachable for TOS)\n");
	  break;

	case 13:
	  printf("(communication filtered)\n");
	  break;

	case 14:
	  printf("(host precedence violation)\n");
	  break;

	case 15:
	  printf("(precedence cutoff)\n");
	  break;

	default:
	  printf("(unknown code)\n");
	  break;
	} /* code */
      break;

    case 4:
      printf("(source quench)\n");
      printf("Code:                   %d ", icmph->code);
      break;

    case 5:
      printf("(redirect)\n");
      printf("Code:                   %d ", icmph->code);
      switch(icmph->code)
	{
	case 0: 
	  printf("(network)\n");
	  break;
	  
	case 1: 
	  printf("(host)\n");
	  break;
	  
	case 2: 
	  printf("(TOS and network)\n");
	  break;
	  
	case 3: 
	  printf("(TOS and host)\n");
	  break;
	}
      break;

    case 8:
      printf("(echo request)\n");
      printf("Code                    %d\n", icmph->code);
      echo = (echoext *) (bp + sizeof(ICMPhdr));
      printf("Identifier              %d\n", echo->id);
      printf("Sequence number         %d\n", echo->seqno);
      break;

    case 9:
      printf("(router advertisement)\n");
      printf("Code:                   %d ", icmph->code);
      break;
      
    case 10:
      printf("(router solicitation)\n");
      printf("Code:                   %d ", icmph->code);
      break;
      
    case 11:
      printf("(time exceeded)\n");
      printf("Code:                   %d ", icmph->code);
      break;
      
    case 12:
      printf("(parameter error)\n");
      printf("Code:                   %d ", icmph->code);
      break;
      
    case 13:
      printf("(timestamp request)\n");
      printf("Code:                   %d ", icmph->code);
      break;
      
    case 14:
      printf("(timestamp reply)\n");
      printf("Code:                   %d ", icmph->code);
      break;
      
    case 17:
      printf("(address mask request)\n");
      printf("Code:                   %d ", icmph->code);
      break;
      
    case 18:
      printf("(address mask reply)\n");
      printf("Code:                   %d ", icmph->code);
      break;

    default:
      printf("(unknown type)\n");
      printf("Code:                   %d ", icmph->code);
     break;
      
    }

  printf("Checksum:               %d\n", ntohs(icmph->csum));

  return;
  
}

