#include <ctype.h>

unsigned long
strtoul (const char *str, char **endp, unsigned int base)
{
	register unsigned char const *cp = (unsigned char *)str;
	unsigned long result = 0, value;

	if (!base) {
		if (*cp == '0') {
			cp++;
			if ((*cp == 'x' || *cp == 'X') && isxdigit(cp[1])) {
				cp++;
				base = 16;
			} else
				base = 8;
		} else
			base = 10;
	}
	while (isxdigit(*cp) && (value = isdigit(*cp) ? *cp - '0' : toupper(*cp) - 'A' + 10) < base) {
		result = result * base + value;
		cp++;
	}
	if (endp)
		*endp = (char *)cp;

	return result;
}
