/*
 conninfo.c : GMasqDialer

    Copyright (C) 1998-1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gmasqdialer.h"

static void create_entry(GtkWidget *table, gchar *title, gchar *field, gint pos)
{
    GtkWidget *label;
    GtkWidget *entry;

    label = gtk_label_new(title);
    gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, pos, pos+1);

    entry = gtk_entry_new();
    gtk_entry_set_editable(GTK_ENTRY(entry), FALSE);
    if (field != NULL)
    {
        gtk_entry_set_text(GTK_ENTRY(entry), field);
        g_free(field);
    }
    gtk_table_attach_defaults(GTK_TABLE(table), entry, 1, 2, pos, pos+1);
}

static void conninfo_dialog(gchar *name, gchar *info, gchar *script, gchar *kill, char *addrs, char *users)
{
    GtkWidget *dialog;
    GtkWidget *table;
    GtkWidget *hsep;

#ifdef HAVE_GNOME
    dialog = gnome_dialog_new(_("Connection information"), GNOME_STOCK_BUTTON_CLOSE, NULL);
    gnome_dialog_button_connect_object(GNOME_DIALOG(dialog), 0,
                                       GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));
#else
    GtkWidget *button;

    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(dialog), 5);
    gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
                       GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

    button = gtk_button_new_with_label("Close");
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                              GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));

    gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 10);
#endif
    table = gtk_table_new(2, 8, FALSE);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), table, TRUE, TRUE, 0);

    create_entry(table, _("Name:"), name, 0);
    create_entry(table, _("Information:"), info, 1);
    hsep = gtk_hseparator_new();
    gtk_table_attach(GTK_TABLE(table), hsep, 0, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);
    create_entry(table, _("Valid IP addresses:"), addrs, 3);
    create_entry(table, _("Valid users:"), users, 4);
    hsep = gtk_hseparator_new();
    gtk_table_attach(GTK_TABLE(table), hsep, 0, 2, 5, 6, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);
    create_entry(table, _("Dial script:"), script, 6);
    create_entry(table, _("Hang up script:"), kill, 7);

    gtk_widget_show_all(dialog);
}

static void callback_conninfo(CALLBACK_DATA *data)
{
    static gchar *name, *info, *script, *kill, *addrs, *users;

    if (data->status == 0) return;

    switch (data->u.list.type)
    {
        case LIST_START:
            name = info = script = kill = addrs = users = NULL;
            break;
        case LIST_END:
            conninfo_dialog(name, info, script, kill, addrs, users);
            break;
        case LIST_ITEM:
            if (strncmp(data->u.list.data, "NAME: ", 6) == 0)
                name = g_strdup(data->u.list.data+6);
            else if (strncmp(data->u.list.data, "INFO: ", 6) == 0)
                info = g_strdup(data->u.list.data+6);
            else if (strncmp(data->u.list.data, "SCRIPT: ", 8) == 0)
                script = g_strdup(data->u.list.data+8);
            else if (strncmp(data->u.list.data, "KILL: ", 6) == 0)
                kill = g_strdup(data->u.list.data+6);
            else if (strncmp(data->u.list.data, "VALID ADDRESSES: ", 17) == 0)
                addrs = g_strdup(data->u.list.data+17);
            else if (strncmp(data->u.list.data, "VALID USERS: ", 13) == 0)
                users = g_strdup(data->u.list.data+13);
            break;
    }
}

void menu_conninfo(void)
{
    GtkObject *object;

    if (!mserver_connected()) return;

    if (GTK_LIST(GTK_COMBO(combo)->list)->selection == NULL)
    {
        masqerror(_("You haven't selected any connection"));
        return;
    }

    object = GTK_OBJECT(GTK_LIST(GTK_COMBO(combo)->list)->selection->data);
    mserver_connectinfo(gtk_object_get_data(object, "name"), callback_conninfo);
}
