#include "libipfwc.h"
#include <netdb.h>

#include "config.h"

struct _fwchain {
	ip_chainlabel label;
	ip_chainlabel policy;
	guint refcnt;
	__u32 pkthi, pktlo, bytehi, bytelo;

	GtkWidget *rulelist;
	GtkWidget *hbox, *interface_desc;
	GtkWidget *tablabel;
	gint deleted;
};

struct _fwrule {
	ip_chainlabel label;
	ip_chainlabel target;
	struct ip_fw ipfw;
};

struct _fwentry {
	GtkWidget *label;
	GtkWidget *invsrc, *src, *invdst, *dst;
	GtkWidget *invvia, *via;
	GtkWidget *fw_flg, *fw_invflg;
	GtkWidget *invproto;
	gchar     proto[16];
	GtkWidget *invspts, *spts[2];
	GtkWidget *invdpts, *dpts[2];
	gchar tosxor[64];
	GtkWidget *redirpt;
	gchar target[16];
	GtkWidget *log;
	GtkWidget *invsyn, *syn;
	GtkWidget *invfragment, *fragment;
	GtkWidget *fw_mark, *fw_mark_val;
	GtkWidget *fw_netlink, *fw_outputsize;

	gint action;
};

struct _menu {
	guint value;
	gchar *label;
	struct _menu *next;
};

#define NUMCOLS 19
#define MAXCHAINS 20

typedef enum {
	FILE_OPEN,
	FILE_SAVE,
	FILE_SAVE_AS,
	FILE_EXPORT
} FileAction;

typedef enum {
	NEW,
	EDIT,
	INSERT
} RuleAction;

typedef enum {
	PORTSMIN,
	PORTSMAX,
	PORTDMIN,
	PORTDMAX
} PortIdx;

#define IP_FW_LABEL_NONE "NONE"
#ifndef GFCC_HOME
#define GFCC_HOME "/usr/local/share/gfcc"
#endif

/* chain.c */
void edit_chain_window(GtkWidget *, RuleAction);
void delete_chain(GtkWidget *, gchar *);

/* file.c */
void get_fw_data(gchar *, gint);
void draw_chain(GtkWidget *, gint);
void set_zero_entries(GtkWidget *, gpointer);
void load_from_file(GtkWidget *, gpointer);
void load_from_system(GtkWidget *, gpointer);
void save_to_file(void);
void export_to_file(void);
void save_as_to_file(void);
void get_service_name();
void get_proto_name();
void export_fw_data(GtkWidget *, gchar *);
void save_fw_data(GtkWidget *, gchar *);
void inverse_mark(GtkCList *, gint, __u16);

/* firewall.c */
void check_input_value(GtkWidget *, struct _fwentry *);
void conv_fw_data(struct ip_fwuser *, ip_chainlabel, GtkCList *, gint);
gint append_entry(gchar *, gchar *, struct ip_fwuser);
gint dialog_append_entry(gchar *, gchar *, struct ip_fwuser);
gint flush_entries(const ip_chainlabel);
gint zero_entries(const ip_chainlabel);
gint delete_user_chain(const ip_chainlabel);
gint clear_system();
void dialog_clear_system();

/* host.c */
void get_host_name();
void call_select_host_window(GtkWidget *, GtkWidget *);
void select_host_window(GtkWidget *, GtkWidget *);
int  host_iptoname(gchar *, gchar *);
gint host_nametoip(gchar *, gchar *);
gint check_host(gchar *);
void save_host_name(GtkWidget *, gchar *);
void write_host_data(FILE *);

/* window.c */
void popup_rule_edit(GtkWidget *widget, RuleAction);
void popup_rule_copy(GtkWidget *widget, gchar *);
void popup_rule_cut(GtkWidget *widget, gchar *);
void popup_rule_paste(GtkWidget *widget, gchar *);
void popup_rule_delete(GtkWidget *widget, gpointer);
void popup_rule_duplicate(GtkWidget *widget, gpointer);

/* masq.c */
void masq_list(GtkWidget *, gpointer);
void get_masq_timeout(FILE *);
gint set_masq_timeout(GtkWidget *, gpointer);
gint save_masq_timeout(FILE *fp);

/* misc.c */
void button_cancel(GtkWidget *, gchar *);
void proto_itos(gchar *, guint);
guint proto_stoi(gchar *);
void port_itos(gchar *, guint, gchar *);
guint port_stoi(gchar *);
void get_port(gchar *, guint, guint, gchar *);
void program_quit(GtkWidget *, GtkWidget *, gpointer);
void force_quit(GtkWidget *, gpointer);
int  get_ipaddr(gchar *, __u32, __u32);
void  get_only_ipaddr(gchar *, __u32, __u32);
gchar *content_new(gchar *);
long int_from_hex(gchar *);
__u8 tosxor_stoi(gchar *);
void tosxor_itos(gchar *, __u8);
void dot_to_underbar(char *, char *);

/* gtkutil.c */
GtkWidget *gfcc_toggle_new(GtkWidget *, GtkSignalFunc, gpointer);
void menu_separator(GtkWidget *);
void dialog_window(gchar *message, GtkSignalFunc);
GtkWidget *gfcc_pixmap_button_new(GtkWidget *, gchar **,
			gint, gint, GtkSignalFunc, gpointer);
GtkWidget *new_pixmap(GtkWidget *w, gchar **data);
GtkWidget * append_submenu_item(GtkWidget *, GtkSignalFunc , gchar *);
GtkWidget *create_menu_item(GtkWidget *,gchar *,gint,GtkSignalFunc,gpointer);
GtkWidget *gfcc_entry_new(GtkWidget *, gint, gint, gint, gchar *);
GtkWidget *gfcc_label_new(GtkWidget *, gchar *);
