#ifndef DAEMON_BUFFER_H
#define DAEMON_BUFFER_H

#include "global.h"

ssize_t buf_read(int fd, char *buf, size_t count);
ssize_t buf_repeat_read(int fd, char *buf, size_t count);

ssize_t buf_write(int fd, char *buf, size_t count);
ssize_t buf_repeat_write(int fd, char *buf, size_t count);

size_t buf_fread(char *ptr, size_t size, size_t nmemb, FILE *stream);

size_t buf_fwrite(char *ptr, size_t size, size_t nmemb, FILE *stream);
size_t buf_repeat_fwrite(char *ptr, size_t nmemb, FILE *stream);

int buf_hasline(char *buf, int buf_size);
int buf_getline(char *buf, size_t buf_size, char *line, size_t line_size);

#endif
