/* Gnome Darxite Control
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

#include "global.h"
#include "main.h"
#include "preferences.h"
#include "../common/prefs-dnd.h"
#include "../common/prefs-appearance.h"
#include "../common/prefs-daemon.h"

PropertyUI prefs_ui = { NULL };

GtkWidget *cb_read; //for the history_tab

void control_preferences(PropertyUI *pui);
static int close_preferences(GtkWidget * widget, PropertyUI *pui);
static void apply_changes_cb(GnomePropertyBox *pbox, gint page, PropertyUI *pui);
static void properties_modified_cb(GtkWidget *w, GnomePropertyBox *pbox);
GtkWidget * history_tab_make(GnomePropertyBox *pbox);
void history_tab_apply_changes();

/*-----------------------------------------------------------------------------*/

static void
properties_modified_cb(GtkWidget *w, GnomePropertyBox *pbox)
{
        gnome_property_box_changed(pbox);
}

void
prefs_cb(GtkWidget *w)
{
        if(prefs_ui.pbox == NULL)
                control_preferences(&prefs_ui);
	else
		gdk_window_raise(GTK_WIDGET(prefs_ui.pbox)->window);
}


//void
//set_toggle(GtkWidget * widget, gint data)
//{
///*FIXME: REMAKE THE WAY THIS WORKS!*/
//}

void
control_preferences(PropertyUI *pui)
{
	GnomeApp *active_win;

	/*Create the preferences box and bind some signals*/
        pui->pbox = (GnomePropertyBox *)gnome_property_box_new();

	active_win = GNOME_APP(gnome_mdi_get_active_window(mdi));
	gnome_dialog_set_parent(GNOME_DIALOG(pui->pbox), GTK_WINDOW(active_win));

        gtk_signal_connect(GTK_OBJECT(pui->pbox), "apply",
           	  	   GTK_SIGNAL_FUNC(apply_changes_cb), pui);
        gtk_signal_connect(GTK_OBJECT(pui->pbox), "delete_event",
           	  	   GTK_SIGNAL_FUNC(close_preferences), pui);
        gtk_signal_connect(GTK_OBJECT(pui->pbox), "destroy",
           	  	   GTK_SIGNAL_FUNC(close_preferences), pui);

        gtk_window_set_title (GTK_WINDOW (pui->pbox),
           		      _("Gnome Darxite Control properties"));
                          
/*-------------------------------------------------------------------*/

	pui->dnd_tab = dnd_tab_make(GNOME_PROPERTY_BOX(pui->pbox));
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pui->pbox),
			pui->dnd_tab, gtk_label_new(_("DnD Behaviour")));

	pui->appearance_tab = appearance_tab_make(GNOME_PROPERTY_BOX(pui->pbox),
		&mdi_mode, &toolbar_mode);
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pui->pbox),
			pui->appearance_tab, gtk_label_new(_("Appearance")));

	pui->history_tab = history_tab_make(GNOME_PROPERTY_BOX(pui->pbox));
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pui->pbox),
			pui->history_tab, gtk_label_new(_("History")));

	pui->daemon_tab = daemon_tab_make(GNOME_PROPERTY_BOX(pui->pbox));
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pui->pbox),
			pui->daemon_tab, gtk_label_new(_("Daemon")));


	gtk_widget_show(GTK_WIDGET(pui->pbox));
}


static void
apply_changes_cb(GnomePropertyBox *pbox, gint page, PropertyUI *pui)
{
        if ( page != -1 ) return; /* Only do something on global apply */
        
	appearance_tab_apply_changes(mdi, &mdi_mode,
			 control->toolbar, &toolbar_mode);
	history_tab_apply_changes();
	daemon_tab_apply_changes();
	dnd_tab_apply_changes();
}

/*-----------------------------------------------------------*/
static int
close_preferences(GtkWidget * widget, PropertyUI *pui)
{
   	pui->pbox = NULL;
   	return FALSE;
}
/*-----------------------------------------------------------*/


GtkWidget *
history_tab_make(GnomePropertyBox *pbox)
{
	GtkWidget *vbox;
	GtkWidget *vbox2;
	GtkWidget *frame;
	
	vbox = gtk_vbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), GNOME_PAD_SMALL);
        gtk_widget_show(vbox);

	/*Startup*/
	frame = gtk_frame_new(_("Startup"));
        gtk_container_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
        gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 2);  
        gtk_widget_show(frame);

        vbox2 = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(frame), vbox2);
        gtk_widget_show(vbox2);

	cb_read = gtk_check_button_new_with_label(
			_("Read history file at startup"));
	gtk_box_pack_start(GTK_BOX(vbox2), GTK_WIDGET(cb_read), FALSE, TRUE, 2);
	gtk_widget_show(cb_read);
	
//Set preferences:

	if (history_read)
	   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_read), TRUE);

	gtk_signal_connect(GTK_OBJECT(cb_read), "clicked",
					properties_modified_cb, pbox);
	return vbox;
}

void history_tab_apply_changes()
{
	if (GTK_TOGGLE_BUTTON(cb_read)->active)
	   history_read = TRUE;
	else
	   history_read = FALSE;
}
