/* Gnome Darxite Control
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

#include "global.h"
#include "control-page.h"
#include "batch-status.h"
#include "file-log.h"
//FIXME: This is for pixmap stuff!! change/remove!
#include "../common/callbacks.h"

static void       control_page_class_init          (ControlPageClass *);
static void       control_page_init                (ControlPage *);
static GtkWidget *control_page_create_view         (GnomeMDIChild *);
static gchar     *control_page_get_config_string   (GnomeMDIChild *);
static void       control_page_destroy             (GtkObject *);


GnomeUIInfo batch_actions_menu[]= {
  GNOMEUIINFO_ITEM_STOCK(N_("Play File"),
     N_("Start/Continue download of selected file(s)"),
     play_cb, GNOME_STOCK_MENU_FORWARD),
  GNOMEUIINFO_ITEM_STOCK(N_("Pause File"), 
     N_("Pause download of selected file(s)"),
     pause_cb, GNOME_STOCK_MENU_PAUSE),
  GNOMEUIINFO_ITEM_STOCK(N_("Cancel File"),
     N_("Cancel download of selected file(s)"),
     cancel_cb, GNOME_STOCK_MENU_STOP),
  GNOMEUIINFO_SEPARATOR,
  { 
    GNOME_APP_UI_ITEM,
    N_("Get the file Again"), N_("Get the file from the begining"),
    reget_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH,
    0, (GdkModifierType)0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  { 
    GNOME_APP_UI_ITEM,
    N_("Clear List"), N_("Clean Up Cancelled/Failed/Completed files"),
    clear_list_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLEAR,
    0, (GdkModifierType)0, NULL
  },
  GNOMEUIINFO_END
};

GnomeUIInfo filelog_actions_menu[]= {
  {
    GNOME_APP_UI_ITEM,
    N_("Get the file Again"), N_("Get the file from the begining"),
    reget_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH,
    0, (GdkModifierType)0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK (N_ ("Clear Log File"), NULL, clear_log_cb,
	GNOME_STOCK_MENU_TRASH),
  GNOMEUIINFO_END
};

GnomeUIInfo batch_menu[] = {
	GNOMEUIINFO_SUBTREE(N_("Commands"), batch_actions_menu),
	GNOMEUIINFO_END
};

GnomeUIInfo filelog_menu[] = {
	GNOMEUIINFO_SUBTREE(N_("Commands"), filelog_actions_menu),
	GNOMEUIINFO_END
};

enum {
        LAST_SIGNAL
};

static gint control_page_signals [LAST_SIGNAL];


/****************************************************************/

typedef void (*ControlPageSignal) (GtkObject *, gpointer, gpointer);

static GnomeMDIChildClass *parent_class = NULL;

/*
static void 
control_page_marshal (GtkObject            *object,
                   GtkSignalFunc        func,
                   gpointer             func_data,
                   GtkArg               *args)
{
        ControlPageSignal rfunc;
        
        rfunc = (ControlPageSignal) func;
        
        (* rfunc)(object, GTK_VALUE_POINTER(args[0]), func_data);
}
*/

guint
control_page_get_type ()
{
        static guint doc_type = 0;

        if (!doc_type) {
                GtkTypeInfo doc_info = {
                        "ControlPage",
                        sizeof (ControlPage),
                        sizeof (ControlPageClass),
                        (GtkClassInitFunc) control_page_class_init,
                        (GtkObjectInitFunc) control_page_init,
                        (GtkArgSetFunc) NULL,
                        (GtkArgGetFunc) NULL,
                        (GtkClassInitFunc) NULL,
                };
    
                doc_type = gtk_type_unique(gnome_mdi_child_get_type (), &doc_info);
        }
        return doc_type;
}

static GtkWidget *
control_page_create_view (GnomeMDIChild *child)
{
        GtkWidget *new_view = NULL;

        switch (CONTROL_PAGE (child)->type) {
        case CONTROL_PAGE_BATCH:
                new_view = control_batch_new (CONTROL_PAGE (child));
                break;
        case CONTROL_PAGE_FILELOG:
                new_view = control_filelog_new (CONTROL_PAGE (child));
                break;
        }

        return new_view;
}

static GtkWidget *
control_page_set_label (GnomeMDIChild *child)
{
        GtkWidget *hbox, *pixmap, *label;

	label = NULL; /*Just to avoid warnings*/
	pixmap = NULL; /*Just to avoid warnings*/
        hbox = gtk_hbox_new(FALSE, 0);
	switch (CONTROL_PAGE (child)->type) {
        case CONTROL_PAGE_BATCH:
	        label = gtk_label_new(child->name);
	        pixmap = gnome_stock_new_with_icon(GNOME_STOCK_MENU_EXEC);
                break;
        case CONTROL_PAGE_FILELOG:
	        label = gtk_label_new(child->name);
                pixmap = gnome_stock_new_with_icon(GNOME_STOCK_MENU_BOOK_OPEN);
                break;
        }
        gtk_widget_show(label);
        gtk_widget_show(pixmap);
        gtk_box_pack_start(GTK_BOX(hbox), pixmap, FALSE, FALSE, 2);
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
        return hbox;
}

static gchar *
control_page_get_config_string (GnomeMDIChild *child)
{
        ControlPage *page;

        g_return_val_if_fail (child != NULL, NULL);
        g_return_val_if_fail (IS_CONTROL_PAGE (child), NULL);

        page = CONTROL_PAGE (child);

        return g_strdup_printf ("%d", page->type);
}

static void
control_page_destroy (GtkObject *obj)
{
        ControlPage *page;
        
        page = CONTROL_PAGE (obj);

        if (GTK_OBJECT_CLASS (parent_class)->destroy)
                (* GTK_OBJECT_CLASS (parent_class)->destroy)
                        (GTK_OBJECT (page));
}

static void
control_page_class_init (ControlPageClass *class)
{
        GtkObjectClass *object_class;
        GnomeMDIChildClass *child_class;

        object_class = (GtkObjectClass*) class;
        child_class = GNOME_MDI_CHILD_CLASS (class);

        gtk_object_class_add_signals
                (object_class, control_page_signals, LAST_SIGNAL);

        object_class->destroy = control_page_destroy;

        child_class->create_view = (GnomeMDIChildViewCreator)
                control_page_create_view;

        child_class->get_config_string = (GnomeMDIChildConfigFunc)
                control_page_get_config_string;

	child_class->set_label = (GnomeMDIChildLabelFunc)
		control_page_set_label;
        parent_class = gtk_type_class (gnome_mdi_child_get_type ());
}

static void
control_page_init (ControlPage *page)
{
	/*Here should go common things...*/
}


ControlPage *
control_page_new (ControlPageType type)
{
        ControlPage *page = gtk_type_new (control_page_get_type ());

        page->type = type;

        switch (page->type) {
        case CONTROL_PAGE_BATCH:
                gnome_mdi_child_set_name
			(GNOME_MDI_CHILD (page), "Batch Status");
        	gnome_mdi_child_set_menu_template
         	       (GNOME_MDI_CHILD (page), batch_menu);
                break;
        case CONTROL_PAGE_FILELOG:
                gnome_mdi_child_set_name
			(GNOME_MDI_CHILD (page), "History");
        	gnome_mdi_child_set_menu_template
         	       (GNOME_MDI_CHILD (page), filelog_menu);
                break;
        }

        return page;
}

GnomeMDIChild *
control_page_create_from_config (const gchar *string)
{
        gint type;

        g_return_val_if_fail (string != NULL, NULL);

        if (sscanf (string, "%d", &type) != 1)
                return NULL;

        return GNOME_MDI_CHILD (control_page_new (type));
}


void remove_child_cb(GtkWidget *w)
{
        /* mdi->active_child holds the pointer to the child that this action
           applies to
        */
	if(mdi->active_view)
	   gnome_mdi_remove_child(mdi,
	       gnome_mdi_get_child_from_view(mdi->active_view), FALSE);
}

/*******************************************************************************/

void 
play_cb(void)
{
	GtkWidget *clist;
   	GList *selected;
        gint row_number;
        char buffer[2048];
	FileInfo *pointer;
	
	if (mdi->active_child == NULL)
		return;

	if (CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_BATCH)
	{
	
	clist = CONTROL_PAGE(mdi->active_child)->main_widget;
   	selected = GTK_CLIST(clist)->selection;

	if (selected == NULL)
	{
		gnome_app_flash(mdi->active_window, "First you must select one or more files!");
	}
	else
	while (selected)
	{
        row_number = (int)selected->data;
	pointer = (FileInfo *) gtk_clist_get_row_data(GTK_CLIST(clist), row_number);

	if (!((pointer->type == CANCELATION)
	    ||(pointer->type == COMPLETION)))
	   {
	   sprintf(buffer, "Continue %s\n", pointer->url);
	   write(fd, buffer, strlen(buffer));

#ifdef DEBUG_MESSAGES
	   g_print("%s", buffer);
#endif
	   }
	selected = selected->next;
	}
	}
}

void 
pause_cb(void)
{
	GtkWidget *clist;
   	GList *selected;
        gint row_number;
        char buffer[2048];
	FileInfo *pointer;

	if (mdi->active_child == NULL)
		return;

	if (CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_BATCH)
	{
	clist = CONTROL_PAGE(mdi->active_child)->main_widget;
   	selected = GTK_CLIST(clist)->selection;

	if (selected == NULL)
	{
		gnome_app_flash(mdi->active_window, "First you must select one or more files!");
	}
	else
	while (selected)
	{
        row_number = (int)selected->data;
	pointer = (FileInfo *) gtk_clist_get_row_data(GTK_CLIST(clist), row_number);

	if (!( (strcmp(pointer->activity, "File complete") == 0)
	   ||(strcmp(pointer->activity, "File cancelled") == 0)
	   ||(strcmp(pointer->activity, "Paused") == 0) ) )
	   {
	   sprintf(buffer, "Pause %s\n", pointer->url);
           write(fd, buffer, strlen(buffer));

	   #ifdef DEBUG_MESSAGES
	   g_print("%s", buffer);
	   #endif
	   }

	selected = selected->next;
	}
	}
}

void 
cancel_cb(void)
{
	GtkWidget *clist;
   	GList *selected;
        gint row_number;
        char buffer[2048];
	FileInfo *pointer;

	if (mdi->active_child == NULL)
		return;

	if (CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_BATCH)
	{
	clist = CONTROL_PAGE(mdi->active_child)->main_widget;
   	selected = GTK_CLIST(clist)->selection;

	if (selected == NULL)
	{
		gnome_app_flash(mdi->active_window, "First you must select one or more files!");
	}
	else
	while (selected)
	{
        row_number = (int)selected->data;
	pointer = (FileInfo *) gtk_clist_get_row_data(GTK_CLIST(clist), row_number);

	if ( (!strcmp(pointer->activity, "File complete") == 0)
	   ||(!strcmp(pointer->activity, "File cancelled") == 0) )
	   {
	   sprintf(buffer, "Cancel %s\n", pointer->url);
	   write(fd, buffer, strlen(buffer));

	   #ifdef DEBUG_MESSAGES
	   g_print("%s", buffer);
	   #endif
	   }

	selected = selected->next;
	}
	}
}

void
reget_cb(void)
{
	GtkWidget *clist;
   	GList *selected;
        gint row_number;
        char buffer[2048];
	FileInfo *pointer;

	if (mdi->active_child == NULL)
		return;

	if ( (CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_BATCH)
	   ||(CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_FILELOG))
	{
	clist = CONTROL_PAGE(mdi->active_child)->main_widget;
   	selected = GTK_CLIST(clist)->selection;

	if (selected == NULL)
	{
		gnome_app_flash(mdi->active_window, "First you must select one or more files!");
	}
	else
	while (selected)
	{
        row_number = (int)selected->data;
	pointer = (FileInfo *) gtk_clist_get_row_data(GTK_CLIST(clist), row_number);

/*FIXME: comprobar si existe: SI-> preguntar, NO-> Get ... */

	sprintf(buffer, "Reget %s | %s | | | \n", pointer->url, pointer->local_path);
	write(fd, buffer, strlen(buffer));

	#ifdef DEBUG_MESSAGES
	g_print("%s", buffer);
	#endif

	selected = selected->next;
	}
	}
}

//This func. will delete all completions from the list
void
clear_list_cb(void)
{
	GtkWidget *clist;

	if (mdi->active_child == NULL)
		return;

	if (CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_BATCH)
	{
	   clist = CONTROL_PAGE(mdi->active_child)->main_widget;

	   gtk_clist_freeze(GTK_CLIST(clist));
	   {
	      FileInfo *download;
	      gint row;
		
	      completions = g_list_first(completions);
	      while (completions)
	      {
	         download = completions->data;
	         completions = g_list_remove(completions, download);
	         row = gtk_clist_find_row_from_data(GTK_CLIST(clist), download);
	         gtk_clist_remove(GTK_CLIST(clist), row);
	         free_FileInfo(download);  
	      }
	   }
	   gtk_clist_thaw(GTK_CLIST(clist));
	}
}

/* pause / continue / cancell ALL */



void clear_log_cb(void)
{
	GtkWidget *dialog;
	gchar *message;
	gint reply;
	
	message = g_strdup_printf("Procede to delete log file?\n(%s)", DX_FileLogName);
	dialog = gnome_ok_cancel_dialog (message, NULL, NULL);
	reply = gnome_dialog_run(GNOME_DIALOG(dialog));
	if (reply == 0)
	{
	   GtkWidget *clist;
		
#ifdef DEBUG_MESSAGES
	   g_print("FIXME: Use Library function to delete the log file\n");
#endif
	   if (flogs)
	   {
	      clist = GTK_WIDGET(flogs->data);
	      if (clist)
		if (!(GTK_CLIST(clist)->rows))
			return;
	   }
	   
	   if (remove(DX_FileLogName) == -1)
	      show_warning("Error deleting Log File.");
#ifdef DEBUG_MESSAGES
	   else
	      g_print("File %s deleted.\n", DX_FileLogName);
#endif

	   if (flogs)
	   {
	      clist = GTK_WIDGET(flogs->data);
	      if (clist)
	      {
//	         gtk_clist_freeze(GTK_CLIST(clist));
	         {
	            FileInfo *download;
	            gint row;

		    for (row = 0; row < GTK_CLIST(clist)->rows; row++)
	            {
	               download = gtk_clist_get_row_data(GTK_CLIST(clist), row);
//	               free_FileInfo(download);
	g_free(download->id);
	g_free(download->filename);
	g_free(download->local_path);
	g_free(download->activity);
	g_free(download->percent_str);
	g_free(download->url);
	
	g_free(download);
	            }
	            gtk_clist_clear(GTK_CLIST(clist));
	         }
//	         gtk_clist_thaw(GTK_CLIST(clist));
	      }
	   }
	}
#ifdef DEBUG_MESSAGES
	else
		g_print("File Log deletion was cancelled!\n");
#endif
}

void free_FileInfo(FileInfo *fi)
{
	g_free(fi->id);
	g_free(fi->filename);
	g_free(fi->local_path);
	g_free(fi->activity);
	g_free(fi->percent_str);
//	g_free(fi->current_size_str);
//	g_free(fi->total_size_str);
//	g_free(fi->current_time_str);
//	g_free(fi->total_time_str);
//	g_free(fi->rate_overall_str);
	g_free(fi->url);
	
	g_free(fi);
}

gchar *
bytes_to_string(gint value)
{
	gchar *buffer;
	
        if (value > -1)
        {
           if (value > 10 * 1024 * 1024)
           {
              buffer = g_strdup_printf("%.1f MB", (float)value / (1024.0 * 1024.0));
           }
           else if (value > 10 * 1024)
           {
              buffer = g_strdup_printf("%d K", value / 1024);
           }
           else
	   {
	      buffer = g_strdup_printf("%d b.", value);
           }
        }
	else
           buffer = g_strdup("???");

	return buffer;
}

gchar *
bytesXs_to_string(gint value)
{
	gchar *buffer;

	if (value > 1024)
	{
	   buffer = g_strdup_printf("%.1f K/s", (float)value / 1024.0);
	}
	else
	{
	   buffer = g_strdup_printf("%d b/s", value);
        }

	return buffer;
}

gchar *
seconds_to_string(gint value)
{
	gchar *buffer;

	if (value < 60)
	{
	   buffer = g_strdup_printf("%d s.", value);
        }
	else if ( value < ((60 * 60) - 1))
	{
	   div_t result;
	   
	   result = div(value, 60);
	   buffer = g_strdup_printf("%i m. %i s.", result.quot, result.rem);
	}
	else
	{
	   div_t result, result2;
	   
	   result = div(value, 60);
	   result2 = div(result.rem, 60);

	   buffer = g_strdup_printf("%i h. %i m. %i s.",
	   				result.quot, result2.quot, result2.rem);
	}

	return buffer;
}

void put_color(GtkWidget *clist, gint row, gint type)
{
//FIXME: Colors should be configurable
	switch (type)
	{
	   case NORMAL:
	   	gtk_clist_set_background ((GtkCList *)clist, row, &White);
		break;
	   case ERROR:
	        gtk_clist_set_background ((GtkCList *)clist, row, &Red);
		break;
	   case CANCELATION:
	        gtk_clist_set_background ((GtkCList *)clist, row, &Brown);
		break;
	   case COMPLETION:
	        gtk_clist_set_background ((GtkCList *)clist, row, &Green);
		break;
	   case IGNORE:
	        break;
	}
}