/*  NCatalog , the GTKtalog ncurses GUI.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "console_search.h"
#include "data.h"
#include "test.priv.h"
#include "browser.h"
#include "search.h"
#include <ctype.h>
#include <term.h>
#include <string.h>


extern int hauteur;
extern int largeur;
char name[100];
char desc[100];
char info[100];
int selected;
int cat_decalage;
int cat_selected;

int set_filename(WINDOW *pad)
{
  int key;
  int i;

  if(strlen(name) == 0)
    {
     mvwaddch(pad,3,11,' ');  
    }
  else
    {
      mvwaddch(pad,3,11+strlen(name),name[strlen(name) -1]);
    }
  prefresh(pad,3,0,(hauteur/2)-2,(largeur/2)-35,(hauteur/2)-2,(largeur/2)-35+47);
  
  noecho();
  while(1)
    { 
      noecho();
      key = getch();
  
      if((key > '!')&&(key < '~'))
	{
	  name[strlen(name) +1] = '\0';
	  name[strlen(name)] = key;
	  mvwaddstr(pad,3,12,name);
	  prefresh(pad,3,0,(hauteur/2)-2,(largeur/2)-35,(hauteur/2)-2,(largeur/2)-35+47);
	}
      else if((key == KEY_BACKSPACE)&&(strlen(name) > 0))
	{
	  prefresh(pad,4,0,(hauteur/2)-2,(largeur/2)-35+11,(hauteur/2)-2,(largeur/2)-35+47);
	  name[strlen(name) -1] = '\0';
	  for(i=0;i<200;i++)mvwaddch(pad,3,11+i,' '); 
	  mvwaddstr(pad,3,12,name);
	  prefresh(pad,3,0,(hauteur/2)-2,(largeur/2)-35,(hauteur/2)-2,(largeur/2)-35+47);
	  
	}
      else if(key == '\n') return(2);
      //le 9 correspond a la touche TAB
      else if(key == 9) return(1);
      else if((key == 27)||(key == KEY_F(10))) return(0); 
    }
}



int set_description(WINDOW *pad)
{
  int key;
  int i;

  if(strlen(desc) == 0)
    {
     mvwaddch(pad,5,14,' ');  
    }
  else
    {
      mvwaddch(pad,5,14+strlen(desc),desc[strlen(desc) -1]);
    }
  prefresh(pad,5,0,hauteur/2,(largeur/2)-35,hauteur/2,(largeur/2)-35+47);
  
  noecho();
  while(1)
    { 
      noecho();
      key = getch();
  
      if((key > '!')&&(key < '~'))
	{
	  desc[strlen(desc) +1] = '\0';
	  desc[strlen(desc)] = key;
	  mvwaddstr(pad,5,15,desc);
	  prefresh(pad,5,0,hauteur/2,(largeur/2)-35,hauteur/2,(largeur/2)-35+47);
	}
      else if((key == KEY_BACKSPACE)&&(strlen(desc) > 0))
	{
	  prefresh(pad,6,0,hauteur/2,(largeur/2)-35,hauteur/2,(largeur/2)-35+47);
	  desc[strlen(desc) -1] = '\0';
	  for(i=0;i<200;i++)mvwaddch(pad,5,15+i,' '); 
	  mvwaddstr(pad,5,15,desc);
	  prefresh(pad,5,0,hauteur/2,(largeur/2)-35,hauteur/2,(largeur/2)-35+47);
	  
	}
      else if(key == '\n') return(2);
      //le 9 correspond a la touche TAB
      else if(key == 9) return(1);
      else if((key == 27)||(key == KEY_F(10))) return(0); 
    }
}



int set_information(WINDOW *pad)
{
  int key;
  int i;

  if(strlen(info) == 0)
    {
     mvwaddch(pad,7,14,' ');  
    }
  else
    {
      mvwaddch(pad,7,14+strlen(info),info[strlen(info) -1]);
    }
  prefresh(pad,7,0,hauteur/2 +2,(largeur/2)-35,hauteur/2 +2,(largeur/2)-35+47);
  
  noecho();
  while(1)
    { 
      noecho();
      key = getch();
  
      if((key > '!')&&(key < '~'))
	{
	  info[strlen(info) +1] = '\0';
	  info[strlen(info)] = key;
	  mvwaddstr(pad,7,15,info);
	  prefresh(pad,7,0,hauteur/2 +2,(largeur/2)-35,hauteur/2 +2,(largeur/2)-35+47);
	}
      else if((key == KEY_BACKSPACE)&&(strlen(info) > 0))
	{
	  prefresh(pad,8,0,hauteur/2 +2,(largeur/2)-35,hauteur/2 +2,(largeur/2)-35+47);
	  info[strlen(info) -1] = '\0';
	  for(i=0;i<200;i++)mvwaddch(pad,7,15+i,' '); 
	  mvwaddstr(pad,7,15,info);
	  prefresh(pad,7,0,hauteur/2 +2,(largeur/2)-35,hauteur/2 +2,(largeur/2)-35+47);
	  
	}
      else if(key == '\n') return(2);
      //le 9 correspond a la touche TAB
      else if(key == 9) return(1);
      else if((key == 27)||(key == KEY_F(10))) return(0);
    }
}


int set_categorie(WINDOW *pad, int begin)
{
  int i;
  int key;
  char data[21];
  char blanck[]="                  ";

  FILE *file;
 if(begin != 1) file = fopen("pouet","w");

while(1)
  {
    for(i=0;i<5;i++)
      {
	mvwaddstr(pad,i+1,1,blanck);
	if(i+cat_decalage == 0)mvwaddstr(pad,1,1,"ALL categories");
	else if ((i+cat_decalage -1) < nb_categories) mvwaddstr(pad,i+1,1,mycopy(data,categories[i+cat_decalage -1],18));
	else mvwaddstr(pad,i+1,1,blanck);
      }
    prefresh(pad,0,0,(hauteur/2)-3,(largeur/2)-35+70-21,(hauteur/2)-5+10-1,(largeur/2)-35+70-1);
    
    wbkgd(pad, A_REVERSE);
    prefresh(pad,cat_selected-cat_decalage+2,1,(hauteur/2)-3+cat_selected-cat_decalage+2,(largeur/2)-35+70-20,(hauteur/2)-3+cat_selected-cat_decalage+2,(largeur/2)-35+67);
    wbkgd(pad, A_NORMAL);

    if (begin == 1) return 0;

    key = getch();
    fprintf(file,"%d\n",key);
    switch(key)
      {
      case KEY_DOWN:
	if (cat_selected < nb_categories-1) cat_selected++;
	if (cat_selected > cat_decalage +3) cat_decalage = cat_decalage + 1;
	if (cat_decalage > nb_categories -3)cat_decalage = nb_categories -3; 
	break;
      case KEY_UP:
	if(cat_selected > -1) cat_selected--;
	if (cat_selected < cat_decalage -1) cat_decalage = cat_decalage - 1;
	if (cat_decalage < 0)cat_decalage = 0;
	break;
      case '\n':
	return 2;
      case 9:
	return 1;
      case 27:
	return 0;
      }
  }
 return(1);
}



int open_search_box()
{
  WINDOW *dialog;
  WINDOW *cat_pad;

  dialog = newpad(10,70);
  box(dialog,0,0);
  mvwaddstr(dialog,1, 5, "Search for files, folders and disks.");
  mvwaddstr(dialog,3, 2, "Filename: *");
  mvwaddstr(dialog,5, 2, "Description: *");
  mvwaddstr(dialog,7, 2, "Information: *");
  mvwaddstr(dialog,1, 55, "Category");
  prefresh(dialog,0,0,(hauteur/2)-5,(largeur/2)-35,(hauteur/2)-5+10,(largeur/2)-35+70);
  name[0] = '*';
  name[1] = '\0';
  desc[0] = '*';;
  desc[1] = '\0';
  info[0] = '*';
  info[1] = '\0';
  cat_selected = -1;

  cat_pad = newpad(7,20);
  box(cat_pad,0,0);
  prefresh(cat_pad,0,0,(hauteur/2)-3,(largeur/2)-35+70-21,(hauteur/2)-5+10-1,(largeur/2)-35+70-1);
  
  cat_decalage = 0;
  set_categorie(cat_pad, 1);

  while(1)
    {
     switch(set_filename(dialog))
       {
	 case 1:
	   switch(set_description(dialog))
	     {
	     case 1:
	       switch(set_information(dialog))
		 {
		 case 1:
		   switch(set_categorie(cat_pad, 0))
		     {
		     case 2:
		       delwin(cat_pad);
		       delwin(dialog);
		       return 2;
		     case 0:
		       delwin(cat_pad);
		       delwin(dialog);
		       return 0;
		     }
		   break;
		 case 2:
		   delwin(cat_pad);
		   delwin(dialog);
		   return 2;
		 case 0:
		   delwin(cat_pad);
		   delwin(dialog);
		   return 0;
		 }
	       break;
	     case 2:
	       delwin(cat_pad);
	       delwin(dialog);
	       return 2;
	     case 0:
	       delwin(cat_pad);
	       delwin(dialog);
	       return 0;
	     } 
	   break;
       case 2:
	 delwin(cat_pad);
	 delwin(dialog);
	 return 2;
       case 0:
	 delwin(cat_pad);
	 delwin(dialog); 
	 return 0;
       } 
    }
  
}



void start_search_function()
{
  
    {
      while(1)
	{
	  if(open_search_box() == 2)
	    {
	      start_search(name,info,info,cat_selected);
	      if(open_search_result() == 0) return ;
	    }
	  else return;
	}
    }

}
