/*  NCatalog , the GTKtalog ncurses GUI.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "text.h"
#include "searchbox.h"
#include "data.h"
#include "search.h"
#include "test.priv.h"
#include "browser.h"
#include <ctype.h>
#include <term.h>
#include <string.h>
#include <ncurses.h>

extern int hauteur;
extern int largeur;
extern char *help;

extern search_info *search_files;
extern int nb_files;

WINDOW *sfile_pad;
WINDOW *ssize_pad;
WINDOW *sdate_pad;
WINDOW *scat_pad;
WINDOW *sdesc_pad;
WINDOW *spath_pad;

int sfile_pad_size;
int ssize_pad_size;
int sdate_pad_size;
int spath_pad_size;
int scat_pad_size;
int sdesc_pad_size;
int sselected;
int last_sselected;
int sdecalage;

char *blanck_line;

char ressize_pad;


void search_put_line(WINDOW *pad, int pos)
{
  wvline( pad, ACS_VLINE,  pos);
  wbkgd(pad, A_REVERSE);
  prefresh(pad,1,0,1,pos,1,pos);
  wbkgd(pad, A_NORMAL);
  prefresh(pad,1,0,2,pos,hauteur-3,pos);
}


void search_blanck_pad(WINDOW *pad)
{
  int i;
  
  for(i=0;i<(hauteur -2);i++) mvwaddstr(pad,i , 0, blanck_line);  
}


void search_update_browser_description(WINDOW *parent_pad,Folder *folder,int update)
{
 // WINDOW *pad;
  int i;
  int old_sdecalage; 
  char *data;

  data = (char *)malloc((sdesc_pad_size +1)*sizeof(char));
  old_sdecalage = sdecalage;
 
  if(sselected -sdecalage+1 > (hauteur -4)) sdecalage = sdecalage + 5;
  if(sselected -sdecalage < 0) sdecalage = sdecalage - 5; 
  if((sdecalage + hauteur -4) > nb_files) sdecalage = nb_files -hauteur +4;
  if(sdecalage < 0) sdecalage = 0;
    

  if ((sdecalage != old_sdecalage)||(update == 1))
    {
      search_blanck_pad(sdesc_pad); 
      wbkgd(sdesc_pad, A_REVERSE);
      mvwaddstr(sdesc_pad,0 , 0, "Description");
      prefresh(sdesc_pad,0,0,1,6+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size,1,ssize_pad_size+6+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size+sdesc_pad_size);
      wbkgd(sdesc_pad, A_NORMAL); 
      for(i=0;i<hauteur -4;i++)
	{
	  if(i<nb_files)
	    {
	      if((search_files[i+sdecalage].folder->description == 0)&&(search_files[i+sdecalage].folder->information != NULL))
		{
		  mvwaddstr(sdesc_pad,i+1, 0,mycopy(data,search_files[i+sdecalage].folder->information,sdesc_pad_size));
		}
	      else mvwaddstr(sdesc_pad,i+1, 0,mycopy(data,descriptions[search_files[i+sdecalage].folder->description],sdesc_pad_size));
	    }
	  else mvwaddstr(sdesc_pad,i+1, 0,mycopy(data,blanck_line,sdesc_pad_size));
	}
      prefresh(sdesc_pad,1,0,2,6+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size,hauteur -2,ssize_pad_size+6+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size+sdesc_pad_size);
      //maintenant, on met en BOLD tout ce qui n'est pas un fichier (disque, symlink, repertoires...)
      wbkgd(sdesc_pad, A_BOLD);
      for(i=0;i<hauteur -4;i++)
	{
	  if(i<nb_files)
	    {
	      if(is_file(search_files[i+sdecalage].folder) != 1) 
		prefresh(sdesc_pad,i+1,0,i+2,6+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size,i+2,ssize_pad_size+6+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size+sdesc_pad_size); 
	    }
	}
    }

    //on efface l'ancien fichier selection, et on le met comme il faut : BOLR ou NORMAL
  if(nb_files > 0)
    {
      if(is_file(search_files[last_sselected].folder) == 1)
	{
	  wbkgd(sdesc_pad, A_NORMAL);
	  prefresh(sdesc_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,6+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size,last_sselected -sdecalage+2,ssize_pad_size+6+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size+sdesc_pad_size); 
	}
      else
	{
	  wbkgd(sdesc_pad, A_BOLD);
	  prefresh(sdesc_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,6+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size,last_sselected -sdecalage+2,ssize_pad_size+6+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size+sdesc_pad_size); 
	}
      //on surligne le nouveau selectionn.
      wbkgd(sdesc_pad, A_REVERSE);
      prefresh(sdesc_pad,sselected -sdecalage+1,0,sselected -sdecalage+2,6+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size,sselected -sdecalage+2,ssize_pad_size+6+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size+sdesc_pad_size); 
    }

  last_sselected = sselected;//il faut le faire au dernier pad mis ajour, sinon les autres marchent pas!
 // sdecalage = old_sdecalage; //pour restaurer la config pour l'affichage du pas suivant.*/
}






void search_update_browser_categorie(WINDOW *parent_pad,Folder *folder,int update)
{
 // WINDOW *pad;
  int i;
  int old_sdecalage; 
  char *data;

  data = (char *)malloc((scat_pad_size +1)*sizeof(char));
  old_sdecalage = sdecalage;
 
  if(sselected -sdecalage+1 > (hauteur -4)) sdecalage = sdecalage + 5;
  if(sselected -sdecalage < 0) sdecalage = sdecalage - 5; 
  if((sdecalage + hauteur -4) > nb_files) sdecalage = nb_files -hauteur +4;
  if(sdecalage < 0) sdecalage = 0;
    

  if ((sdecalage != old_sdecalage)||(update == 1))
    {
      search_blanck_pad(scat_pad); 
      wbkgd(scat_pad, A_REVERSE);
      mvwaddstr(scat_pad,0 , 0, "Category");
      prefresh(scat_pad,0,0,1,5+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size,1,ssize_pad_size+5+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size);
      wbkgd(scat_pad, A_NORMAL); 
      for(i=0;i<hauteur -4;i++)
	{
	  if(i<nb_files)
	    mvwaddstr(scat_pad,i+1, 0,mycopy(data,categories[search_files[i+sdecalage].folder->categorie],scat_pad_size));
	  else mvwaddstr(scat_pad,i+1, 0,mycopy(data,blanck_line,scat_pad_size));
	}
      prefresh(scat_pad,1,0,2,5+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size,hauteur -2,ssize_pad_size+5+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size);
      //maintenant, on met en BOLD tout ce qui n'est pas un fichier (disque, symlink, repertoires...)
      wbkgd(scat_pad, A_BOLD);
      for(i=0;i<hauteur -4;i++)
	{
	  if(i<nb_files)
	    {
	      if(is_file(search_files[i+sdecalage].folder) != 1) 
		prefresh(scat_pad,i+1,0,i+2,5+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size,i+2,ssize_pad_size+5+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size); 
	    }
	}
    }

    //on efface l'ancien fichier selection, et on le met comme il faut : BOLR ou NORMAL
   if(nb_files > 0)
    {
      if(is_file(search_files[last_sselected].folder) == 1)
	{
	  wbkgd(scat_pad, A_NORMAL);
	  prefresh(scat_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,5+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size,last_sselected -sdecalage+2,ssize_pad_size+5+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size); 
	}
      else
	{
	  wbkgd(scat_pad, A_BOLD);
	  prefresh(scat_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,5+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size,last_sselected -sdecalage+2,ssize_pad_size+5+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size); 
	}
      //on surligne le nouveau selectionn.
      wbkgd(scat_pad, A_REVERSE);
      prefresh(scat_pad,sselected -sdecalage+1,0,sselected -sdecalage+2,5+sfile_pad_size+ssize_pad_size+sdate_pad_size+spath_pad_size,sselected -sdecalage+2,ssize_pad_size+5+sfile_pad_size+sdate_pad_size+spath_pad_size+scat_pad_size); 
    }
 // last_sselected = sselected;//il faut le faire au dernier pad mis ajour, sinon les autres marchent pas!
  sdecalage = old_sdecalage; //pour restaurer la config pour l'affichage du pas suivant.*/
}


void search_update_browser_path(WINDOW *parent_pad,Folder *folder,int update)
{
 // WINDOW *pad;
  int i;
  int old_sdecalage; 
  char *data;
 // sdate_pad = subpad(parent_pad,hauteur -5,spath_pad_size,3,sfile_pad_size+3+ssize_pad_size+spath_pad_size);
 
 data = (char *)malloc((spath_pad_size +1)*sizeof(char));
  old_sdecalage = sdecalage;
 
  if(sselected -sdecalage+1 > (hauteur -4)) sdecalage = sdecalage + 5;
  if(sselected -sdecalage < 0) sdecalage = sdecalage - 5; 
  if((sdecalage + hauteur -4) > nb_files) sdecalage = nb_files -hauteur +4;
  if(sdecalage < 0) sdecalage = 0;
    

  if ((sdecalage != old_sdecalage)||(update == 1))
    {
      search_blanck_pad(spath_pad); 
      wbkgd(spath_pad, A_REVERSE);
      mvwaddstr(spath_pad,0 , 0, "  Path");
      prefresh(spath_pad,0,0,1,4+sfile_pad_size+ssize_pad_size+sdate_pad_size,1,ssize_pad_size+4+sfile_pad_size+sdate_pad_size+spath_pad_size);
      wbkgd(spath_pad, A_NORMAL); 
      for(i=0;i<hauteur -4;i++)
	{
	  if(i<nb_files)
	    {
	      mvwaddstr(spath_pad,i+1, 0,mycopy(data,search_files[i+sdecalage].data,spath_pad_size));
	    }
	  else mvwaddstr(spath_pad,i+1, 0,mycopy(data,blanck_line,spath_pad_size));
	}
      prefresh(spath_pad,1,0,2,4+sfile_pad_size+ssize_pad_size+sdate_pad_size,hauteur -2,ssize_pad_size+4+sfile_pad_size+sdate_pad_size+spath_pad_size);
      //maintenant, on met en BOLD tout ce qui n'est pas un fichier (disque, symlink, repertoires...)
      wbkgd(spath_pad, A_BOLD);
      for(i=0;i<hauteur -4;i++)
	{
	  if(i<nb_files)
	    {
	      if(is_file(search_files[i+sdecalage].folder) != 1) 
		prefresh(spath_pad,i+1,0,i+2,4+sfile_pad_size+ssize_pad_size+sdate_pad_size,i+2,ssize_pad_size+4+sfile_pad_size+sdate_pad_size+spath_pad_size);
	    } 
	}
    }

    //on efface l'ancien fichier selection, et on le met comme il faut : BOLR ou NORMAL
 if(nb_files > 0)
    {
      if(is_file(search_files[last_sselected].folder) == 1)
	{
	  wbkgd(spath_pad, A_NORMAL);
	  prefresh(spath_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,4+sfile_pad_size+ssize_pad_size+sdate_pad_size,last_sselected -sdecalage+2,ssize_pad_size+4+sfile_pad_size+sdate_pad_size+spath_pad_size); 
	}
      else
	{
	  wbkgd(spath_pad, A_BOLD);
	  prefresh(spath_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,4+sfile_pad_size+ssize_pad_size+sdate_pad_size,last_sselected -sdecalage+2,ssize_pad_size+4+sfile_pad_size+sdate_pad_size+spath_pad_size); 
	}
      //on surligne le nouveau selectionn.
      wbkgd(spath_pad, A_REVERSE);
      prefresh(spath_pad,sselected -sdecalage+1,0,sselected -sdecalage+2,4+sfile_pad_size+ssize_pad_size+sdate_pad_size,sselected -sdecalage+2,ssize_pad_size+4+sfile_pad_size+sdate_pad_size+spath_pad_size); 
    }

 // last_sselected = sselected;//il faut le faire au dernier pad mis ajour, sinon les autres marchent pas!
  sdecalage = old_sdecalage; //pour restaurer la config pour l'affichage du pas suivant.*/
}


void search_update_browser_date(WINDOW *parent_pad,Folder *folder,int update)
{
 // WINDOW *pad;
  int i;
  int old_sdecalage; 
  char *data;
 // sdate_pad = subpad(parent_pad,hauteur -5,sdate_pad_size,3,sfile_pad_size+3+ssize_pad_size+sdate_pad_size);
 
 data = (char *)malloc((sdate_pad_size +1)*sizeof(char));
  old_sdecalage = sdecalage;
 
  if(sselected -sdecalage+1 > (hauteur -4)) sdecalage = sdecalage + 5;
  if(sselected -sdecalage < 0) sdecalage = sdecalage - 5; 
  if((sdecalage + hauteur -4) > nb_files) sdecalage = nb_files -hauteur +4;
  if(sdecalage < 0) sdecalage = 0;
    

  if ((sdecalage != old_sdecalage)||(update == 1))
    {
      search_blanck_pad(sdate_pad); 
      wbkgd(sdate_pad, A_REVERSE);
      mvwaddstr(sdate_pad,0 , 0, "  Date");
      prefresh(sdate_pad,0,0,1,3+sfile_pad_size+ssize_pad_size,1,ssize_pad_size+3+sfile_pad_size+sdate_pad_size);
      wbkgd(sdate_pad, A_NORMAL); 
      for(i=0;i<hauteur -4;i++) 
	{
	  if(i<nb_files)
	    mvwaddstr(sdate_pad,i+1, 0,mycopy(data,get_time(search_files[i+sdecalage].folder->date),sdate_pad_size));
	  else mvwaddstr(sdate_pad,i+1, 0,mycopy(data,blanck_line,sdate_pad_size));
	}
      prefresh(sdate_pad,1,0,2,3+sfile_pad_size+ssize_pad_size,hauteur -2,ssize_pad_size+3+sfile_pad_size+sdate_pad_size);
      //maintenant, on met en BOLD tout ce qui n'est pas un fichier (disque, symlink, repertoires...)
      wbkgd(sdate_pad, A_BOLD);
      for(i=0;i<hauteur -4;i++)
	{
	  if(i<nb_files)
	    {
	      if(is_file(search_files[i+sdecalage].folder) != 1) 
		prefresh(sdate_pad,i+1,0,i+2,3+sfile_pad_size+ssize_pad_size,i+2,ssize_pad_size+3+sfile_pad_size+sdate_pad_size); 
	    }
	}
    }

    //on efface l'ancien fichier selection, et on le met comme il faut : BOLR ou NORMAL
 if(nb_files > 0)
    {
      if(is_file(search_files[last_sselected].folder) == 1)
	{
	  wbkgd(sdate_pad, A_NORMAL);
	  prefresh(sdate_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,3+sfile_pad_size+ssize_pad_size,last_sselected -sdecalage+2,ssize_pad_size+3+sfile_pad_size+sdate_pad_size); 
	}
      else
	{
	  wbkgd(sdate_pad, A_BOLD);
	  prefresh(sdate_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,3+sfile_pad_size+ssize_pad_size,last_sselected -sdecalage+2,ssize_pad_size+3+sfile_pad_size+sdate_pad_size); 
	}
      //on surligne le nouveau selectionn.
      wbkgd(sdate_pad, A_REVERSE);
      prefresh(sdate_pad,sselected -sdecalage+1,0,sselected -sdecalage+2,3+sfile_pad_size+ssize_pad_size,sselected -sdecalage+2,ssize_pad_size+3+sfile_pad_size+sdate_pad_size); 
    }

 // last_sselected = sselected;//il faut le faire au dernier pad mis ajour, sinon les autres marchent pas!
  sdecalage = old_sdecalage; //pour restaurer la config pour l'affichage du pas suivant.*/
}




void search_update_browser_size(WINDOW *parent_pad,Folder *folder, int update)
{
  //WINDOW *pad;
  int i;
  int old_sdecalage; 
  char *data;
 
  data = (char *)malloc((ssize_pad_size +1)*sizeof(char));
  old_sdecalage = sdecalage;
 
  if(sselected -sdecalage+1 > (hauteur -4)) sdecalage = sdecalage + 5;
  if(sselected -sdecalage < 0) sdecalage = sdecalage - 5; 
  if((sdecalage + hauteur -4) > nb_files) sdecalage = nb_files -hauteur +4;
  if(sdecalage < 0) sdecalage = 0;
    

  if ((sdecalage != old_sdecalage)||(update == 1))
    {
      search_blanck_pad(ssize_pad); 
      wbkgd(ssize_pad, A_REVERSE);
      mvwaddstr(ssize_pad,0 , 0, "  Size");
      prefresh(ssize_pad,0,0,1,2+sfile_pad_size,1,ssize_pad_size+2+sfile_pad_size);
      wbkgd(ssize_pad, A_NORMAL); 
      for(i=0;i<hauteur -4;i++)
	{
	  if(i < nb_files) 
	    mvwaddstr(ssize_pad,i+1, 0,mycopy(data,get_size(search_files[i+sdecalage].folder->taille),ssize_pad_size));
	  else mvwaddstr(ssize_pad,i+1, 0,mycopy(data,blanck_line,ssize_pad_size));
	}
      prefresh(ssize_pad,1,0,2,2+sfile_pad_size,hauteur -2,ssize_pad_size+2+sfile_pad_size);
      //maintenant, on met en BOLD tout ce qui n'est pas un fichier (disque, symlink, repertoires...)
      wbkgd(ssize_pad, A_BOLD);
      for(i=0;i<hauteur -4;i++)
	{
	  if(i < nb_files) 
	    {
	      if(is_file(search_files[i+sdecalage].folder) != 1) 
		prefresh(ssize_pad,i+1,0,i+2,2+sfile_pad_size,i+2,ssize_pad_size+2+sfile_pad_size); 
	    }
	}
    }

    //on efface l'ancien fichier selection, et on le met comme il faut : BOLR ou NORMAL
  if(nb_files > 0)
    {
      if(is_file(search_files[last_sselected].folder) == 1)
	{
	  wbkgd(ssize_pad, A_NORMAL);
	  prefresh(ssize_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,2+sfile_pad_size,last_sselected -sdecalage+2,ssize_pad_size+2+sfile_pad_size); 
	}
      else
	{
	  wbkgd(ssize_pad, A_BOLD);
	  prefresh(ssize_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,2+sfile_pad_size,last_sselected -sdecalage+2,ssize_pad_size+2+sfile_pad_size); 
	}
      //on surligne le nouveau selectionn.
      wbkgd(ssize_pad, A_REVERSE);
      prefresh(ssize_pad,sselected -sdecalage+1,0,sselected -sdecalage+2,2+sfile_pad_size,sselected -sdecalage+2,ssize_pad_size+2+sfile_pad_size); 
    }

 // last_sselected = sselected;//il faut le faire au dernier pad mis ajour, sinon les autres marchent pas!
  sdecalage = old_sdecalage; //pour restaurer la config pour l'affichage du pas suivant.*/

 
}




void search_update_browser_file(WINDOW *parent_pad,Folder *folder, int update)
{
//  WINDOW *sfile_pad;

  int i;
  int old_sdecalage; 
  char *data;

 // sfile_pad = subpad(parent_pad,hauteur -5,sfile_pad_size,3,1);

  data = (char *)malloc((sfile_pad_size +1)*sizeof(char));
  old_sdecalage = sdecalage;
 
  if(sselected -sdecalage+1 > (hauteur -4)) sdecalage = sdecalage + 5;
  if(sselected -sdecalage < 0) sdecalage = sdecalage - 5; 
  if((sdecalage + hauteur -4) > nb_files) sdecalage = nb_files -hauteur +4;
  if(sdecalage < 0) sdecalage = 0;
    

  if ((sdecalage != old_sdecalage)||(update == 1))
    {
      search_blanck_pad(sfile_pad); 
      wbkgd(sfile_pad, A_REVERSE);
      mvwaddstr(sfile_pad,0 , 0, "  File");
      prefresh(sfile_pad,0,0,1,1,1,sfile_pad_size);
      wbkgd(sfile_pad, A_NORMAL); 
      for(i=0;i<hauteur -4;i++) 
	{
	 if(i < nb_files) mvwaddstr(sfile_pad,i+1, 0,mycopy(data,search_files[i+sdecalage].folder->name,sfile_pad_size));
	 else mvwaddstr(sfile_pad,i+1, 0,mycopy(data,blanck_line,sfile_pad_size));
	}
      prefresh(sfile_pad,1,0,2,1,hauteur -2,sfile_pad_size);
      //maintenant, on met en BOLD tout ce qui n'est pas un fichier (disque, symlink, repertoires...)
      wbkgd(sfile_pad, A_BOLD);
      for(i=0;i<hauteur -4;i++)
	{
	 if(i < nb_files) 
	   {
	     if(is_file(search_files[i+sdecalage].folder) != 1) 
	       prefresh(sfile_pad,i+1,0,i+2,1,i+2,sfile_pad_size);
	   } 
	}
    }

    //on efface l'ancien fichier selection, et on le met comme il faut : BOLR ou NORMAL
  if(nb_files > 0)
    {
      if(is_file(search_files[last_sselected].folder) == 1)
	{
	  wbkgd(sfile_pad, A_NORMAL);
	  prefresh(sfile_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,1,last_sselected -sdecalage+2,sfile_pad_size); 
	}
      else
	{
	  wbkgd(sfile_pad, A_BOLD);
	  prefresh(sfile_pad,last_sselected -sdecalage+1,0,last_sselected -sdecalage+2,1,last_sselected -sdecalage+2,sfile_pad_size); 
	}
      //on surligne le nouveau selectionn.
      wbkgd(sfile_pad, A_REVERSE);
      prefresh(sfile_pad,sselected -sdecalage+1,0,sselected -sdecalage+2,1,sselected -sdecalage+2,sfile_pad_size); 
    }
      // last_sselected = sselected;//il faut le faire au dernier pad mis ajour, sinon les autres marchent pas!
      sdecalage = old_sdecalage; //pour restaurer la config pour l'affichage du pas suivant.
}



void search_affiche_short_info(WINDOW *pad,Folder *curent_folder,char pad_num)
{
  char *data;
  mvwaddstr(pad, 0, 1, blanck_line); 
  if(nb_files > 0)
    {
      if(sselected != -1)
	{
	  switch(pad_num)
	    {
	    case 'f':
	      mvwaddstr(pad, 0, 1,search_files[sselected].folder->name);
	      break;
	    case 's':
	      mvwaddstr(pad, 0, 1, get_size(search_files[sselected].folder->taille));
	      break;
	    case 'd':
	      mvwaddstr(pad, 0, 1, get_time(search_files[sselected].folder->date));
	      break;
	    case 'c':
	      mvwaddstr(pad, 0, 1, categories[search_files[sselected].folder->categorie]);
	      break;
	    case 'e':
	      if((search_files[sselected].folder->description == 0) && (search_files[sselected].folder->information != NULL))
		{
		  data = (char *)malloc(largeur*sizeof(char));
		  mvwaddstr(pad, 0, 1, mycopy(data,search_files[sselected].folder->information,largeur));
		}
	      else  mvwaddstr(pad, 0, 1, descriptions[search_files[sselected].folder->description]);
	      break;
	    case 'p':
	      mvwaddstr(pad, 0, 1, search_files[sselected].data);
	      break;
	    }      
	  prefresh(pad,0,0,hauteur -1,0,hauteur ,largeur);
	}
    }
} 





int open_search_result()
{
  WINDOW *pad, *down_pad;
  int key;
  Folder *curent_folder;
  int changedir;
  int update;
  int i;

  blanck_line = (char *)malloc(largeur+1*sizeof(char));
  for(i=0;i<largeur;i++) blanck_line[i] = ' ';
  blanck_line[i] = '\0';

  sfile_pad_size = 15;
  ssize_pad_size = 8;
  sdate_pad_size = 10;
  spath_pad_size = 15;
  scat_pad_size = 12;
  sdesc_pad_size= largeur-(sfile_pad_size+ssize_pad_size+sdate_pad_size+scat_pad_size+7+spath_pad_size);
  
  ressize_pad = 'f';
  
  pad = newpad(hauteur -1,largeur);
  box(pad,0,0);
  prefresh(pad,0,0,0,0,hauteur,largeur);
  
  down_pad = newpad(1,largeur);
  search_affiche_short_info(down_pad,curent_folder,ressize_pad);
  prefresh(down_pad,0,0,hauteur -1,0,hauteur ,largeur);
  

  search_put_line(pad,sfile_pad_size +1);
  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1); 
  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+sdate_pad_size+1); 
  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+spath_pad_size+1+sdate_pad_size+1); 
  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+sdate_pad_size+1+spath_pad_size+1+scat_pad_size+1); 
  
  sdecalage = -2;//our le 1er affichage!
  last_sselected = 0;
  sselected = 0;

  while(1)
    {
      update = 0;
      if((changedir == -1)&&(sdesc_pad_size > 1))
	{
	  switch(ressize_pad)
	    {
	    case 'f':
	      sfile_pad_size++;
	      break;
	    case 's':
	      ssize_pad_size++;
	      break;
	    case 'd':
	      sdate_pad_size++;
	      break;
	    case 'c':
	      scat_pad_size++;
	      break;
	    case 'p':
	      spath_pad_size++;
	      break;
	    }
	  sdesc_pad_size= largeur-(sfile_pad_size+ssize_pad_size+sdate_pad_size+scat_pad_size+7+spath_pad_size);
	  search_put_line(pad,sfile_pad_size +1);
	  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1); 
	  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+sdate_pad_size+1); 
	  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+spath_pad_size+1+sdate_pad_size+1); 
	  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+sdate_pad_size+1+spath_pad_size+1+scat_pad_size+1); 
  
	  update = 1;
	}
      else if(changedir == -2)
	{
	  switch(ressize_pad)
	    {
	    case 'f':
	      if(sfile_pad_size > 2)sfile_pad_size--;
	      break;
	    case 's':
	      if(ssize_pad_size > 2)ssize_pad_size--;
	      break;
	    case 'd':
	      if(sdate_pad_size > 2)sdate_pad_size--;
	      break;
	    case 'c':
	      if(scat_pad_size > 2)scat_pad_size--;
	      break;
	    case 'p':
	      if(spath_pad_size > 2)spath_pad_size--;
	      break;
	    }
	  sdesc_pad_size= largeur-(sfile_pad_size+ssize_pad_size+sdate_pad_size+scat_pad_size+7+spath_pad_size);
	  search_put_line(pad,sfile_pad_size +1);
	  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1); 
	  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+sdate_pad_size+1); 
	  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+spath_pad_size+1+sdate_pad_size+1); 
	  search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+sdate_pad_size+1+spath_pad_size+1+scat_pad_size+1); 
  
	  update = 1;
	}

      sfile_pad = newpad(hauteur -3,sfile_pad_size);
      ssize_pad = newpad(hauteur -3,ssize_pad_size);
      sdate_pad = newpad(hauteur -3,sdate_pad_size);
      spath_pad = newpad(hauteur -3,spath_pad_size);
      scat_pad  = newpad(hauteur -3,scat_pad_size);
      sdesc_pad  = newpad(hauteur -3,sdesc_pad_size);

      changedir = 0;
      while(changedir == 0)
	{
	  search_update_browser_file(pad,curent_folder,update);
	  search_update_browser_size(pad,curent_folder,update);
	  search_update_browser_date(pad,curent_folder,update);
	  search_update_browser_path(pad,curent_folder,update);
	  search_update_browser_categorie(pad,curent_folder,update);
	  search_update_browser_description(pad,curent_folder,update); 
	  update = 0;
	  noecho();
	  keypad(stdscr,TRUE);
	  raw();
	  key = getch();
	  switch(key)
	    {
	    case KEY_F(1):
	      ressize_pad = 'f';
	      search_affiche_short_info(down_pad,curent_folder,ressize_pad);
	      break;
	    case KEY_F(2):
	      ressize_pad = 's';
	      search_affiche_short_info(down_pad,curent_folder,ressize_pad);
	      break;
	    case KEY_F(3):
	      ressize_pad = 'd';
	      search_affiche_short_info(down_pad,curent_folder,ressize_pad);
	      break;
	    case KEY_F(4):
	      ressize_pad = 'p';
	      search_affiche_short_info(down_pad,curent_folder,ressize_pad);
	      break;
	    case KEY_F(5):
	      ressize_pad = 'c';
	      search_affiche_short_info(down_pad,curent_folder,ressize_pad);
	      break;
	    case KEY_F(6):
	      ressize_pad = 'e';
	      search_affiche_short_info(down_pad,curent_folder,ressize_pad);
	      break;
	    case KEY_F(7):
	      delwin (down_pad);
	      delwin (pad);
	      return 2;
	      break; 
	    case KEY_F(12):
	       display_information(help);
	      prefresh(pad,0,0,0,0,hauteur,largeur);
	      search_put_line(pad,sfile_pad_size +1);
	      search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1); 
	      search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+sdate_pad_size+1); 
	      search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+spath_pad_size+1+sdate_pad_size+1); 
	      search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+sdate_pad_size+1+spath_pad_size+1+scat_pad_size+1);
	      update = 1;
	      search_update_browser_file(pad,curent_folder,update);
	      search_update_browser_size(pad,curent_folder,update);
	      search_update_browser_date(pad,curent_folder,update);
	      search_update_browser_path(pad,curent_folder,update);
	      search_update_browser_categorie(pad,curent_folder,update);
	      search_update_browser_description(pad,curent_folder,update); 
	      break;        
	    case 'p':
	    case KEY_RIGHT:
	      changedir = -1;
	      break;
	    case 'm':
	    case KEY_LEFT:
	      changedir = -2;
	      break;
	    case 'q': 
	      delwin (pad);
	      delwin (down_pad);
	      return 10;
	    case '\n':
	      display_information(search_files[sselected].folder->information);
	      prefresh(pad,0,0,0,0,hauteur,largeur);
	      search_put_line(pad,sfile_pad_size +1);
	      search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1); 
	      search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+sdate_pad_size+1); 
	      search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+spath_pad_size+1+sdate_pad_size+1); 
	      search_put_line(pad,sfile_pad_size +1+ssize_pad_size+1+sdate_pad_size+1+spath_pad_size+1+scat_pad_size+1);
	      update = 1;
	      search_update_browser_file(pad,curent_folder,update);
	      search_update_browser_size(pad,curent_folder,update);
	      search_update_browser_date(pad,curent_folder,update);
	      search_update_browser_path(pad,curent_folder,update);
	      search_update_browser_categorie(pad,curent_folder,update);
	      search_update_browser_description(pad,curent_folder,update); 
	      break;        
	    case KEY_UP:
	       if(sselected > 0) 
		{
		  sselected--;
		  search_affiche_short_info(down_pad,curent_folder,ressize_pad);
		}
	      break;
	    case KEY_DOWN:
	      if(sselected < (nb_files -1))
		{
		  sselected++;
		  search_affiche_short_info(down_pad,curent_folder,ressize_pad);
		}
	      break;
	    case KEY_F(10):
	      delwin (down_pad);
	      delwin (pad);
	      return 0;
	    default:
	      break;
	    }
	}
    }
}
