/* GtkSQL -- an interactive graphical query tool for PostgreSQL
 * Copyright (C) 1998  Lionel ULMER
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "Pics/warning.xpm"
#include "Pics/question.xpm"

typedef struct _call_data {
  GtkWidget *dialog;
  void (*user_ok_callback)(void *);
  void (*user_cancel_callback)(void *);
  void *user_data;
} CallData;

static void dialog_ok_callback(GtkWidget *widget, gpointer data) {
  CallData *data_rec = (CallData *) data;

  if (data_rec->user_ok_callback != NULL)
    data_rec->user_ok_callback(data_rec->user_data);
  
  gtk_widget_destroy(GTK_WIDGET(data_rec->dialog));
}
static void dialog_cancel_callback(GtkWidget *widget, gpointer data) {
  CallData *data_rec = (CallData *) data;

  if (data_rec->user_cancel_callback != NULL)
    data_rec->user_cancel_callback(data_rec->user_data);
  
  gtk_widget_destroy(GTK_WIDGET(data_rec->dialog));
}

GtkWidget *CreateStandardDialog(char *title, char *text,
				int predefined_type, char **pixmap,
				char *ok_text, void (*ok_callback)(void *),
				char *cancel_text,
				void (*cancel_callback)(void *),
				void *callback_data) {
  GtkWidget *dialog, *table, *label, *ok_button, *cancel_button;
  CallData *data_send;

  /* The dialog */
  dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(dialog), title);
  gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
  gtk_grab_add(dialog);
  gtk_widget_realize(dialog);
  
  /* Now, the top half (pixmap + text) */
  table = gtk_table_new(2, 1, FALSE);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  switch (predefined_type) {
  case 1:
    pixmap = warning_xpm;
    break;

  case 2:
    pixmap = question_xpm;
    break;
    
  default:
    break;
  }

  if (pixmap != NULL) {
    GdkBitmap *mask;
    GdkPixmap *gdkpix;
    GtkStyle *style;
    GtkWidget *gtkpix;

    style = gtk_widget_get_style(dialog);
    gdkpix = gdk_pixmap_create_from_xpm_d(dialog->window,
					  &mask,
					  &style->bg[GTK_STATE_NORMAL],
					  pixmap);
    gtkpix = gtk_pixmap_new(gdkpix, mask);

    gtk_table_attach_defaults(GTK_TABLE(table), gtkpix, 0, 1, 0, 1);
    gtk_widget_show(gtkpix);
  }
  
  label = gtk_label_new(text);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 1, 2, 0, 1);
  gtk_widget_show(label);

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), table, TRUE,
		     TRUE, 0);
  gtk_widget_show(table);

  /* The structure for the callbacks */
  data_send = (CallData *) g_malloc(sizeof(CallData));
  data_send->dialog = dialog;
  data_send->user_data = callback_data;
  data_send->user_ok_callback = ok_callback;
  data_send->user_cancel_callback = cancel_callback;
  
  /* The bottom half */
  if (ok_text != NULL) {
    ok_button = gtk_button_new_with_label(ok_text);
    gtk_signal_connect(GTK_OBJECT(ok_button), "clicked",
		       GTK_SIGNAL_FUNC(dialog_ok_callback), data_send);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       ok_button, FALSE, FALSE, 0);
    GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(ok_button);
    gtk_widget_show(ok_button);
  }
  if (cancel_text != NULL) {
    cancel_button = gtk_button_new_with_label(cancel_text);
    gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
		       GTK_SIGNAL_FUNC(dialog_cancel_callback), data_send);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       cancel_button, FALSE, FALSE, 0);
    gtk_widget_show(cancel_button);
  }

  return dialog;
}
