/*  gstalker stock charter

 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "gstalker.h"
#include <ctype.h>


/*************************************************************************************/
void 
color_selected (GtkWidget * button)
{
  extern GtkWidget *colorsel, *colorseldlg, *main_window;
  extern gint edit_options_save_flag;
  GtkStyle *mystyle, *stdstyle;
  gdouble colors[3];
  gint tint, tint2, tint3;


  gtk_color_selection_get_color (GTK_COLOR_SELECTION (colorsel), colors);
  tint = (int) (colors[0] * 65535.0);
  tint2 = (int) (colors[1] * 65535.0);
  tint3 = (int) (colors[2] * 65535.0);

  stdstyle = gtk_widget_get_style (main_window);
  mystyle = gtk_style_copy (stdstyle);
  mystyle->bg[GTK_STATE_NORMAL].red = tint;
  mystyle->bg[GTK_STATE_NORMAL].green = tint2;
  mystyle->bg[GTK_STATE_NORMAL].blue = tint3;
  gtk_widget_set_style (button, mystyle);
  gtk_widget_destroy (colorseldlg);
  edit_options_save_flag = 1;

}
/****************************************************************************************/
void 
color_selection (GtkWidget * button)
{
  extern GtkWidget *colorseldlg, *colorsel;
  gdouble colors[3];



  colors[0] = button->style->bg[GTK_STATE_NORMAL].red / 65535.0;
  colors[1] = button->style->bg[GTK_STATE_NORMAL].green / 65535.0;
  colors[2] = button->style->bg[GTK_STATE_NORMAL].blue / 65535.0;

  colorseldlg = gtk_color_selection_dialog_new ("");
  colorsel = GTK_COLOR_SELECTION_DIALOG (colorseldlg)->colorsel;
  gtk_window_position (GTK_WINDOW (colorseldlg), GTK_WIN_POS_CENTER);
  gtk_color_selection_set_opacity (GTK_COLOR_SELECTION
		       (GTK_COLOR_SELECTION_DIALOG (colorseldlg)->colorsel),
				   FALSE);
  gtk_color_selection_set_update_policy (GTK_COLOR_SELECTION
		       (GTK_COLOR_SELECTION_DIALOG (colorseldlg)->colorsel),
					 GTK_UPDATE_CONTINUOUS);
  gtk_signal_connect (GTK_OBJECT (colorseldlg), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed), &colorseldlg);
  gtk_signal_connect_object (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (colorseldlg)->ok_button),
			     "clicked", GTK_SIGNAL_FUNC (color_selected),
			     GTK_OBJECT (button));
  gtk_signal_connect_object (GTK_OBJECT
		  (GTK_COLOR_SELECTION_DIALOG (colorseldlg)->cancel_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (colorseldlg));
  gtk_color_selection_set_color (GTK_COLOR_SELECTION (colorsel), colors);

  gtk_widget_show (colorseldlg);
}
/*********************************************************************************/
void 
ok_save_options ()
{
  extern gint edit_options_save_flag, chartflag;

  if (edit_options_save_flag)
    {
      save_options ();
      if (chartflag)
	draw ();
    }
}
/*********************************************************************************/
void 
yes_save_options (gint reply)
{
  extern gint chartflag, edit_options_save_flag;


  if (reply)
  {
	edit_options_save_flag = 0;
	exit_edit_options_window();
  }
  else
  {
  	save_options ();
  	if (chartflag)
    		draw ();
  	exit_edit_options_window ();
  }
}
/*********************************************************************************/
void 
exit_edit_options_window ()
{
  gint tint=0;
  GtkWidget *dialog;
  extern GtkWidget *edit_options_window, *main_window;
  extern gint edit_options_save_flag, edit_options_flag;
  extern gchar *mess_save_changes;


  if (edit_options_save_flag)
    {
	dialog = gnome_app_question_modal (GNOME_APP(main_window),
						mess_save_changes,
						(GnomeReplyCallback)yes_save_options,
						(gpointer)tint);
	gtk_widget_show(dialog);
    }
  else
  {
	edit_options_save_flag = 0;
	edit_options_flag = 0;
	gtk_widget_destroy(edit_options_window);
  }
}
/*****************************************************************************************/
void 
edit_options_changed ()
{
  extern gint edit_options_save_flag;

  edit_options_save_flag = 1;
}
/***************************************************************************/
void 
save_options ()
{
  GtkStyle *mystyle;
  gint tint, tint2, tint3;
  gchar *tstringp, tstring[250];
  GtkWidget *dialog;
  extern GtkWidget *enable_date_check, *main_window;
  extern GtkWidget *enable_open_check, *enable_high_check, *enable_low_check;
  extern GtkWidget *enable_close_check, *enable_volume_check, *enable_openi_check;
  extern GtkWidget *bars_value_entry, *cb_background, *cb_borders, *cb_grid, *cb_ma1;
  extern GtkWidget *cb_ma2, *cb_ma3, *cb_price, *cb_volume;
  extern gint edit_options_save_flag, chartflag;
  extern struct record config;
  extern gchar *mess_invalid_entry;
  extern GString *current_symbol;



  tstringp = gtk_entry_get_text (GTK_ENTRY (bars_value_entry));
  if (tstringp == NULL)
    config.bars = 0;
  else
    {
      sscanf (tstringp, "%s", tstring);
      tint = strlen (tstring);
      for (tint2 = 0; tint2 < tint; tint2++)
	{
	  tint3 = isdigit (tstring[tint2]);
	  if (tint3 == 0)
	  {
	  	dialog = gnome_app_error (GNOME_APP(main_window), mess_invalid_entry);
		gtk_widget_show(dialog);
		return;
	  }

	}
      config.bars = atoi (tstring);
    }
  if (GTK_TOGGLE_BUTTON (enable_date_check)->active)
    config.date_flag = 1;
  else
    config.date_flag = 0;
  if (GTK_TOGGLE_BUTTON (enable_open_check)->active)
    config.open_flag = 1;
  else
    config.open_flag = 0;
  if (GTK_TOGGLE_BUTTON (enable_high_check)->active)
    config.high_flag = 1;
  else
    config.high_flag = 0;
  if (GTK_TOGGLE_BUTTON (enable_low_check)->active)
    config.low_flag = 1;
  else
    config.low_flag = 0;
  if (GTK_TOGGLE_BUTTON (enable_close_check)->active)
    config.close_flag = 1;
  else
    config.close_flag = 0;
  if (GTK_TOGGLE_BUTTON (enable_volume_check)->active)
    config.volume_flag = 1;
  else
    config.volume_flag = 0;
  if (GTK_TOGGLE_BUTTON (enable_openi_check)->active)
    config.openi_flag = 1;
  else
    config.openi_flag = 0;


  mystyle = gtk_widget_get_style (cb_background);
  config.background_red = mystyle->bg[GTK_STATE_NORMAL].red >> 8;
  config.background_green = mystyle->bg[GTK_STATE_NORMAL].green >> 8;
  config.background_blue = mystyle->bg[GTK_STATE_NORMAL].blue >> 8;

  mystyle = gtk_widget_get_style (cb_borders);
  config.border_red = mystyle->bg[GTK_STATE_NORMAL].red >> 8;
  config.border_green = mystyle->bg[GTK_STATE_NORMAL].green >> 8;
  config.border_blue = mystyle->bg[GTK_STATE_NORMAL].blue >> 8;

  mystyle = gtk_widget_get_style (cb_grid);
  config.grid_red = mystyle->bg[GTK_STATE_NORMAL].red >> 8;
  config.grid_green = mystyle->bg[GTK_STATE_NORMAL].green >> 8;
  config.grid_blue = mystyle->bg[GTK_STATE_NORMAL].blue >> 8;

  mystyle = gtk_widget_get_style (cb_ma1);
  config.moving_red = mystyle->bg[GTK_STATE_NORMAL].red >> 8;
  config.moving_green = mystyle->bg[GTK_STATE_NORMAL].green >> 8;
  config.moving_blue = mystyle->bg[GTK_STATE_NORMAL].blue >> 8;

  mystyle = gtk_widget_get_style (cb_ma2);
  config.moving2_red = mystyle->bg[GTK_STATE_NORMAL].red >> 8;
  config.moving2_green = mystyle->bg[GTK_STATE_NORMAL].green >> 8;
  config.moving2_blue = mystyle->bg[GTK_STATE_NORMAL].blue >> 8;

  mystyle = gtk_widget_get_style (cb_ma3);
  config.moving3_red = mystyle->bg[GTK_STATE_NORMAL].red >> 8;
  config.moving3_green = mystyle->bg[GTK_STATE_NORMAL].green >> 8;
  config.moving3_blue = mystyle->bg[GTK_STATE_NORMAL].blue >> 8;

  mystyle = gtk_widget_get_style (cb_price);
  config.price_red = mystyle->bg[GTK_STATE_NORMAL].red >> 8;
  config.price_green = mystyle->bg[GTK_STATE_NORMAL].green >> 8;
  config.price_blue = mystyle->bg[GTK_STATE_NORMAL].blue >> 8;

  mystyle = gtk_widget_get_style (cb_volume);
  config.volume_red = mystyle->bg[GTK_STATE_NORMAL].red >> 8;
  config.volume_green = mystyle->bg[GTK_STATE_NORMAL].green >> 8;
  config.volume_blue = mystyle->bg[GTK_STATE_NORMAL].blue >> 8;

  edit_options_save_flag = 0;
  if (chartflag)
    {
      update_stats_bar ();
      load_file (current_symbol->str);
      draw ();
    }
}
/*****************************************************************************/
void 
edit_options ()
{
  GtkStyle *stdstyle, *mystyle;
  GString *tstring;
  GtkWidget *frame3, *frame4, *frame5, *hbox, *hbox2, *hbox3, *hbox4, *hbox6, *hbox7;
  GtkWidget *hbox8,*hbox9,*hbox10,*hbox11,*notebook,*ok_button,*cancel_button,*nbox;
  GtkWidget *vbox, *vbox2, *vbox5, *vbox6, *vbox7, *vbox8;
  GtkWidget *label, *label2, *label3, *label8, *label9;
  GtkWidget *label10, *label11, *label12, *label13, *label14, *label15;
  extern GtkWidget *cb_background, *cb_borders, *cb_grid, *cb_ma1, *cb_ma2, *cb_ma3;
  extern GtkWidget *cb_price, *cb_volume, *edit_options_window, *enable_date_check;
  extern GtkWidget *enable_open_check, *enable_high_check, *enable_low_check;
  extern GtkWidget *enable_close_check, *enable_volume_check, *enable_openi_check;
  extern GtkWidget *bars_value_entry, *main_window;
  extern gint edit_options_flag, edit_options_save_flag;
  extern struct record config;
  extern gchar *label_edit_options, *label_save, *label_cancel, *label_data_bar_fields;
  extern gchar *label_date, *label_open, *label_high, *label_low, *label_close, *label_volume;
  extern gchar *label_ointerest, *label_status_bar, *label_maximum_data_points;
  extern gchar *label_charts, *label_properties, *label_background, *label_borders;
  extern gchar *label_grid, *label_ma, *label_ma2, *label_ma3, *label_close, *label_volume;
  extern gchar *label_colors;



  if (edit_options_flag)
    return;

  tstring = g_string_new(NULL);

  edit_options_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (edit_options_window), "destroy",
		      GTK_SIGNAL_FUNC (exit_edit_options_window), NULL);
  gtk_signal_connect (GTK_OBJECT (edit_options_window), "delete_event",
		      GTK_SIGNAL_FUNC (exit_edit_options_window), NULL);
  gtk_window_set_title (GTK_WINDOW (edit_options_window), label_edit_options);
  gtk_container_border_width (GTK_CONTAINER (edit_options_window), 0);
  gtk_window_position (GTK_WINDOW (edit_options_window), GTK_WIN_POS_CENTER);
  gtk_widget_set_usize (GTK_WIDGET (edit_options_window), 0, 0);

  nbox = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (edit_options_window), nbox);
  gtk_container_border_width (GTK_CONTAINER (nbox), 10);
  gtk_widget_show (nbox);

  notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
  gtk_box_pack_start (GTK_BOX (nbox), notebook, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (notebook), 0);
  gtk_widget_show (notebook);

  vbox = gtk_vbutton_box_new ();
  gtk_vbutton_box_set_spacing_default (5);
  gtk_vbutton_box_set_layout_default (GTK_BUTTONBOX_START);
  gtk_box_pack_start (GTK_BOX (nbox), vbox, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox), 5);
  gtk_widget_show (vbox);

  ok_button = gtk_button_new_with_label (label_save);
  gtk_box_pack_start (GTK_BOX (vbox), ok_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
		      GTK_SIGNAL_FUNC (ok_save_options), NULL);
  gtk_widget_show (ok_button);

  cancel_button = gtk_button_new_with_label (label_cancel);
  gtk_box_pack_start (GTK_BOX (vbox), cancel_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
		      GTK_SIGNAL_FUNC (exit_edit_options_window), NULL);
  gtk_widget_show (cancel_button);

/*** status page ***/

  vbox2 = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
  gtk_widget_show (vbox2);

  hbox = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (hbox), 0);
  gtk_widget_show (hbox);

  frame3 = gtk_frame_new (label_data_bar_fields);
  gtk_box_pack_start (GTK_BOX (hbox), frame3, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (frame3), 0);
  gtk_widget_show (frame3);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame3), vbox5);
  gtk_container_border_width (GTK_CONTAINER (vbox5), 5);
  gtk_widget_show (vbox5);

  enable_date_check = gtk_check_button_new_with_label (label_date);
  gtk_box_pack_start (GTK_BOX (vbox5), enable_date_check, FALSE, TRUE, 0);
  if (config.date_flag)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (enable_date_check), TRUE);
  gtk_signal_connect (GTK_OBJECT (enable_date_check), "toggled",
		      GTK_SIGNAL_FUNC (edit_options_changed), NULL);
  gtk_widget_show (enable_date_check);

  enable_open_check = gtk_check_button_new_with_label (label_open);
  gtk_box_pack_start (GTK_BOX (vbox5), enable_open_check, FALSE, TRUE, 0);
  if (config.open_flag)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (enable_open_check), TRUE);
  gtk_signal_connect (GTK_OBJECT (enable_open_check), "toggled",
		      GTK_SIGNAL_FUNC (edit_options_changed), NULL);
  gtk_widget_show (enable_open_check);

  enable_high_check = gtk_check_button_new_with_label (label_high);
  gtk_box_pack_start (GTK_BOX (vbox5), enable_high_check, FALSE, TRUE, 0);
  if (config.high_flag)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (enable_high_check), TRUE);
  gtk_signal_connect (GTK_OBJECT (enable_high_check), "toggled",
		      GTK_SIGNAL_FUNC (edit_options_changed), NULL);
  gtk_widget_show (enable_high_check);

  enable_low_check = gtk_check_button_new_with_label (label_low);
  gtk_box_pack_start (GTK_BOX (vbox5), enable_low_check, FALSE, TRUE, 0);
  if (config.low_flag)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (enable_low_check), TRUE);
  gtk_signal_connect (GTK_OBJECT (enable_low_check), "toggled",
		      GTK_SIGNAL_FUNC (edit_options_changed), NULL);
  gtk_widget_show (enable_low_check);

  enable_close_check = gtk_check_button_new_with_label (label_close);
  gtk_box_pack_start (GTK_BOX (vbox5), enable_close_check, FALSE, TRUE, 0);
  if (config.close_flag)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (enable_close_check), TRUE);
  gtk_signal_connect (GTK_OBJECT (enable_close_check), "toggled",
		      GTK_SIGNAL_FUNC (edit_options_changed), NULL);
  gtk_widget_show (enable_close_check);

  enable_volume_check = gtk_check_button_new_with_label (label_volume);
  gtk_box_pack_start (GTK_BOX (vbox5), enable_volume_check, FALSE, TRUE, 0);
  if (config.volume_flag)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (enable_volume_check), TRUE);
  gtk_signal_connect (GTK_OBJECT (enable_volume_check), "toggled",
		      GTK_SIGNAL_FUNC (edit_options_changed), NULL);
  gtk_widget_show (enable_volume_check);

  enable_openi_check = gtk_check_button_new_with_label (label_ointerest);
  gtk_box_pack_start (GTK_BOX (vbox5), enable_openi_check, FALSE, TRUE, 0);
  if (config.openi_flag)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (enable_openi_check), TRUE);
  gtk_signal_connect (GTK_OBJECT (enable_openi_check), "toggled",
		      GTK_SIGNAL_FUNC (edit_options_changed), NULL);
  gtk_widget_show (enable_openi_check);

  label = gtk_label_new (label_status_bar);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox2, label);

/*** chart page ***/

  vbox6 = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (vbox6), 10);
  gtk_widget_show (vbox6);

  frame4 = gtk_frame_new (label_maximum_data_points);
  gtk_box_pack_start (GTK_BOX (vbox6), frame4, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (frame4), 0);
  gtk_widget_show (frame4);

  hbox2 = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (frame4), hbox2);
  gtk_container_border_width (GTK_CONTAINER (hbox2), 5);
  gtk_widget_show (hbox2);

  bars_value_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox2), bars_value_entry, TRUE, TRUE, 0);
  g_string_sprintf (tstring, "%d", config.bars);
  gtk_entry_set_text (GTK_ENTRY (bars_value_entry), tstring->str);
  gtk_signal_connect (GTK_OBJECT (bars_value_entry), "changed",
		      GTK_SIGNAL_FUNC (edit_options_changed), NULL);
  gtk_widget_show (bars_value_entry);
  
  label2 = gtk_label_new (label_charts);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox6, label2);

/*** colors page ***/

  vbox7 = gtk_vbox_new (FALSE, 5);
  gtk_container_border_width (GTK_CONTAINER (vbox7), 10);
  gtk_widget_show (vbox7);

  frame5 = gtk_frame_new (label_properties);
  gtk_box_pack_start (GTK_BOX (vbox7), frame5, FALSE, TRUE, 0);
  gtk_widget_show (frame5);

  vbox8 = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame5), vbox8);
  gtk_container_border_width (GTK_CONTAINER (vbox8), 5);
  gtk_widget_show (vbox8);

  hbox3 = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox3, FALSE, TRUE, 0);
  gtk_widget_show (hbox3);

  cb_background = gtk_button_new ();
  gtk_box_pack_start (GTK_BOX (hbox3), cb_background, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cb_background), "clicked",
		      GTK_SIGNAL_FUNC (color_selection), cb_background);
  gtk_widget_set_usize (GTK_WIDGET (cb_background), 20, 10);
  gtk_widget_show (cb_background);

  label8 = gtk_label_new (label_background);
  gtk_box_pack_start (GTK_BOX (hbox3), label8, FALSE, TRUE, 0);
  gtk_widget_show (label8);

  hbox4 = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox4, FALSE, TRUE, 0);
  gtk_widget_show (hbox4);

  cb_borders = gtk_button_new_with_label ("");
  gtk_box_pack_start (GTK_BOX (hbox4), cb_borders, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cb_borders), "clicked",
		      GTK_SIGNAL_FUNC (color_selection), cb_borders);
  gtk_widget_set_usize (GTK_WIDGET (cb_borders), 20, 10);
  gtk_widget_show (cb_borders);

  label9 = gtk_label_new (label_borders);
  gtk_box_pack_start (GTK_BOX (hbox4), label9, FALSE, TRUE, 0);
  gtk_widget_show (label9);

  hbox6 = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox6, FALSE, TRUE, 0);
  gtk_widget_show (hbox6);

  cb_grid = gtk_button_new_with_label ("");
  gtk_box_pack_start (GTK_BOX (hbox6), cb_grid, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cb_grid), "clicked",
		      GTK_SIGNAL_FUNC (color_selection), cb_grid);
  gtk_widget_set_usize (GTK_WIDGET (cb_grid), 20, 10);
  gtk_widget_show (cb_grid);

  label10 = gtk_label_new (label_grid);
  gtk_box_pack_start (GTK_BOX (hbox6), label10, FALSE, TRUE, 0);
  gtk_widget_show (label10);

  hbox7 = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox7, FALSE, TRUE, 0);
  gtk_widget_show (hbox7);

  cb_ma1 = gtk_button_new_with_label ("");
  gtk_box_pack_start (GTK_BOX (hbox7), cb_ma1, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cb_ma1), "clicked",
		      GTK_SIGNAL_FUNC (color_selection), cb_ma1);
  gtk_widget_set_usize (GTK_WIDGET (cb_ma1), 20, 10);
  gtk_widget_show (cb_ma1);

  label11 = gtk_label_new (label_ma);
  gtk_box_pack_start (GTK_BOX (hbox7), label11, FALSE, TRUE, 0);
  gtk_widget_show (label11);

  hbox8 = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox8, FALSE, TRUE, 0);
  gtk_widget_show (hbox8);

  cb_ma2 = gtk_button_new_with_label ("");
  gtk_box_pack_start (GTK_BOX (hbox8), cb_ma2, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cb_ma2), "clicked",
		      GTK_SIGNAL_FUNC (color_selection), cb_ma2);
  gtk_widget_set_usize (GTK_WIDGET (cb_ma2), 20, 10);
  gtk_widget_show (cb_ma2);

  label12 = gtk_label_new (label_ma2);
  gtk_box_pack_start (GTK_BOX (hbox8), label12, FALSE, TRUE, 0);
  gtk_widget_show (label12);

  hbox9 = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox9, FALSE, TRUE, 0);
  gtk_widget_show (hbox9);

  cb_ma3 = gtk_button_new_with_label ("");
  gtk_box_pack_start (GTK_BOX (hbox9), cb_ma3, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cb_ma3), "clicked",
		      GTK_SIGNAL_FUNC (color_selection), cb_ma3);
  gtk_widget_set_usize (GTK_WIDGET (cb_ma3), 20, 10);
  gtk_widget_show (cb_ma3);

  label13 = gtk_label_new (label_ma3);
  gtk_box_pack_start (GTK_BOX (hbox9), label13, FALSE, TRUE, 0);
  gtk_widget_show (label13);

  hbox10 = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox10, FALSE, TRUE, 0);
  gtk_widget_show (hbox10);

  cb_price = gtk_button_new_with_label ("");
  gtk_box_pack_start (GTK_BOX (hbox10), cb_price, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cb_price), "clicked",
		      GTK_SIGNAL_FUNC (color_selection), cb_price);
  gtk_widget_set_usize (GTK_WIDGET (cb_price), 20, 10);
  gtk_widget_show (cb_price);

  label14 = gtk_label_new (label_close);
  gtk_box_pack_start (GTK_BOX (hbox10), label14, FALSE, TRUE, 0);
  gtk_widget_show (label14);

  hbox11 = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox11, FALSE, TRUE, 0);
  gtk_widget_show (hbox11);

  cb_volume = gtk_button_new_with_label ("");
  gtk_box_pack_start (GTK_BOX (hbox11), cb_volume, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cb_volume), "clicked",
		      GTK_SIGNAL_FUNC (color_selection), cb_volume);
  gtk_widget_set_usize (GTK_WIDGET (cb_volume), 20, 10);
  gtk_widget_show (cb_volume);

  label15 = gtk_label_new (label_volume);
  gtk_box_pack_start (GTK_BOX (hbox11), label15, FALSE, TRUE, 0);
  gtk_widget_show (label15);

  label3 = gtk_label_new (label_colors);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox7, label3);


  edit_options_flag = 1;
  gtk_widget_show (edit_options_window);
  edit_options_save_flag = 0;

  stdstyle = gtk_widget_get_style (main_window);

  mystyle = gtk_style_copy (stdstyle);
  mystyle->bg[GTK_STATE_NORMAL].red = config.background_red << 8;
  mystyle->bg[GTK_STATE_NORMAL].green = config.background_green << 8;
  mystyle->bg[GTK_STATE_NORMAL].blue = config.background_blue << 8;
  gtk_widget_set_style (cb_background, mystyle);

  mystyle = gtk_style_copy (stdstyle);
  mystyle->bg[GTK_STATE_NORMAL].red = config.border_red << 8;
  mystyle->bg[GTK_STATE_NORMAL].green = config.border_green << 8;
  mystyle->bg[GTK_STATE_NORMAL].blue = config.border_blue << 8;
  gtk_widget_set_style (cb_borders, mystyle);

  mystyle = gtk_style_copy (stdstyle);
  mystyle->bg[GTK_STATE_NORMAL].red = config.grid_red << 8;
  mystyle->bg[GTK_STATE_NORMAL].green = config.grid_green << 8;
  mystyle->bg[GTK_STATE_NORMAL].blue = config.grid_blue << 8;
  gtk_widget_set_style (cb_grid, mystyle);

  mystyle = gtk_style_copy (stdstyle);
  mystyle->bg[GTK_STATE_NORMAL].red = config.moving_red << 8;
  mystyle->bg[GTK_STATE_NORMAL].green = config.moving_green << 8;
  mystyle->bg[GTK_STATE_NORMAL].blue = config.moving_blue << 8;
  gtk_widget_set_style (cb_ma1, mystyle);

  mystyle = gtk_style_copy (stdstyle);
  mystyle->bg[GTK_STATE_NORMAL].red = config.moving2_red << 8;
  mystyle->bg[GTK_STATE_NORMAL].green = config.moving2_green << 8;
  mystyle->bg[GTK_STATE_NORMAL].blue = config.moving2_blue << 8;
  gtk_widget_set_style (cb_ma2, mystyle);

  mystyle = gtk_style_copy (stdstyle);
  mystyle->bg[GTK_STATE_NORMAL].red = config.moving3_red << 8;
  mystyle->bg[GTK_STATE_NORMAL].green = config.moving3_green << 8;
  mystyle->bg[GTK_STATE_NORMAL].blue = config.moving3_blue << 8;
  gtk_widget_set_style (cb_ma3, mystyle);

  mystyle = gtk_style_copy (stdstyle);
  mystyle->bg[GTK_STATE_NORMAL].red = config.price_red << 8;
  mystyle->bg[GTK_STATE_NORMAL].green = config.price_green << 8;
  mystyle->bg[GTK_STATE_NORMAL].blue = config.price_blue << 8;
  gtk_widget_set_style (cb_price, mystyle);

  mystyle = gtk_style_copy (stdstyle);
  mystyle->bg[GTK_STATE_NORMAL].red = config.volume_red << 8;
  mystyle->bg[GTK_STATE_NORMAL].green = config.volume_green << 8;
  mystyle->bg[GTK_STATE_NORMAL].blue = config.volume_blue << 8;
  gtk_widget_set_style (cb_volume, mystyle);
  
  g_string_free(tstring, TRUE);
}
