#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#include "gatos.h"
#include "version.h"

void PrintHelpMessage();

int main(int argc, char **argv) {
  int ctr;
  gatos_init();
  if(argc < 2)  {
    PrintHelpMessage();
    exit(1);
    }
  for(ctr=1; ctr<argc; ctr++) {
    if(argv[ctr][0] == '-') {
      if(argv[ctr][1] == '-') {
	if(!strcmp(argv[ctr], "--help")) PrintHelpMessage();
	else if(!strcmp(argv[ctr], "--version"))
		printf("atitv - gatos %s\n", GATOS_VERSION_STRING);
	else {
	  fprintf(stderr, "Error: unknown option \"%s\"\n", argv[ctr]);
	  PrintHelpMessage();
	  }
	}
      else {
	int v;
	if(strlen(argv[ctr]) != 2) {
	  fprintf(stderr, "Error: unknown option \"%s\"\n", argv[ctr]);
	  PrintHelpMessage();
	  }
	if(argv[ctr][1] == 'h') PrintHelpMessage();
	else if(argv[ctr][1] == 'm') {
	  if(argc < ctr+2)  {
	    fprintf(stderr, "Error: -m switch needs 1 option\n");
	    PrintHelpMessage();
	    }
	  v = strtol(argv[ctr+1], NULL, 10);
	  if(v<=0) {
	    if(argv[ctr+1][0] == 'c' || argv[ctr+1][0] == 'C') v=2;
	    else if(argv[ctr+1][0] == 's' || argv[ctr+1][0] == 'S') v=1;
	    else if(argv[ctr+1][0] == 't' || argv[ctr+1][0] == 'T') v=3;
	    else {
	      fprintf(stderr, "Error: No such mux input \"%s\"\n", argv[ctr+1]);
	      PrintHelpMessage();
	      }
	    }
	  gatos_setmux(v-1);
	  ctr+=1;
	  }
	else if(argv[ctr][1] == 'v') {
	  if(argc < ctr+2)  {
	    fprintf(stderr, "Error: -v switch needs 1 option\n");
	    PrintHelpMessage();
	    }
	  v = strtol(argv[ctr+1], NULL, 10);
	  gatos_setvolume(v);
	  ctr+=1;
	  }
	else if(argv[ctr][1] == 'c') {
	  if(argc < ctr+2)  {
	    fprintf(stderr, "Error: -c switch needs 1 option\n");
	    PrintHelpMessage();
	    }
	  v = strtol(argv[ctr+1], NULL, 10);
	  if(v<=0) {
	    int ctr2;
	    for(ctr2=0; (v<=0) && ctr2<gatos_numchans(); ++ctr2) {
	      if(!strcasecmp(argv[ctr+1], gatos_channame(ctr2))) v=ctr2+1;
	      }
	    if(v<=0) {
	      fprintf(stderr, "Error: No such channel \"%s\"\n", argv[ctr+1]);
	      PrintHelpMessage();
	      }
	    }
	  gatos_setmux(2); // TV-Input
	  gatos_setchan(v-1);
	  ctr+=1;
	  }
	}
      }
    else {
      if(!strcmp(argv[ctr], "rec")) {
	if(argc < ctr+3)  {
	  fprintf(stderr, "Error: rec command needs 2 options\n");
	  PrintHelpMessage();
	  }
	gatos_enable_capture(1);
	gatos_capture(argv[ctr+2], 0);
	if (gatos.usr1pid) kill(gatos.usr1pid,SIGSTOP) ;
	sleep(strtol(argv[ctr+1], NULL, 10));
	if (gatos.usr1pid) kill(gatos.usr1pid,SIGCONT) ;
	gatos_stop();
	gatos_enable_capture(0);
	ctr+=2;
	}
      else if(!strcmp(argv[ctr], "snap")) {
	if(argc < ctr+2)  {
	  fprintf(stderr, "Error: snap command needs 1 option\n");
	  PrintHelpMessage();
	  }
	gatos_enable_capture(1);
	gatos_capture(argv[ctr+1], -1);
	gatos_enable_capture(0);
	ctr+=1;
	}
      else if(!strcmp(argv[ctr], "tvout")) {
	if(argc < ctr+2 || (strcasecmp(argv[ctr+1], "on")
		&& strcasecmp(argv[ctr+1], "off")))  {
	  gatos_settvout(1-gatos_tvout());
	  }
	else {
	  if(!strcasecmp(argv[ctr+1], "on")) {
	    gatos_settvout(1); ++ctr;
	    }
	  else if(!strcasecmp(argv[ctr+1], "off")) {
	    gatos_settvout(0); ++ctr;
	    }
	  else {
	    fprintf(stderr, "Error: bad command in bad place \"%s\"\n", argv[ctr+1]);
	    PrintHelpMessage();
	    }
	  }
	}
      else {
	fprintf(stderr, "Error: unknown command \"%s\"\n", argv[ctr]);
	PrintHelpMessage();
	}
      }
    }
  gatos_terminate();
  return 0;
  }

void PrintHelpMessage() {
  printf("USAGE: atitv [options] <command> [[options] <command>]...\n");
  printf("\nOptions:\n");
  printf("  -h --help:      Get help (this message).\n");
  printf("  --version:      Get version info.\n");
//  printf("  -l <line>:      Specify which mixer line ATI card is connected to.\n");
  printf("  -m <mux>:       Specify which input to use (Composite, SVHS or TV).\n");
  printf("  -v <volume>:    Set volume.\n");
  printf("  -c <channel>:   Set channel.\n");
  printf("\nCommands:\n");
  printf("  rec <n> <f>:    record for n seconds to filename f.\n");
  printf("  snap <f>:       capture a single frame to filename f.\n");
  printf("  tvout [on|off]: Turn tv-out signal on/off [not yet functional].\n");
  printf("\nFor Example:\n");
  printf("  atitv -c 10 rec 10 f1.yuv -c 11 rec 10 f2.yuv\n");
  printf("    -This will change to channel 10, record 10 seconds to \"f1.yuv\"\n");
  printf("     then change to channel 11 and record 10 seconds to \"f2.yuv\"\n");
  printf("  atitv -m SVHS snap pic.yuv\n");
  printf("    -This will change to the SVHS connector and capture one frame\n");
  printf("     to \"pic.yuv\"\n");
  gatos_terminate();
  exit(1);
  }

