#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

#include "pat.h"

#define PAT_BUFSIZ 1024

/*
 * subroutines for load_anode()
 */
pat_index_list *malloc_pat_index_list()
{
    static int idx = 1024;
    static pat_index_list *ptr;

    if (idx == 1024) {
	ptr = (pat_index_list *)malloc(sizeof(pat_index_list) * idx);
	idx = 0;
    }

    return (pat_index_list *)ptr + idx++;
}

pat_node *malloc_pat_node()
{
    static int idx = 1024;
    static pat_node *ptr;

    if (idx == 1024) {
	ptr = (pat_node *)malloc(sizeof(pat_node) * idx);
	idx = 0;
    }

    return (pat_node *)ptr + idx++;
}

static void eputc(c, file_discripter)
  int c, file_discripter;
{
  static int ctr = 0;
  static unsigned char buf[PAT_BUFSIZ];

  buf[ctr] = c;
  ctr++;

  if(ctr == PAT_BUFSIZ){
    ctr = 0;
    write(file_discripter, buf, PAT_BUFSIZ);
  }

  return;
}

static void dummy(fd)
  int fd;
{
  eputc(0xff,fd);
  eputc(0xff,fd);
  eputc(0xff,fd);
  eputc(0xff,fd);
}

static unsigned char egetc(fd)
  int fd;
{
  static int fd_check = -1;
  static char buf[PAT_BUFSIZ];
  static int ctr = sizeof(buf) - 1;

  if(fd != fd_check) { /* Хåեν */
    fd_check = fd;
    ctr = sizeof(buf) - 1;
  }

  if(++ctr == sizeof(buf)){
    ctr = 0;
    read(fd, buf, sizeof(buf));
#if 0
    OL(.);fflush(stdout);
#endif
  }

  return(buf[ctr]);
}

/****************************************************
* load_anode --- ѥȥꥷڤ
*  by û(keiji-y@is.aist-nara.ac.jp)
*
* ѥ᡼
*   in --- ե
*   p_ptr --- ΥΡɤǤä˥ǥåǼ
*             ǤäȤϡΥݥ󥿤ϱλҤϤ롣
*
* 르ꥺ
*   åӥåȤɤ߹顢鿷Ρɤ
*     ʬڡʬڤν˺Ƶ
*     ƵλϿäΥݥ󥿤
*     Ƶλ p_ptr 򥤥ǥåγǼȤϤ
*   ǥåɤ߹顢ϳ顢p_ptr->index ˳Ǽ
*
* 
*   ǥåγǼ꤬Ȱ㤦äʤ
*************************************************************************/
pat_node *load_anode(p_ptr, fd)
  pat_node *p_ptr;
  int fd;
{
    unsigned char c;
  pat_node *new_ptr; /* äΡ(==ΥΡ)ؤݥ */
  long tmp_idx;
  pat_index_list *new_l_ptr,*t_ptr=NULL;

#if 0
static int dbg;
if (!(++dbg%1000))printf("%d,",dbg);
#endif

  if ((c = egetc(fd)) & 0x80) { /* դäѤνǥåɤ߹ */
    while(c & 0x80) {
      tmp_idx = (c & 0x3f) << 24;
      tmp_idx |= egetc(fd) << 16;
      tmp_idx |= egetc(fd) << 8;
      tmp_idx |= egetc(fd);

      if((p_ptr->il).index < 0)
	new_l_ptr = &(p_ptr->il);
      else {
	new_l_ptr = malloc_pat_index_list();
	t_ptr->next = new_l_ptr;
      }
      new_l_ptr->index = tmp_idx;
      new_l_ptr->next = NULL;
      t_ptr = new_l_ptr;

      if(c & 0x40) break;
      c = egetc(fd);
    }

    return (p_ptr);
  }
  else { /* νƵ */
    new_ptr = malloc_pat_node();
    new_ptr->checkbit = ((c << 8) | egetc(fd)) - 1; /* åӥå */
#if 0
    printf("#cb %d\n",new_ptr->checkbit);
#endif
    (new_ptr->il).index = -1;
    new_ptr->left = load_anode(new_ptr, fd);
    new_ptr->right = load_anode(p_ptr, fd);
    return (new_ptr);
  }
}

/******************************************************
* com_l --- ڤΥ
*  by û(keiji-y@is.aist-nara.ac.jp)
*
* ѥ᡼֤
*   ʤ
******************************************************/
void com_l(fname_pat, ptr)
  char *fname_pat;
  pat_node *ptr;
{
  int fd;

#if 0
  fprintf(stderr, "# Loading pat-tree \"%s\" ... ",fname_pat);
#endif

  if ((fd = open(fname_pat, O_RDONLY | O_BINARY)) == -1) {
    fprintf(stderr, "ե %s ץޤ\n",fname_pat);
    exit(1);
  }
  OL(fd)OI(fd)
  ptr->right = load_anode(ptr, fd);
  close(fd);
#if 0
  fprintf(stderr,"done.\n");
#endif
}

/****************************************************
* save_pat --- ѥȥꥷڥǡ򥻡 
*  by û(keiji-y@is.aist-nara.ac.jp)
*
* ѥ᡼
*   top_ptr --- ϥΡɤΰ(ݥ)
*   out_to --- (stdoutե)
* 
* ֤
*   ̵ѥȥꥷڥǡϡ
*
* ϥեޥå --- 8ӥåȤ˶ڤäƥХʥ
*   ͥõϥåӥåȡϥǥå
*   åӥå --- ŪˤΤޤ ( 0 ӥåȤ 0)
*      -1 ΤȤΤ 1 ­
*   ǥå ---  0 ӥåȤ 1 ˤ
****************************************************/
static void save_pat(top_ptr, fd)
  pat_node *top_ptr;
  int fd;
{
  pat_index_list *ptr;
  long out_idx;

  /* νåӥåȤ */
  eputc (((top_ptr->checkbit + 1)>> 8) & 0x7f, fd);
  eputc ((top_ptr->checkbit + 1)& 0xff, fd);

  /*  Subtree νդäѤʤ饤ǥåϡ
     դäѤǤʤкƵ*/
  if(top_ptr->checkbit < top_ptr->left->checkbit)
    save_pat(top_ptr->left, fd);
  else {
    ptr = &(top_ptr->left->il);
    if(ptr->index < 0) dummy(fd);
    else {
      while(ptr != NULL) {
	if(ptr->next == NULL) eputc (((ptr->index >> 24) & 0x3f) | 0xc0, fd);
	else eputc (((ptr->index >> 24) & 0x3f) | 0x80, fd);
	eputc ((ptr->index >> 16) & 0xff, fd);
	eputc ((ptr->index >> 8) & 0xff, fd);
	eputc ((ptr->index) & 0xff, fd);
	ptr = ptr->next;
      }
    }
  }
  if(top_ptr->checkbit < top_ptr->right->checkbit)
    save_pat(top_ptr->right, fd);
  else {
    ptr = &(top_ptr->right->il);
    if(ptr->index < 0) dummy(fd);
    else {
      while(ptr != NULL) {
	if(ptr->next == NULL) eputc (((ptr->index >> 24) & 0x3f) | 0xc0, fd);
	else eputc (((ptr->index >> 24) & 0x3f) | 0x80, fd);
	eputc ((ptr->index >> 16) & 0xff, fd);
	eputc ((ptr->index >> 8) & 0xff, fd);
	eputc ((ptr->index) & 0xff, fd);
	ptr = ptr->next;
      }
    }
  }

  return;
}

/*****************************************************
* com_s --- ڤΥ 
*  by û(keiji-y@is.aist-nara.ac.jp)
*
* ѥ᡼֤
*   ʤ
*****************************************************/
void com_s(fname_pat, ptr)
  char *fname_pat;
  pat_node *ptr;
{
  int i, fd;

  printf("Saving pat-tree \"%s\" ...\n",fname_pat);
  if ((fd = open(fname_pat, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0644)) == -1) {
    fprintf(stderr, "ե %s ץޤ\n", fname_pat);
    exit(1);
  }; 
  save_pat(ptr->right, fd); /* ե */
  for(i = 0; i < PAT_BUFSIZ; i++)
    eputc(0, fd); /* flush */
  close(fd);
}

