#!/bin/bash

ERRFILE=gettypes.out

egrep -v description= /etc/mailcap | grep -v '/\*' >$TMPDIR/nodesc.mime
cat /etc/mailcap | grep -v '/\*' |
grep description= |
sed 's/^\([^;]*\).*description=\([^;]*\).*/\1:\2/
s/"//g' |
awk -F: '{printf(" INSERT INTO mimetype VALUES ('\''%s'\'','\''%s'\'');\n",$1,$2);'} |
psql -d barracuda 2>&1 | cat >$TMPDIR/$ERRFILE

cat $TMPDIR/nodesc.mime |
egrep -v "^(#|$)" |
sed 's/^\([^;]*\).*/\1:\1/' |
awk -F: '{printf(" INSERT INTO mimetype VALUES ('\''%s'\'','\''%s'\'');\n",$1,$2);'} |
psql -d barracuda 2>&1 | cat >>$TMPDIR/$ERRFILE

rm -f $TMPDIR/nodesc.mime

if [ -f $TMPDIR/$ERRFILE ];
then
	SUCCESS=`echo "SELECT COUNT(*) FROM mimetype;" | psql -qd barracuda | tail +3 | head -1`
	FAILED=`grep ERROR $TMPDIR/$ERRFILE|wc -l`
	echo
	echo "$SUCCESS mimetype successfully loaded / $FAILED failed."
	echo -n "Do you want to examine the error file ($TMPDIR/$ERRFILE) (y/N) ? "
	read ANS
	if [ -z "$ANS" -o "$ANS" = "N" -o "$ANS" = "n" ];
	then
		rm -f $TMPDIR/$ERRFILE
		echo "$TMPDIR/$ERRFILE has been removed."
		echo
	fi
fi
