
#ifndef __transforms_h__
#define __transforms_h__

template<class T>
class ClampPosition
{
public:
  inline ClampPosition(CTriage& aTriage) : iTriage(aTriage),iNext(aTriage) {};
  inline void PutPixel(PlatInt x, PlatInt y, PlatInt z, PlatPixel aColor)
  {
    if (x>=0)
        if (y>=0)
            if (x<iTriage.Texture().Width())
                if (y<iTriage.Texture().Height())
                    iNext.PutPixel(x,y,z,aColor);
  }
private:
  CTriage& iTriage;
  T iNext;
};

template<class T>
class ZBuffer
{
public:
  inline ZBuffer(CTriage& aTriage) : iTriage(aTriage),iNext(aTriage) {};
  inline void PutPixel(PlatInt x, PlatInt y, PlatInt z, PlatPixel aColor)
  {
    PlatInt backz = iTriage.Depth().GetPixel(x,y);

    if (iTriage.Flag(KFlagMoreDepth))
    { //MoreDepth

      if (z >= backz)
      {
          iTriage.Depth().GetPixel(x,y) = z;
          iNext.PutPixel(x, y, z, aColor);
      }
    }
    else if (iTriage.Flag(KFlagLessDepth))
    { //LessDepth
      if (z <= backz)
      {
          iTriage.Depth().GetPixel(x,y) = z;
          iNext.PutPixel(x, y, z, aColor);
      }
    }
    else
    {
        iNext.PutPixel(x, y, z, aColor);
    }
  }
private:
  CTriage& iTriage;
  T iNext;
};


template<class T>
class AlphaBlend
{
public:
  inline AlphaBlend(CTriage& aTriage) : iTriage(aTriage),iNext(aTriage) {};
  inline void PutPixel(PlatInt x, PlatInt y, PlatInt z, PlatPixel aColor)
  {
    // Alpha blending
    PlatPixel back = iTriage.Texture().GetPixel(x,y);
    PlatInt weight = Alpha(aColor);
    weight<<=8;
    iNext.PutPixel(x,y,z,Mix(back,aColor,weight));
  }
private:
  CTriage& iTriage;
  T iNext;
};


class WritePixel
{
public:
  inline WritePixel(CTriage& aTriage) : iTriage(aTriage) {};
  inline void PutPixel(PlatInt x, PlatInt y, PlatInt z, PlatPixel aColor)
  {
    iTriage.Texture().GetPixel(x,y) = aColor;
  }
private:
  CTriage& iTriage;
};

#endif

