
/*
 * Example terminal client for the yacas Computer Algebra library.
 * It is heavily tailored to Unix (Linux), but you should be able
 * to easily make a version that links with libyacas.a and provides
 * an interface for a different platform.
 * The platform-dependent parts are readline.cpp (which maintains
 * a history for keyed-in expressions on the command line), and
 * the directories it looks in for input files.
 */

#include <stdio.h>
#include "yacas.h"

#include "unixcommandline.h"
#include "standard.h"
#include "ramdisk.h" //TODO keep this?

CYacas* yacas=NULL;


void ReportNrCurrent()
{
#ifdef LISP_DEBUGHEAP
    extern long theNrCurrent;
    extern long theNrConstructed;
    extern long theNrDestructed;
    extern long theNrTokens;
    extern long theNrDefinedBuiltIn;
    extern long theNrDefinedUser;
    printf("left-over: %ld objects\n",theNrCurrent);
    printf("%ld constructed, %ld destructed\n",theNrConstructed,theNrDestructed);
    printf("nr tokens: %ld \n",theNrTokens);
    printf("-------------------------------\n");
    printf("Total %d functions defined (%d built-in, %d user)\n",
           theNrDefinedBuiltIn+theNrDefinedUser,
           theNrDefinedBuiltIn,theNrDefinedUser);
#endif
}


//TODO global!!!
static LispBoolean busy=LispTrue;

LispBoolean Busy()
{
    return busy;
}



void LispExit(LispEnvironment& aEnvironment, LispPtr& aResult,
              LispPtr& aArguments)
{
    busy=LispFalse;
//    Check(0,KQuitting);
    InternalTrue(aEnvironment, aResult);
}


void my_exit(void)
{
    delete yacas;
    ReportNrCurrent();
}

void ShowResult(char *prompt)
{
    if (yacas->Error()[0] != '\0')
    {
        printf("%s\n",yacas->Error());
    }
    else
    {
        printf("%s%s\n",prompt,yacas->Result());
    }
    fflush(stdout);
}


int main(int argc, char** argv)
{
    int line=0;

    /*
     {
        printf("[%d %d]\n",LispHash("\"a\""),
               LispHashStringify( "a" ));
        
    }
    */
    
    yacas = CYacas::NewL();
    atexit(my_exit);

    (*yacas)()().Commands().SetAssociation(LispEvaluator(LispExit),
         (*yacas)()().HashTable().LookUp("Exit"));

    //TODO #include "../ramscripts/some.inc"

    /*TODO test code!!!
    (*yacas)()().iRamDisk.SetAssociation(
      LispRamFile("WriteString(\"Hello world!\");"),
     (*yacas)()().HashTable().LookUp("testfile",LispTrue)
                                        );
    */

    yacas->Evaluate("DefaultDirectory(\"" SCRIPT_DIR "\");");

    yacas->Evaluate("Load(\"yacasinit\");");

    
    
    if (argc>1)
    {
        char s[200];
        sprintf(s,"Load(\"%s\");",argv[1]);
        yacas->Evaluate(s);
        exit(0);
    }
    ShowResult("");

//    load_history("history.log", 0);

    CUnixCommandLine commandline;
    
    printf("To exit Yacas, enter  Exit(); or Ctrl-c. Type ?? for help.\n");
    printf("Or type ?function for help on a function.\n");
    printf("To see example commands, keep typing Example();\n");
    while (Busy())
    {
        char prompt[20];
        sprintf(prompt,"In( %d ) = ",line);

        commandline.ReadLine(prompt);
        char *inpline =  commandline.iLine.String();
        if (inpline)
        {
            if(*inpline)
            {
                if (inpline[0] == '?')
                {
                    if (inpline[1] == '?')
                    {
                        system("lynx " SCRIPT_DIR "documentation/books.html");
                    }
                    else
                    {
                        char buf[1000];
                        // TODO check for buffer overflow!!!
                        strcpy(buf,"lynx "SCRIPT_DIR "documentation/ref.html#");
                        strcat(buf,&inpline[1]);
                        system(buf);
                    }
                }
                else
                {
                    yacas->Evaluate(inpline);
                    char prompt[30];
                    sprintf(prompt,"Out( %d ) = ",line);
                    ShowResult(prompt);
                }
                line++;
            }
        }
    }

    printf("Quiting...\n");
    return 0;
}


